/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.entity.ai.behavior;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.logging.LogUtils;
import com.sighs.touhou_little_maid_epistalove.util.HazardUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public final class AdvancedMovement {
    private static final Logger LOGGER = LogUtils.getLogger();

    private AdvancedMovement() {
    }

    public static boolean forceMoveTo(EntityMaid maid, BlockPos target, double speed) {
        try {
            PathNavigation nav = maid.getNavigation();
            nav.stop();
            Vec3 maidPos = maid.position();
            Vec3 targetPos = new Vec3((double)target.getX() + 0.5, (double)target.getY(), (double)target.getZ() + 0.5);
            Vec3 direction = targetPos.subtract(maidPos);
            double distance = direction.length();
            if (distance < 0.5 && AdvancedMovement.isSafeToTeleport(maid, targetPos)) {
                maid.setPos(targetPos.x, targetPos.y, targetPos.z);
                return true;
            }
            direction = direction.normalize();
            BlockPos nextPos = maid.blockPosition().offset((int)Math.signum(direction.x), 0, (int)Math.signum(direction.z));
            ServerLevel level = (ServerLevel)maid.level();
            PathType pathType = HazardUtil.getBlockPathType((BlockGetter)level, nextPos);
            if (HazardUtil.isPathTypeDangerous(pathType) || !HazardUtil.isSafeForStanding(level, nextPos, (Mob)maid)) {
                return AdvancedMovement.handleUnsafePath(maid, direction, target, speed);
            }
            return AdvancedMovement.handleNormalMovement(maid, direction, speed);
        }
        catch (Exception e) {
            LOGGER.error("[MaidMail] Force move error maidId={}: {}", (Object)maid.getId(), (Object)e.getMessage());
            return false;
        }
    }

    private static boolean isSafeToTeleport(EntityMaid maid, Vec3 targetPos) {
        ServerLevel level = (ServerLevel)maid.level();
        BlockPos pos = BlockPos.containing((Position)targetPos);
        return HazardUtil.isSafeForStanding(level, pos, (Mob)maid);
    }

    private static boolean handleUnsafePath(EntityMaid maid, Vec3 direction, BlockPos target, double speed) {
        ServerLevel level = (ServerLevel)maid.level();
        BlockPos safePos = HazardUtil.findSafestNearbyPosition(level, maid.blockPosition(), 3);
        if (safePos != null) {
            Vec3 safeDirection = new Vec3((double)safePos.getX() + 0.5, (double)safePos.getY(), (double)safePos.getZ() + 0.5).subtract(maid.position()).normalize();
            return AdvancedMovement.handleNormalMovement(maid, safeDirection, speed * 0.8);
        }
        if (direction.y > 0.1) {
            BlockPos up = maid.blockPosition().above();
            if (HazardUtil.isSafeForStanding(level, up, (Mob)maid)) {
                maid.setDeltaMovement(direction.x * 0.1, Math.min(0.3, (double)maid.maxUpStep() + 0.1), direction.z * 0.1);
            } else {
                Vec3 cur = maid.getDeltaMovement();
                maid.setDeltaMovement(direction.x * 0.1, cur.y, direction.z * 0.1);
            }
            return true;
        }
        if (direction.y < -0.1) {
            BlockPos below = maid.blockPosition().below();
            if (HazardUtil.isSafeForStanding(level, below, (Mob)maid)) {
                maid.setDeltaMovement(0.0, -0.1, 0.0);
                return true;
            }
        } else {
            double jumpHeight = Math.min(0.4, (double)maid.maxUpStep() + 0.2);
            maid.setDeltaMovement(direction.x * 0.1, jumpHeight, direction.z * 0.1);
            return true;
        }
        return false;
    }

    private static boolean handleNormalMovement(EntityMaid maid, Vec3 direction, double speed) {
        double moveSpeed = Math.min(speed * 0.15, 0.25);
        ServerLevel level = (ServerLevel)maid.level();
        BlockPos currentPos = maid.blockPosition();
        PathType currentPathType = HazardUtil.getBlockPathType((BlockGetter)level, currentPos);
        double speedMultiplier = AdvancedMovement.getSpeedMultiplierForPathType(currentPathType);
        Vec3 cur = maid.getDeltaMovement();
        maid.setDeltaMovement(direction.x * (moveSpeed *= speedMultiplier), cur.y, direction.z * moveSpeed);
        return true;
    }

    private static double getSpeedMultiplierForPathType(PathType pathType) {
        return switch (pathType) {
            case PathType.WATER -> 0.6;
            case PathType.STICKY_HONEY -> 0.3;
            case PathType.WALKABLE, PathType.OPEN -> 1.0;
            case PathType.LEAVES -> 0.8;
            default -> 0.9;
        };
    }
}

