/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.entity.ai.behavior;

import com.flechazo.contact.common.item.IPackageItem;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.mojang.logging.LogUtils;
import com.sighs.touhou_little_maid_epistalove.component.TLMContactDataComponents;
import com.sighs.touhou_little_maid_epistalove.config.Config;
import com.sighs.touhou_little_maid_epistalove.entity.ai.behavior.AdvancedMovement;
import com.sighs.touhou_little_maid_epistalove.entity.ai.behavior.LetterDeliveryService;
import com.sighs.touhou_little_maid_epistalove.entity.ai.behavior.LetterGenerationService;
import com.sighs.touhou_little_maid_epistalove.util.HazardUtil;
import com.sighs.touhou_little_maid_epistalove.util.MailboxSafetyEvaluator;
import com.sighs.touhou_little_maid_epistalove.util.PathSafetyPlanner;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.Path;
import org.slf4j.Logger;

public class LetterDeliveryBehavior
implements BehaviorControl<EntityMaid> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final double WALK_SPEED = 0.5;
    private static final double RUN_SPEED = 0.7;
    private static final int HANDOVER_RADIUS = 2;
    private static final int REPLAN_COOLDOWN = 40;
    private static final int STAY_MIN = 40;
    private static final int STAY_MAX = 80;
    private Behavior.Status status = Behavior.Status.STOPPED;
    private TargetType targetType = null;
    private BlockPos targetPos = null;
    private int replanCooldown = 0;
    private int stayTick = 0;
    private BlockPos lastPos = null;
    private int noMovementTicks = 0;

    public Behavior.Status getStatus() {
        return this.status;
    }

    public boolean tryStart(ServerLevel level, EntityMaid maid, long gameTime) {
        LetterGenerationService.processMaidLetterGeneration(maid);
        if (!this.hasLetter(maid)) {
            return false;
        }
        this.status = Behavior.Status.RUNNING;
        this.replanCooldown = 0;
        this.lastPos = maid.blockPosition();
        this.noMovementTicks = 0;
        this.targetType = null;
        this.targetPos = null;
        return true;
    }

    public void tickOrStop(ServerLevel level, EntityMaid maid, long gameTime) {
        LetterGenerationService.processMaidLetterGeneration(maid);
        if (!this.hasLetter(maid)) {
            this.doStop(level, maid, gameTime);
            return;
        }
        if (this.stayTick > 0) {
            this.tickStaying(level, maid);
            return;
        }
        if (this.replanCooldown > 0) {
            --this.replanCooldown;
        }
        if (this.targetPos == null || this.replanCooldown <= 0) {
            this.planTarget(level, maid);
            this.replanCooldown = 40;
        }
        if (this.targetPos == null || this.targetType == null) {
            return;
        }
        double distSqr = maid.distanceToSqr((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY(), (double)this.targetPos.getZ() + 0.5);
        if (distSqr <= 4.0) {
            LetterDeliveryService.tryDeliverLetter(maid);
            if (!this.hasLetter(maid)) {
                this.stayTick = 40 + maid.getRandom().nextInt(40);
            } else {
                this.replanCooldown = 40;
            }
            return;
        }
        double dist = Math.sqrt(distSqr);
        double speed = dist > 12.0 ? 0.7 : 0.5;
        boolean moveOk = this.moveToTarget(maid, this.targetPos, speed);
        this.handleMovementTracking(maid, moveOk, level);
    }

    public void doStop(ServerLevel level, EntityMaid maid, long gameTime) {
        maid.getNavigation().stop();
        this.status = Behavior.Status.STOPPED;
        this.targetType = null;
        this.targetPos = null;
        this.replanCooldown = 0;
        this.stayTick = 0;
        this.lastPos = null;
        this.noMovementTicks = 0;
    }

    public String debugString() {
        return "tlm_contact:letter_delivery";
    }

    private boolean hasLetter(EntityMaid maid) {
        return ItemsUtil.isStackIn((EntityMaid)maid, stack -> {
            if (!(stack.getItem() instanceof IPackageItem)) {
                return false;
            }
            return Boolean.TRUE.equals(stack.get((DataComponentType)TLMContactDataComponents.MAID_MAIL.get()));
        });
    }

    private void tickStaying(ServerLevel level, EntityMaid maid) {
        if (--this.stayTick <= 0) {
            this.doStop(level, maid, level.getGameTime());
        }
    }

    private void planTarget(ServerLevel level, EntityMaid maid) {
        PathNavigation nav = maid.getNavigation();
        nav.stop();
        boolean homeMode = maid.isHomeModeEnable();
        ServerPlayer owner = (ServerPlayer)maid.getOwner();
        if (!homeMode) {
            if (owner != null) {
                this.targetType = TargetType.OWNER;
                BlockPos approach = PathSafetyPlanner.findBestApproachPosition(level, owner.blockPosition(), (Mob)maid);
                this.targetPos = approach != null ? approach : owner.blockPosition();
            } else {
                this.targetType = null;
                this.targetPos = null;
                LOGGER.warn("[MaidMail][Delivery] Target suspended - no owner in follow mode maidId={}", (Object)maid.getId());
            }
            return;
        }
        BlockPos homeCenter = maid.getRestrictCenter();
        int homeRadius = Math.max(4, (int)maid.getRestrictRadius());
        boolean ownerInHome = owner != null && maid.closerThan((Entity)owner, (double)homeRadius);
        Optional<MailboxSafetyEvaluator.MailboxInfo> bestMailboxOpt = MailboxSafetyEvaluator.getBestUsableMailbox(level, homeCenter, Math.min((Integer)Config.MAILBOX_SEARCH_RADIUS.get(), homeRadius));
        if (ownerInHome) {
            MailboxSafetyEvaluator.MailboxInfo mailbox;
            if (bestMailboxOpt.isPresent() && ((mailbox = bestMailboxOpt.get()).isHighQuality() || mailbox.safetyScore() >= 60)) {
                this.targetType = TargetType.MAILBOX;
                this.targetPos = mailbox.pos();
                return;
            }
            this.targetType = TargetType.OWNER;
            BlockPos approach = PathSafetyPlanner.findBestApproachPosition(level, owner.blockPosition(), (Mob)maid);
            this.targetPos = approach != null ? approach : owner.blockPosition();
        } else if (bestMailboxOpt.isPresent() && bestMailboxOpt.get().isUsable()) {
            this.targetType = TargetType.MAILBOX;
            this.targetPos = bestMailboxOpt.get().pos();
        } else {
            this.targetType = null;
            this.targetPos = null;
        }
    }

    private boolean moveToTarget(EntityMaid maid, BlockPos target, double speed) {
        try {
            Path currentPath;
            PathNavigation nav = maid.getNavigation();
            double dist = maid.distanceToSqr((double)target.getX() + 0.5, (double)target.getY(), (double)target.getZ() + 0.5);
            if (nav.isInProgress() && (currentPath = nav.getPath()) != null && !currentPath.isDone()) {
                ServerLevel level = (ServerLevel)maid.level();
                if (PathSafetyPlanner.isPositionAccessible(level, maid.blockPosition(), target)) {
                    return true;
                }
                nav.stop();
            }
            if (dist <= 9.0) {
                return this.handleCloseRangeNavigation(maid, target, speed);
            }
            if (dist <= 64.0) {
                return this.handleMediumRangeNavigation(maid, target, speed);
            }
            return this.handleLongRangeNavigation(maid, target, speed);
        }
        catch (Exception e) {
            LOGGER.error("[MaidMail][Delivery] move error maidId={}: {}", (Object)maid.getId(), (Object)e.getMessage());
            return false;
        }
    }

    private boolean handleCloseRangeNavigation(EntityMaid maid, BlockPos target, double speed) {
        PathNavigation nav = maid.getNavigation();
        boolean result = nav.moveTo((double)target.getX() + 0.5, (double)target.getY(), (double)target.getZ() + 0.5, speed);
        if (!result) {
            BlockPos[] nearTargets;
            ServerLevel level = (ServerLevel)maid.level();
            for (BlockPos nearTarget : nearTargets = new BlockPos[]{target.north(), target.south(), target.east(), target.west(), target.above(), target.below()}) {
                boolean nearResult;
                if (!HazardUtil.isSafeForStanding(level, nearTarget, (Mob)maid) || !(nearResult = nav.moveTo((double)nearTarget.getX() + 0.5, (double)nearTarget.getY(), (double)nearTarget.getZ() + 0.5, speed))) continue;
                return true;
            }
            return AdvancedMovement.forceMoveTo(maid, target, speed);
        }
        return true;
    }

    private boolean handleMediumRangeNavigation(EntityMaid maid, BlockPos target, double speed) {
        PathNavigation nav = maid.getNavigation();
        boolean directResult = nav.moveTo((double)target.getX() + 0.5, (double)target.getY(), (double)target.getZ() + 0.5, speed);
        if (directResult) {
            return true;
        }
        BlockPos[] nearTargets = new BlockPos[]{target.north(), target.south(), target.east(), target.west(), target.above(), target.below()};
        ServerLevel level = (ServerLevel)maid.level();
        for (BlockPos nearTarget : nearTargets) {
            boolean nearResult;
            if (!HazardUtil.isSafeForStanding(level, nearTarget, (Mob)maid) || !(nearResult = nav.moveTo((double)nearTarget.getX() + 0.5, (double)nearTarget.getY(), (double)nearTarget.getZ() + 0.5, speed))) continue;
            return true;
        }
        return AdvancedMovement.forceMoveTo(maid, target, speed);
    }

    private boolean handleLongRangeNavigation(EntityMaid maid, BlockPos target, double speed) {
        boolean pathResult;
        PathNavigation nav = maid.getNavigation();
        Path path = PathSafetyPlanner.planSimpleAvoidancePath((Mob)maid, target);
        if (path != null && (pathResult = nav.moveTo(path, speed))) {
            return true;
        }
        boolean finalResult = nav.moveTo((double)target.getX() + 0.5, (double)target.getY(), (double)target.getZ() + 0.5, speed);
        if (!finalResult) {
            return AdvancedMovement.forceMoveTo(maid, target, speed);
        }
        return true;
    }

    private void handleMovementTracking(EntityMaid maid, boolean moveOk, ServerLevel level) {
        BlockPos cur = maid.blockPosition();
        if (cur.equals((Object)this.lastPos)) {
            ++this.noMovementTicks;
        } else {
            this.noMovementTicks = 0;
            this.lastPos = cur;
        }
        if (!moveOk || this.noMovementTicks > 80) {
            this.planTarget(level, maid);
            this.replanCooldown = 40;
            this.noMovementTicks = 0;
        }
        PathNavigation nav = maid.getNavigation();
        boolean navInProgress = nav.isInProgress();
        boolean isStuck = false;
        if (!moveOk) {
            isStuck = true;
        } else if (this.noMovementTicks > 60) {
            isStuck = true;
        } else if (!navInProgress && this.noMovementTicks > 20) {
            isStuck = true;
        }
        if (isStuck) {
            nav.stop();
            this.planTarget(level, maid);
            this.replanCooldown = 40;
            this.noMovementTicks = 0;
        }
    }

    private static enum TargetType {
        MAILBOX,
        OWNER;

    }
}

