/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.entity.ai.behavior;

import com.flechazo.contact.common.component.ContactDataComponents;
import com.flechazo.contact.common.handler.MailboxManager;
import com.flechazo.contact.common.item.IPackageItem;
import com.flechazo.contact.common.item.PostcardItem;
import com.flechazo.contact.common.storage.MailToBeSent;
import com.flechazo.contact.common.storage.MailboxDataManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.mojang.logging.LogUtils;
import com.sighs.touhou_little_maid_epistalove.component.TLMContactDataComponents;
import com.sighs.touhou_little_maid_epistalove.config.Config;
import com.sighs.touhou_little_maid_epistalove.util.MailboxSafetyEvaluator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.slf4j.Logger;

public final class LetterDeliveryService {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int OWNER_HANDOVER_DISTANCE = 3;

    private LetterDeliveryService() {
    }

    public static void tryDeliverLetter(EntityMaid maid) {
        boolean ownerInHome;
        Level level = maid.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        ServerPlayer owner = (ServerPlayer)maid.getOwner();
        if (owner == null) {
            return;
        }
        if (!LetterDeliveryService.hasLetter(maid)) {
            return;
        }
        ItemStack parcel = LetterDeliveryService.getMarkedParcel(maid);
        if (parcel.isEmpty()) {
            return;
        }
        boolean homeMode = maid.isHomeModeEnable();
        BlockPos homeCenter = maid.getRestrictCenter();
        int homeRadius = Math.max(4, (int)maid.getRestrictRadius());
        boolean bl = ownerInHome = homeMode && maid.closerThan((Entity)owner, (double)homeRadius);
        if (!homeMode) {
            LetterDeliveryService.handToOwnerIfNear(maid, owner, parcel);
            return;
        }
        if (LetterDeliveryService.tryDeliverViaMailbox(maid, level2, owner, parcel, homeCenter, homeRadius)) {
            return;
        }
        if (ownerInHome) {
            LetterDeliveryService.handToOwnerIfNear(maid, owner, parcel);
        }
    }

    private static boolean tryDeliverViaMailbox(EntityMaid maid, ServerLevel level, ServerPlayer owner, ItemStack parcel, BlockPos homeCenter, int homeRadius) {
        boolean sent;
        BlockPos pos;
        double distSqr;
        Optional<MailboxSafetyEvaluator.MailboxInfo> mailboxOpt = MailboxSafetyEvaluator.getBestUsableMailbox(level, homeCenter, Math.min((Integer)Config.MAILBOX_SEARCH_RADIUS.get(), homeRadius));
        if (mailboxOpt.isPresent() && (distSqr = maid.distanceToSqr((double)(pos = mailboxOpt.get().pos()).getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5)) <= 9.0 && (sent = LetterDeliveryService.sendViaPostbox(level, owner, parcel, pos, maid))) {
            LetterDeliveryService.removeOneMarkedParcel(maid);
            return true;
        }
        return false;
    }

    private static void handToOwnerIfNear(EntityMaid maid, ServerPlayer owner, ItemStack parcel) {
        double ownerDistSqr = maid.distanceToSqr((Entity)owner);
        if (ownerDistSqr <= 9.0) {
            String senderName = maid.getName().getString();
            ItemStack parcelCopy = parcel.copy();
            parcelCopy.set((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get(), (Object)senderName);
            ItemContainerContents contents = (ItemContainerContents)parcelCopy.get(DataComponents.CONTAINER);
            if (contents != null) {
                for (ItemStack item : contents.nonEmptyItems()) {
                    if (!(item.getItem() instanceof PostcardItem)) continue;
                    item.set((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get(), (Object)senderName);
                }
            }
            ItemHandlerHelper.giveItemToPlayer((Player)owner, (ItemStack)parcelCopy);
            LetterDeliveryService.removeOneMarkedParcel(maid);
        }
    }

    private static boolean sendViaPostbox(ServerLevel level, ServerPlayer owner, ItemStack parcel, BlockPos postboxPos, EntityMaid maid) {
        GlobalPos from = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)postboxPos);
        GlobalPos to = MailboxDataManager.getData((Level)level).getMailboxPos(owner.getUUID());
        ItemStack parcelCopy = parcel.copy();
        String senderName = maid.getName().getString();
        parcelCopy.set((DataComponentType)ContactDataComponents.POSTCARD_SENDER.get(), (Object)senderName);
        if (IPackageItem.checkAndPostmarkPostcard((ItemStack)parcelCopy, (String)senderName) || parcelCopy.getItem() instanceof PostcardItem) {
            // empty if block
        }
        if (to != null) {
            if (to.dimension() != level.dimension()) {
                parcelCopy.set((DataComponentType)ContactDataComponents.ANOTHER_WORLD.get(), (Object)true);
            }
        } else if (Level.OVERWORLD != level.dimension()) {
            parcelCopy.set((DataComponentType)ContactDataComponents.ANOTHER_WORLD.get(), (Object)true);
        }
        int ticks = to != null ? MailboxManager.getDeliveryTicks((GlobalPos)from, (GlobalPos)to) : 0;
        MailToBeSent mailToBeSent = new MailToBeSent(owner.getUUID(), parcelCopy, (long)ticks);
        MailboxDataManager.getData((Level)level).getMailList().add(mailToBeSent);
        return true;
    }

    private static boolean hasLetter(EntityMaid maid) {
        return ItemsUtil.isStackIn((EntityMaid)maid, stack -> {
            if (!(stack.getItem() instanceof IPackageItem)) {
                return false;
            }
            return Boolean.TRUE.equals(stack.get((DataComponentType)TLMContactDataComponents.MAID_MAIL.get()));
        });
    }

    private static ItemStack getMarkedParcel(EntityMaid maid) {
        return ItemsUtil.getStack((EntityMaid)maid, s -> {
            if (!(s.getItem() instanceof IPackageItem)) {
                return false;
            }
            return Boolean.TRUE.equals(s.get((DataComponentType)TLMContactDataComponents.MAID_MAIL.get()));
        });
    }

    private static void removeOneMarkedParcel(EntityMaid maid) {
        ItemStack existing = LetterDeliveryService.getMarkedParcel(maid);
        if (!existing.isEmpty()) {
            existing.shrink(1);
        }
    }
}

