/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.entity.ai.behavior;

import com.flechazo.contact.common.item.IPackageItem;
import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.mojang.logging.LogUtils;
import com.sighs.touhou_little_maid_epistalove.api.letter.ILetterRule;
import com.sighs.touhou_little_maid_epistalove.api.trigger.ITriggerManager;
import com.sighs.touhou_little_maid_epistalove.component.TLMContactDataComponents;
import com.sighs.touhou_little_maid_epistalove.data.DataPackLetterRuleAdapter;
import com.sighs.touhou_little_maid_epistalove.data.LetterRule;
import com.sighs.touhou_little_maid_epistalove.data.LetterRuleRegistry;
import com.sighs.touhou_little_maid_epistalove.trigger.TriggerManager;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.fml.loading.FMLLoader;
import org.slf4j.Logger;

public final class LetterGenerationService {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static TaskDataKey<CompoundTag> RUNTIME_DATA_KEY;
    private static final ITriggerManager TRIGGER_MANAGER;

    private LetterGenerationService() {
    }

    public static void setDataKey(TaskDataKey<CompoundTag> key) {
        RUNTIME_DATA_KEY = key;
    }

    public static void processMaidLetterGeneration(EntityMaid maid) {
        Level level = maid.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ServerPlayer owner = (ServerPlayer)maid.getOwner();
        if (owner == null) {
            return;
        }
        if (maid.tickCount % 10 != 0) {
            return;
        }
        if (LetterGenerationService.hasLetter(maid)) {
            return;
        }
        if (maid.tickCount % 200 == 0 && !FMLLoader.isProduction()) {
            LetterGenerationService.logCooldownInfo(maid, serverLevel, owner);
        }
        LetterGenerationService.pruneUnmatchedTriggers(owner, maid);
        List<ILetterRule> candidates = LetterRuleRegistry.getMatchingRules(owner, maid, serverLevel.getGameTime());
        for (ILetterRule rule : candidates) {
            if (LetterGenerationService.isOnCooldown(maid, rule, serverLevel.getGameTime()) || "ai".equals(rule.getType()) && !LetterGenerationService.markAIPending(maid, rule)) continue;
            rule.generateLetter(owner, maid, result -> {
                boolean success;
                boolean bl = success = !result.isEmpty();
                if (success) {
                    ItemsUtil.giveItemToMaid((EntityMaid)maid, (ItemStack)result);
                    LetterGenerationService.setCooldown(maid, rule, serverLevel.getGameTime(), rule.getCooldown());
                    LetterGenerationService.applyFavorabilityChange(maid, rule);
                    if (rule instanceof LetterRule) {
                        LetterRule letterRule = (LetterRule)rule;
                        letterRule.consumeTriggers(owner);
                    } else if (rule instanceof DataPackLetterRuleAdapter) {
                        DataPackLetterRuleAdapter adapter = (DataPackLetterRuleAdapter)rule;
                        adapter.consumeTriggers(owner);
                    }
                } else {
                    LOGGER.warn("[MaidMail] Letter generation failed maidId={} rule={} type={}", new Object[]{maid.getId(), rule.getId(), rule.getType()});
                }
                if ("ai".equals(rule.getType())) {
                    LetterGenerationService.clearAIPending(maid, rule);
                }
            });
            break;
        }
    }

    private static void pruneUnmatchedTriggers(ServerPlayer owner, EntityMaid maid) {
        List<ILetterRule> allRules = LetterRuleRegistry.getAllRules();
        HashSet<ResourceLocation> activeTriggers = new HashSet<ResourceLocation>();
        for (ILetterRule rule : allRules) {
            for (ResourceLocation tid : rule.getTriggers()) {
                if (!TRIGGER_MANAGER.hasTriggered(owner, tid)) continue;
                activeTriggers.add(tid);
            }
        }
        if (activeTriggers.isEmpty()) {
            return;
        }
        for (ResourceLocation tid : activeTriggers) {
            boolean useBySomeMatchingRule = false;
            for (ILetterRule rule : allRules) {
                boolean ruleContainsTrigger = false;
                for (ResourceLocation rtid : rule.getTriggers()) {
                    if (!rtid.equals((Object)tid)) continue;
                    ruleContainsTrigger = true;
                    break;
                }
                if (!ruleContainsTrigger || !LetterGenerationService.staticConstraintsSatisfied(rule, maid)) continue;
                useBySomeMatchingRule = true;
                break;
            }
            if (useBySomeMatchingRule) continue;
            TRIGGER_MANAGER.clearTriggered(owner, tid);
        }
    }

    private static boolean staticConstraintsSatisfied(ILetterRule rule, EntityMaid maid) {
        int affection = maid.getFavorability();
        Integer max = rule.getMaxAffection();
        if (affection < rule.getMinAffection()) {
            return false;
        }
        if (max != null && affection > max) {
            return false;
        }
        List<ResourceLocation> requiredIds = null;
        if (rule instanceof LetterRule) {
            LetterRule lr = (LetterRule)rule;
            requiredIds = lr.getRequiredMaidIds();
        } else if (rule instanceof DataPackLetterRuleAdapter) {
            DataPackLetterRuleAdapter adp = (DataPackLetterRuleAdapter)rule;
            requiredIds = adp.getRequiredMaidIds();
        }
        if (requiredIds != null && !requiredIds.isEmpty()) {
            String modelIdStr = maid.getModelId();
            ResourceLocation maidModel = !modelIdStr.isEmpty() ? ResourceLocation.parse((String)modelIdStr) : null;
            return maidModel != null && requiredIds.contains(maidModel);
        }
        return true;
    }

    private static boolean hasLetter(EntityMaid maid) {
        return ItemsUtil.isStackIn((EntityMaid)maid, stack -> {
            if (!(stack.getItem() instanceof IPackageItem)) {
                return false;
            }
            return Boolean.TRUE.equals(stack.get((DataComponentType)TLMContactDataComponents.MAID_MAIL.get()));
        });
    }

    private static void logCooldownInfo(EntityMaid maid, ServerLevel serverLevel, ServerPlayer owner) {
        List<ILetterRule> rules = LetterRuleRegistry.getMatchingRules(owner, maid, serverLevel.getGameTime());
        for (ILetterRule rule : rules) {
            int remain = LetterGenerationService.getCooldownRemaining(maid, rule, serverLevel.getGameTime());
            if (remain <= 0 || FMLLoader.isProduction()) continue;
            LOGGER.debug("[MaidMail] cooldown maidId={} rule={} remaining={}", new Object[]{maid.getId(), rule.getId(), remain});
        }
    }

    private static boolean markAIPending(EntityMaid maid, ILetterRule rule) {
        String key;
        if (RUNTIME_DATA_KEY == null) {
            LOGGER.warn("[MaidMail] RUNTIME_DATA_KEY not set; cannot mark AI pending maidId={} rule={}", (Object)maid.getId(), (Object)rule.getId());
            return false;
        }
        CompoundTag data = (CompoundTag)maid.getOrCreateData(RUNTIME_DATA_KEY, (Object)new CompoundTag());
        if (data.getBoolean(key = "ai_pending_" + rule.getId().replace(":", "_"))) {
            return false;
        }
        data.putBoolean(key, true);
        maid.setAndSyncData(RUNTIME_DATA_KEY, (Object)data);
        return true;
    }

    private static void clearAIPending(EntityMaid maid, ILetterRule rule) {
        if (RUNTIME_DATA_KEY == null) {
            return;
        }
        CompoundTag data = (CompoundTag)maid.getOrCreateData(RUNTIME_DATA_KEY, (Object)new CompoundTag());
        String key = "ai_pending_" + rule.getId().replace(":", "_");
        data.putBoolean(key, false);
        maid.setAndSyncData(RUNTIME_DATA_KEY, (Object)data);
    }

    private static boolean isOnCooldown(EntityMaid maid, ILetterRule rule, long nowTick) {
        if (RUNTIME_DATA_KEY == null) {
            return false;
        }
        CompoundTag data = (CompoundTag)maid.getOrCreateData(RUNTIME_DATA_KEY, (Object)new CompoundTag());
        String key = "cd_" + rule.getId().replace(":", "_");
        long last = data.getLong(key);
        Integer cd = rule.getCooldown();
        return cd != null && cd > 0 && last > 0L && nowTick - last < (long)cd.intValue();
    }

    private static void setCooldown(EntityMaid maid, ILetterRule rule, long nowTick, Integer cooldown) {
        if (RUNTIME_DATA_KEY == null || cooldown == null || cooldown <= 0) {
            return;
        }
        CompoundTag data = (CompoundTag)maid.getOrCreateData(RUNTIME_DATA_KEY, (Object)new CompoundTag());
        String key = "cd_" + rule.getId().replace(":", "_");
        data.putLong(key, nowTick);
        maid.setAndSyncData(RUNTIME_DATA_KEY, (Object)data);
    }

    private static int getCooldownRemaining(EntityMaid maid, ILetterRule rule, long nowTick) {
        if (RUNTIME_DATA_KEY == null) {
            return 0;
        }
        CompoundTag data = (CompoundTag)maid.getOrCreateData(RUNTIME_DATA_KEY, (Object)new CompoundTag());
        String key = "cd_" + rule.getId().replace(":", "_");
        long last = data.getLong(key);
        Integer cd = rule.getCooldown();
        if (cd == null || cd <= 0 || last <= 0L) {
            return 0;
        }
        long elapsed = nowTick - last;
        return Math.max(0, cd - (int)elapsed);
    }

    private static void applyFavorabilityChange(EntityMaid maid, ILetterRule rule) {
        Integer delta = rule.getFavorabilityChange();
        Integer threshold = rule.getFavorabilityThreshold();
        int current = maid.getFavorability();
        LOGGER.debug("[MaidMail] Favorability change start: maid={} rule={} delta={} threshold={} current={}", new Object[]{maid.getName().getString(), rule.getId(), delta, threshold, current});
        if (delta == null || delta == 0) {
            LOGGER.debug("[MaidMail] Skip change: delta is null or zero");
            return;
        }
        FavorabilityManager fm = maid.getFavorabilityManager();
        if (delta > 0) {
            if (threshold != null && current >= threshold) {
                LOGGER.debug("[MaidMail] Skip add: current {} >= threshold {}", (Object)current, (Object)threshold);
                return;
            }
            int target = threshold != null ? Math.min(current + delta, threshold) : current + delta;
            fm.add(Math.max(0, target - current));
        } else {
            if (threshold != null && current <= threshold) {
                LOGGER.debug("[MaidMail] Skip reduce: current {} <= threshold {}", (Object)current, (Object)threshold);
                return;
            }
            int target = threshold != null ? Math.max(current + delta, threshold) : current + delta;
            fm.reduceWithoutLevel(Math.max(0, current - target));
        }
        LOGGER.debug("[MaidMail] Favorability changed: before={} after={}", (Object)current, (Object)maid.getFavorability());
    }

    static {
        TRIGGER_MANAGER = TriggerManager.getInstance();
    }
}

