/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.event;

import com.sighs.touhou_little_maid_epistalove.api.letter.ILetterRule;
import com.sighs.touhou_little_maid_epistalove.data.LetterRuleRegistry;
import com.sighs.touhou_little_maid_epistalove.trigger.TriggerManager;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber
public class ModEventHandler {
    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            TriggerManager.getInstance().clearAllTriggered(sp);
        }
    }

    @SubscribeEvent
    public static void onAdvancementEarned(AdvancementEvent.AdvancementEarnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            TriggerManager.getInstance().markTriggered(sp, event.getAdvancement().id());
        }
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        List<ILetterRule> rules = LetterRuleRegistry.getAllRules();
        TriggerManager triggerManager = TriggerManager.getInstance();
        MinecraftServer server = event.getPlayerList().getServer();
        for (ServerPlayer sp : event.getPlayerList().getPlayers()) {
            for (ILetterRule rule : rules) {
                if (rule.getTriggerType() != ILetterRule.TriggerType.REPEAT) continue;
                for (ResourceLocation triggerId : rule.getTriggers()) {
                    boolean isAdv;
                    boolean bl = isAdv = server.getAdvancements().get(triggerId) != null;
                    if (isAdv) continue;
                    ResourceLocation consumeKey = ResourceLocation.fromNamespaceAndPath((String)"internal", (String)("custom_" + rule.getId().replace(":", "_") + "_" + triggerId.toString().replace(":", "_")));
                    triggerManager.clearConsumedOnce(sp, consumeKey);
                }
            }
        }
    }
}

