/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.integration.kjs;

import com.sighs.touhou_little_maid_epistalove.api.integration.ILetterRuleBuilder;
import com.sighs.touhou_little_maid_epistalove.api.letter.ILetterRule;
import com.sighs.touhou_little_maid_epistalove.api.trigger.ITriggerManager;
import com.sighs.touhou_little_maid_epistalove.data.LetterRuleRegistry;
import com.sighs.touhou_little_maid_epistalove.integration.kjs.LetterRuleBuilder;
import com.sighs.touhou_little_maid_epistalove.trigger.TriggerManager;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public final class LetterAPI {
    private static final ITriggerManager TRIGGER_MANAGER = TriggerManager.getInstance();

    private LetterAPI() {
    }

    public static ILetterRuleBuilder createRule() {
        return new LetterRuleBuilder();
    }

    public static void registerRule(ILetterRule rule) {
        LetterRuleRegistry.registerRule(rule);
    }

    public static void removeRule(String ruleId) {
        LetterRuleRegistry.removeRule(ruleId);
    }

    public static void triggerEvent(ServerPlayer player, String triggerId) {
        TRIGGER_MANAGER.markTriggered(player, ResourceLocation.parse((String)triggerId));
    }

    public static void triggerEventWithContext(ServerPlayer player, String triggerId, Map<String, Object> context) {
        CompoundTag tag = new CompoundTag();
        if (context != null) {
            for (Map.Entry<String, Object> e : context.entrySet()) {
                String k = String.valueOf(e.getKey());
                String v = String.valueOf(e.getValue());
                tag.putString(k, v);
            }
        }
        TRIGGER_MANAGER.markTriggeredWithContext(player, ResourceLocation.parse((String)triggerId), tag);
    }

    public static boolean hasTriggered(ServerPlayer player, String triggerId) {
        return TRIGGER_MANAGER.hasTriggered(player, ResourceLocation.parse((String)triggerId));
    }

    public static void clearTrigger(ServerPlayer player, String triggerId) {
        TRIGGER_MANAGER.clearTriggered(player, ResourceLocation.parse((String)triggerId));
    }

    public static void clearAllTriggers(ServerPlayer player) {
        TRIGGER_MANAGER.clearAllTriggered(player);
    }

    public static boolean hasConsumedOnce(ServerPlayer player, String ruleId, String triggerId) {
        ResourceLocation key = LetterAPI.makeCustomConsumeKey(ruleId, triggerId);
        return TRIGGER_MANAGER.hasConsumedOnce(player, key);
    }

    public static void clearConsumedOnce(ServerPlayer player, String ruleId, String triggerId) {
        ResourceLocation key = LetterAPI.makeCustomConsumeKey(ruleId, triggerId);
        TRIGGER_MANAGER.clearConsumedOnce(player, key);
    }

    private static ResourceLocation makeCustomConsumeKey(String ruleId, String triggerId) {
        String normRule = ruleId.replace(":", "_");
        String normTrig = triggerId.replace(":", "_");
        return ResourceLocation.fromNamespaceAndPath((String)"internal", (String)("custom_" + normRule + "_" + normTrig));
    }
}

