/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.integration.kjs;

import com.sighs.touhou_little_maid_epistalove.api.integration.ILetterRuleBuilder;
import com.sighs.touhou_little_maid_epistalove.api.letter.ILetterGenerator;
import com.sighs.touhou_little_maid_epistalove.api.letter.ILetterRule;
import com.sighs.touhou_little_maid_epistalove.data.LetterRule;
import com.sighs.touhou_little_maid_epistalove.data.LetterRuleRegistry;
import com.sighs.touhou_little_maid_epistalove.integration.kjs.LetterGenerators;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class LetterRuleBuilder
implements ILetterRuleBuilder {
    private String id;
    private int minAffection = 0;
    private Integer maxAffection = null;
    private final List<ResourceLocation> triggers = new ArrayList<ResourceLocation>();
    private ILetterRule.TriggerType triggerType = ILetterRule.TriggerType.ONCE;
    private Integer cooldown = null;
    private Integer favorabilityChange = null;
    private Integer favorabilityThreshold = null;
    private ILetterGenerator generator;
    private final List<ResourceLocation> requiredModelIds = new ArrayList<ResourceLocation>();

    @Override
    public ILetterRuleBuilder id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public ILetterRuleBuilder minAffection(int minAffection) {
        this.minAffection = minAffection;
        return this;
    }

    @Override
    public ILetterRuleBuilder maxAffection(int maxAffection) {
        this.maxAffection = maxAffection;
        return this;
    }

    @Override
    public ILetterRuleBuilder trigger(String triggerId) {
        this.triggers.add(ResourceLocation.parse((String)triggerId));
        return this;
    }

    @Override
    public ILetterRuleBuilder triggers(List<String> triggerIds) {
        for (String id : triggerIds) {
            this.triggers.add(ResourceLocation.parse((String)id));
        }
        return this;
    }

    @Override
    public ILetterRuleBuilder triggerType(ILetterRule.TriggerType triggerType) {
        this.triggerType = triggerType;
        return this;
    }

    @Override
    public ILetterRuleBuilder cooldown(int cooldown) {
        this.cooldown = cooldown;
        return this;
    }

    @Override
    public ILetterRuleBuilder affectionChange(int delta) {
        this.favorabilityChange = delta;
        return this;
    }

    @Override
    public ILetterRuleBuilder affectionThreshold(int threshold) {
        this.favorabilityThreshold = threshold;
        return this;
    }

    @Override
    public ILetterRuleBuilder generator(ILetterGenerator generator) {
        this.generator = generator;
        return this;
    }

    @Override
    public ILetterRuleBuilder maidId(String maidId) {
        this.requiredModelIds.add(ResourceLocation.parse((String)maidId));
        return this;
    }

    @Override
    public ILetterRuleBuilder maidIds(List<String> maidIds) {
        for (String id : maidIds) {
            this.requiredModelIds.add(ResourceLocation.parse((String)id));
        }
        return this;
    }

    @Override
    public ILetterRule build() {
        if (this.id == null) {
            throw new IllegalStateException("Letter rule ID must be set");
        }
        if (this.generator == null) {
            throw new IllegalStateException("Letter generator must be set");
        }
        if (this.triggers.isEmpty()) {
            throw new IllegalStateException("At least one trigger must be set");
        }
        return new LetterRule(this.id, this.minAffection, this.maxAffection, this.triggers, this.triggerType, this.cooldown, this.favorabilityChange, this.favorabilityThreshold, this.generator, this.requiredModelIds);
    }

    @Override
    public ILetterRuleBuilder aiGenerator(String tone, String prompt) {
        this.generator = LetterGenerators.createAIGenerator(tone, prompt);
        return this;
    }

    @Override
    public ILetterRuleBuilder presetGenerator(String title, String message, String postcardId, String parcelId) {
        this.generator = LetterGenerators.createPresetGenerator(title, message, postcardId, parcelId);
        return this;
    }

    @Override
    public ILetterRuleBuilder once() {
        this.triggerType = ILetterRule.TriggerType.ONCE;
        return this;
    }

    @Override
    public ILetterRuleBuilder repeat() {
        this.triggerType = ILetterRule.TriggerType.REPEAT;
        return this;
    }

    @Override
    public ILetterRule register() {
        ILetterRule rule = this.build();
        LetterRuleRegistry.registerRule(rule);
        return rule;
    }
}

