/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.mixin;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.LLMCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.FunctionCallRegister;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.IFunctionCall;
import com.github.tartaricacid.touhoulittlemaid.ai.service.function.response.ToolResponse;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMMessage;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.response.FunctionToolCall;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.response.Message;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.response.ToolCall;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.net.http.HttpRequest;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LLMCallback.class}, remap=false)
public abstract class LLMCallbackMixin
implements ResponseCallback<Object> {
    @Shadow
    @Final
    protected MaidAIChatManager chatManager;
    @Shadow
    protected int callCount;
    @Shadow
    protected String message;

    @Shadow
    public abstract void onFailure(HttpRequest var1, Throwable var2, int var3);

    @Inject(method={"onFunctionCall"}, at={@At(value="HEAD")}, cancellable=true)
    private void tlm$handleWriteLetterOnly(Message choice, List<LLMMessage> messages, LLMConfig config, LLMClient client, CallbackInfo ci) {
        boolean hasWriteLetter = choice.getToolCalls().stream().map(ToolCall::getFunction).map(FunctionToolCall::getName).anyMatch("write_letter"::equals);
        if (!hasWriteLetter) {
            return;
        }
        if (this.callCount == 0) {
            this.chatManager.addUserHistory(this.message);
        }
        this.chatManager.addAssistantHistory("", choice.getToolCalls());
        messages.add(LLMMessage.assistantChat((EntityMaid)this.chatManager.getMaid(), (String)choice.getContent(), (List)choice.getToolCalls()));
        for (ToolCall toolCall : choice.getToolCalls()) {
            Object result;
            FunctionToolCall function = toolCall.getFunction();
            String name = function.getName();
            if (!"write_letter".equals(name)) continue;
            String arguments = function.getArguments();
            IFunctionCall functionCall = FunctionCallRegister.getFunctionCall((String)name);
            if (functionCall == null) continue;
            try {
                JsonObject parse = GsonHelper.parse((String)arguments);
                Optional optional = functionCall.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)parse).resultOrPartial(arg_0 -> ((Logger)TouhouLittleMaid.LOGGER).error(arg_0));
                if (optional.isEmpty()) continue;
                result = optional.get();
            }
            catch (Exception exception) {
                String msg = "Exception %s, JSON is: %s".formatted(exception.getLocalizedMessage(), arguments);
                this.onFailure(null, new Throwable(msg), 2);
                continue;
            }
            TouhouLittleMaid.LOGGER.debug("Use function call: {}, arguments is {}", (Object)functionCall.getId(), (Object)arguments);
            EntityMaid maid = config.maid();
            Level level = maid.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            Object finalResult = result;
            serverLevel.getServer().submit(() -> {
                IFunctionCall call = functionCall;
                ToolResponse toolResponse = call.onToolCall(finalResult, maid);
                ++this.callCount;
                String response = toolResponse.message();
                this.chatManager.addToolHistory(response, toolCall.getId());
                messages.add(LLMMessage.toolChat((EntityMaid)maid, (String)response, (String)toolCall.getId()));
            });
        }
        ci.cancel();
    }
}

