/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.util;

import com.sighs.touhou_little_maid_epistalove.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class HazardUtil {
    private HazardUtil() {
    }

    public static boolean isPosHazardous(ServerLevel level, BlockPos pos) {
        if (level == null || pos == null) {
            return false;
        }
        PathType pathType = HazardUtil.getBlockPathType((BlockGetter)level, pos);
        return HazardUtil.isPathTypeDangerous(pathType);
    }

    public static PathType getBlockPathType(BlockGetter level, BlockPos pos) {
        return WalkNodeEvaluator.getPathTypeFromState((BlockGetter)level, (BlockPos)pos);
    }

    public static boolean isPathTypeDangerous(PathType pathType) {
        return switch (pathType) {
            case PathType.LAVA, PathType.DAMAGE_FIRE, PathType.DAMAGE_OTHER, PathType.DAMAGE_CAUTIOUS -> true;
            case PathType.BLOCKED, PathType.FENCE, PathType.UNPASSABLE_RAIL -> true;
            default -> false;
        };
    }

    public static boolean isSafeForStanding(ServerLevel level, BlockPos pos, Mob mob) {
        boolean hasSolidSupport;
        if (level == null || pos == null) {
            return false;
        }
        BlockState feetState = level.getBlockState(pos);
        VoxelShape feetShape = feetState.getCollisionShape((BlockGetter)level, pos);
        if (!feetShape.isEmpty()) {
            return false;
        }
        BlockState headState = level.getBlockState(pos.above());
        VoxelShape headShape = headState.getCollisionShape((BlockGetter)level, pos.above());
        if (!headShape.isEmpty() && !HazardUtil.isSafeDoubleBlock(level, pos.above())) {
            return false;
        }
        BlockState groundState = level.getBlockState(pos.below());
        VoxelShape groundShape = groundState.getCollisionShape((BlockGetter)level, pos.below());
        boolean bl = hasSolidSupport = !groundShape.isEmpty() || groundState.isSolid();
        if (!hasSolidSupport) {
            return false;
        }
        PathType feetType = HazardUtil.getBlockPathType((BlockGetter)level, pos);
        if (feetType == PathType.LAVA || feetType == PathType.DAMAGE_FIRE || feetType == PathType.DAMAGE_OTHER || feetType == PathType.DAMAGE_CAUTIOUS) {
            return false;
        }
        return !HazardUtil.isAreaTooHazardous(level, pos, 1);
    }

    public static boolean isSafeDoubleBlock(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        if ("contact".equals(blockId.getNamespace())) {
            String path = blockId.getPath();
            return "red_postbox".equals(path) || "green_postbox".equals(path);
        }
        return false;
    }

    public static int calculateHazardScore(ServerLevel level, BlockPos center, int radius) {
        if (level == null || center == null) {
            return 100;
        }
        int hazardCount = 0;
        int totalChecked = 0;
        int r = Math.max(0, Math.min(radius, 3));
        for (int dx = -r; dx <= r; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -r; dz <= r; ++dz) {
                    BlockPos check = center.offset(dx, dy, dz);
                    ++totalChecked;
                    PathType pathType = HazardUtil.getBlockPathType((BlockGetter)level, check);
                    int weight = switch (pathType) {
                        case PathType.LAVA, PathType.DAMAGE_FIRE -> 3;
                        case PathType.DAMAGE_OTHER, PathType.DAMAGE_CAUTIOUS -> 2;
                        case PathType.DANGER_FIRE, PathType.DANGER_OTHER, PathType.DANGER_POWDER_SNOW -> 1;
                        case PathType.BLOCKED, PathType.FENCE, PathType.UNPASSABLE_RAIL -> 1;
                        default -> 0;
                    };
                    hazardCount += weight;
                }
            }
        }
        return totalChecked > 0 ? Math.min(100, hazardCount * 100 / (totalChecked * 3)) : 0;
    }

    public static boolean isSafeStanding(ServerLevel level, BlockPos pos) {
        return HazardUtil.isSafeForStanding(level, pos, null);
    }

    public static boolean isAreaTooHazardous(ServerLevel level, BlockPos center, int radius) {
        int hazardScore = HazardUtil.calculateHazardScore(level, center, radius);
        return hazardScore > (Integer)Config.AREA_HAZARD_THRESHOLD.get();
    }

    public static boolean isCompletelyTrapped(ServerLevel level, BlockPos pos) {
        BlockPos[] directions = new BlockPos[]{pos.north(), pos.south(), pos.east(), pos.west()};
        int blockedDirections = 0;
        for (BlockPos dir : directions) {
            PathType pathType = HazardUtil.getBlockPathType((BlockGetter)level, dir);
            if (pathType != PathType.BLOCKED && !HazardUtil.isPathTypeDangerous(pathType)) continue;
            ++blockedDirections;
        }
        return blockedDirections >= 4;
    }

    public static BlockPos findSafestNearbyPosition(ServerLevel level, BlockPos center, int searchRadius) {
        BlockPos bestPos = null;
        int bestScore = Integer.MAX_VALUE;
        int r = Math.min(searchRadius, 5);
        for (int dx = -r; dx <= r; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -r; dz <= r; ++dz) {
                    int score;
                    BlockPos candidate;
                    if (dx == 0 && dy == 0 && dz == 0 || !HazardUtil.isSafeStanding(level, candidate = center.offset(dx, dy, dz)) || (score = HazardUtil.calculateHazardScore(level, candidate, 1)) >= bestScore) continue;
                    bestScore = score;
                    bestPos = candidate;
                }
            }
        }
        return bestPos;
    }
}

