/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.util;

import com.sighs.touhou_little_maid_epistalove.config.Config;
import com.sighs.touhou_little_maid_epistalove.util.HazardUtil;
import com.sighs.touhou_little_maid_epistalove.util.PathSafetyPlanner;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailboxSafetyEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailboxSafetyEvaluator.class);

    private MailboxSafetyEvaluator() {
    }

    public static Optional<MailboxInfo> getBestUsableMailbox(ServerLevel level, BlockPos center, int searchRadius) {
        List<MailboxInfo> list = MailboxSafetyEvaluator.evaluateMailboxes(level, center, searchRadius);
        return list.stream().filter(MailboxInfo::isUsable).max(Comparator.comparingInt(MailboxInfo::safetyScore).thenComparing(m -> -m.distance));
    }

    public static List<MailboxInfo> evaluateMailboxes(ServerLevel level, BlockPos center, int searchRadius) {
        ArrayList<MailboxInfo> mailboxes = new ArrayList<MailboxInfo>();
        int r = Math.max(1, Math.min(searchRadius, (Integer)Config.MAILBOX_SEARCH_RADIUS.get()));
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)center.offset(-r, -2, -r), (BlockPos)center.offset(r, 2, r))) {
            if (!MailboxSafetyEvaluator.isMailbox(level, pos)) continue;
            BlockPos immutable = pos.immutable();
            int safety = MailboxSafetyEvaluator.calculateMailboxSafety(level, immutable);
            double dist = center.distSqr((Vec3i)immutable);
            boolean accessible = PathSafetyPlanner.isPositionAccessible(level, center, immutable);
            PathType pathType = HazardUtil.getBlockPathType((BlockGetter)level, immutable);
            mailboxes.add(new MailboxInfo(immutable, safety, dist, accessible, pathType));
        }
        mailboxes.sort(Comparator.comparingInt(m -> -m.safetyScore).thenComparingDouble(MailboxInfo::distance));
        return mailboxes;
    }

    private static boolean isMailbox(ServerLevel level, BlockPos pos) {
        boolean isPostbox;
        BlockState state = level.getBlockState(pos);
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        if (!"contact".equals(id.getNamespace())) {
            return false;
        }
        String path = id.getPath();
        boolean bl = isPostbox = "red_postbox".equals(path) || "green_postbox".equals(path);
        if (!isPostbox) {
            return false;
        }
        if (state.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
            return state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER;
        }
        return true;
    }

    private static int calculateMailboxSafety(ServerLevel level, BlockPos mailboxPos) {
        PathType belowType;
        PathType mailboxPathType = HazardUtil.getBlockPathType((BlockGetter)level, mailboxPos);
        if (mailboxPathType == PathType.LAVA || mailboxPathType == PathType.DAMAGE_FIRE) {
            return 0;
        }
        if (!MailboxSafetyEvaluator.hasValidAccessPoints(level, mailboxPos) || HazardUtil.isCompletelyTrapped(level, mailboxPos)) {
            return 0;
        }
        int score = 50;
        if (mailboxPathType == PathType.DANGER_FIRE) {
            score -= 10;
        }
        int safeAccessPoints = MailboxSafetyEvaluator.countSafeAccessPoints(level, mailboxPos);
        score += safeAccessPoints * 12;
        int areaHazardScore = HazardUtil.calculateHazardScore(level, mailboxPos, 2);
        int areaSafetyBonus = Math.max(0, (100 - areaHazardScore) / 3);
        score += areaSafetyBonus;
        PathType aboveType = HazardUtil.getBlockPathType((BlockGetter)level, mailboxPos.above());
        if (HazardUtil.isPathTypeDangerous(aboveType)) {
            score -= 20;
        }
        if (HazardUtil.isPathTypeDangerous(belowType = HazardUtil.getBlockPathType((BlockGetter)level, mailboxPos.below()))) {
            score -= 15;
        }
        int goodStandingSpots = MailboxSafetyEvaluator.countGoodStandingSpots(level, mailboxPos, 2);
        return Math.max(0, Math.min(100, score += goodStandingSpots * 3));
    }

    private static boolean hasValidAccessPoints(ServerLevel level, BlockPos mailboxPos) {
        BlockPos[] checkPositions;
        for (BlockPos pos : checkPositions = new BlockPos[]{mailboxPos.north(), mailboxPos.south(), mailboxPos.east(), mailboxPos.west(), mailboxPos}) {
            if (!HazardUtil.isSafeStanding(level, pos)) continue;
            return true;
        }
        BlockState state = level.getBlockState(mailboxPos);
        if (state.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            BlockPos[] upperDirections;
            BlockPos upperPos = mailboxPos.above();
            for (BlockPos pos : upperDirections = new BlockPos[]{upperPos.north(), upperPos.south(), upperPos.east(), upperPos.west()}) {
                if (!HazardUtil.isSafeStanding(level, pos)) continue;
                return true;
            }
        }
        return false;
    }

    private static int countSafeAccessPoints(ServerLevel level, BlockPos mailboxPos) {
        DoubleBlockHalf half;
        BlockState state;
        BlockPos[] directions = new BlockPos[]{mailboxPos.north(), mailboxPos.south(), mailboxPos.east(), mailboxPos.west()};
        int count = 0;
        for (BlockPos pos : directions) {
            if (!HazardUtil.isSafeStanding(level, pos)) continue;
            ++count;
        }
        if (HazardUtil.isSafeStanding(level, mailboxPos)) {
            ++count;
        }
        if ((state = level.getBlockState(mailboxPos)).hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && (half = (DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) == DoubleBlockHalf.LOWER) {
            BlockPos[] upperDirections;
            BlockPos upperPos = mailboxPos.above();
            for (BlockPos pos : upperDirections = new BlockPos[]{upperPos.north(), upperPos.south(), upperPos.east(), upperPos.west()}) {
                if (!HazardUtil.isSafeStanding(level, pos)) continue;
                ++count;
            }
        }
        return count;
    }

    private static int countGoodStandingSpots(ServerLevel level, BlockPos center, int radius) {
        int count = 0;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                PathType pathType;
                BlockPos pos;
                if (dx == 0 && dz == 0 || !HazardUtil.isSafeStanding(level, pos = center.offset(dx, 0, dz)) || (pathType = HazardUtil.getBlockPathType((BlockGetter)level, pos)) != PathType.WALKABLE && pathType != PathType.OPEN) continue;
                ++count;
            }
        }
        return count;
    }

    public record MailboxInfo(BlockPos pos, int safetyScore, double distance, boolean accessible, PathType pathType) {
        public boolean isUsable() {
            return this.safetyScore >= (Integer)Config.MAILBOX_MIN_SAFETY_SCORE.get() && this.accessible && !HazardUtil.isPathTypeDangerous(this.pathType);
        }

        public boolean isHighQuality() {
            return this.safetyScore >= (Integer)Config.HIGH_QUALITY_THRESHOLD.get() && this.accessible && this.pathType == PathType.WALKABLE;
        }
    }
}

