/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.util;

import com.sighs.touhou_little_maid_epistalove.config.Config;
import com.sighs.touhou_little_maid_epistalove.util.HazardUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;

public final class PathSafetyPlanner {
    private PathSafetyPlanner() {
    }

    public static Path planSimpleAvoidancePath(Mob entity, BlockPos target) {
        PathNavigation nav = entity.getNavigation();
        ServerLevel level = (ServerLevel)entity.level();
        BlockPos start = entity.blockPosition();
        Path direct = nav.createPath(target, 1);
        if (PathSafetyPlanner.isPathSafeEnough(level, direct, entity)) {
            return direct;
        }
        List<BlockPos> smartCandidates = PathSafetyPlanner.generateSmartDetourCandidates(level, start, target, entity);
        for (BlockPos blockPos : smartCandidates) {
            Path path = nav.createPath(blockPos, 1);
            if (!PathSafetyPlanner.isPathSafeEnough(level, path, entity)) continue;
            return path;
        }
        List<BlockPos> nearCandidates = PathSafetyPlanner.generateSafeCandidatesNear(level, target, 3, entity);
        for (BlockPos candidate : nearCandidates) {
            Path path = nav.createPath(candidate, 1);
            if (!PathSafetyPlanner.isPathSafeEnough(level, path, entity)) continue;
            return path;
        }
        Path path = nav.createPath(target, 3);
        if (PathSafetyPlanner.isPathSafeEnough(level, path, entity)) {
            return path;
        }
        return direct;
    }

    private static List<BlockPos> generateSmartDetourCandidates(ServerLevel level, BlockPos start, BlockPos target, Mob entity) {
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        PathData pathData = PathSafetyPlanner.calculatePathData(start, target);
        if (pathData.distance <= 2) {
            return candidates;
        }
        List<BlockPos> hazardPoints = PathSafetyPlanner.findHazardsOnPath(level, start, target, pathData);
        if (hazardPoints.isEmpty()) {
            return candidates;
        }
        for (BlockPos hazard : hazardPoints) {
            PathSafetyPlanner.generateDetourAroundHazard(level, hazard, pathData, candidates, entity);
        }
        candidates.removeIf(pos -> !HazardUtil.isSafeForStanding(level, pos, entity));
        candidates.sort(Comparator.comparingDouble(a -> a.distSqr((Vec3i)target)));
        return candidates;
    }

    private static void generateDetourAroundHazard(ServerLevel level, BlockPos hazard, PathData pathData, List<BlockPos> candidates, Mob entity) {
        if (Math.abs(pathData.dx) > Math.abs(pathData.dz)) {
            PathSafetyPlanner.addDetourCandidates(candidates, hazard, 0, 0, new int[]{2, 3, 4, -2, -3, -4});
        } else {
            PathSafetyPlanner.addDetourCandidates(candidates, hazard, new int[]{2, 3, 4, -2, -3, -4}, 0, 0);
        }
        candidates.add(hazard.above());
        candidates.add(hazard.above(2));
        candidates.add(hazard.below());
    }

    private static void addDetourCandidates(List<BlockPos> candidates, BlockPos base, int dx, int dy, int[] offsets) {
        for (int offset : offsets) {
            candidates.add(base.offset(dx, dy, offset));
        }
    }

    private static void addDetourCandidates(List<BlockPos> candidates, BlockPos base, int[] offsets, int dy, int dz) {
        for (int offset : offsets) {
            candidates.add(base.offset(offset, dy, dz));
        }
    }

    public static List<BlockPos> generateSafeCandidatesNear(ServerLevel level, BlockPos target, int radius, Mob entity) {
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        PathSafetyPlanner.addIfSafe(candidates, level, target.north(), entity);
        PathSafetyPlanner.addIfSafe(candidates, level, target.south(), entity);
        PathSafetyPlanner.addIfSafe(candidates, level, target.east(), entity);
        PathSafetyPlanner.addIfSafe(candidates, level, target.west(), entity);
        if (radius > 1) {
            PathSafetyPlanner.addIfSafe(candidates, level, target.north().east(), entity);
            PathSafetyPlanner.addIfSafe(candidates, level, target.north().west(), entity);
            PathSafetyPlanner.addIfSafe(candidates, level, target.south().east(), entity);
            PathSafetyPlanner.addIfSafe(candidates, level, target.south().west(), entity);
            for (int dist = 2; dist <= radius; ++dist) {
                PathSafetyPlanner.addIfSafe(candidates, level, target.north(dist), entity);
                PathSafetyPlanner.addIfSafe(candidates, level, target.south(dist), entity);
                PathSafetyPlanner.addIfSafe(candidates, level, target.east(dist), entity);
                PathSafetyPlanner.addIfSafe(candidates, level, target.west(dist), entity);
            }
            if (candidates.size() < 2) {
                PathSafetyPlanner.addIfSafe(candidates, level, target.above(), entity);
                PathSafetyPlanner.addIfSafe(candidates, level, target.below(), entity);
            }
        }
        candidates.sort(Comparator.comparingDouble(a -> a.distSqr((Vec3i)target)));
        return candidates;
    }

    public static BlockPos findBestApproachPosition(ServerLevel level, BlockPos target, Mob entity) {
        List<BlockPos> candidates = PathSafetyPlanner.generateSafeCandidatesNear(level, target, 3, entity);
        return candidates.isEmpty() ? null : candidates.get(0);
    }

    private static void addIfSafe(List<BlockPos> candidates, ServerLevel level, BlockPos pos, Mob entity) {
        if (HazardUtil.isSafeForStanding(level, pos, entity)) {
            candidates.add(pos);
        }
    }

    private static List<BlockPos> findHazardsOnPath(ServerLevel level, BlockPos start, BlockPos target, PathData pathData) {
        ArrayList<BlockPos> hazards = new ArrayList<BlockPos>();
        if (pathData.distance == 0) {
            return hazards;
        }
        for (int i = 1; i < pathData.distance; ++i) {
            int x = start.getX() + pathData.dx * i / pathData.distance;
            int z = start.getZ() + pathData.dz * i / pathData.distance;
            BlockPos checkPos = new BlockPos(x, start.getY(), z);
            PathType pathType = HazardUtil.getBlockPathType((BlockGetter)level, checkPos);
            if (!HazardUtil.isPathTypeDangerous(pathType)) continue;
            hazards.add(checkPos);
        }
        return hazards;
    }

    private static PathData calculatePathData(BlockPos start, BlockPos target) {
        int dx = target.getX() - start.getX();
        int dz = target.getZ() - start.getZ();
        int distance = Math.max(Math.abs(dx), Math.abs(dz));
        return new PathData(dx, dz, distance);
    }

    public static boolean isPositionAccessible(ServerLevel level, BlockPos from, BlockPos to) {
        BlockPos[] around;
        double distance = from.distSqr((Vec3i)to);
        if (distance > 1024.0) {
            return false;
        }
        if (HazardUtil.isSafeStanding(level, to)) {
            return true;
        }
        for (BlockPos pos : around = new BlockPos[]{to.north(), to.south(), to.east(), to.west(), to.above(), to.below()}) {
            if (!HazardUtil.isSafeStanding(level, pos)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPathSafeEnough(ServerLevel level, Path path, Mob entity) {
        if (path == null || path.getNodeCount() == 0) {
            return false;
        }
        int nodes = path.getNodeCount();
        int startIdx = Math.max(0, path.getNextNodeIndex());
        int consecutiveSafe = 0;
        int maxConsecutiveSafe = 0;
        int totalSafe = 0;
        int totalChecked = 0;
        int consecutiveDangerous = 0;
        int maxConsecutiveDangerous = 0;
        for (int i = startIdx; i < nodes; ++i) {
            float malus;
            Node node = path.getNode(i);
            BlockPos pos = new BlockPos(node.x, node.y, node.z);
            ++totalChecked;
            PathType pathType = HazardUtil.getBlockPathType((BlockGetter)level, pos);
            boolean isDangerous = HazardUtil.isPathTypeDangerous(pathType);
            if (entity != null && (malus = entity.getPathfindingMalus(pathType)) < 0.0f) {
                isDangerous = true;
            }
            if (!isDangerous) {
                ++totalSafe;
                maxConsecutiveSafe = Math.max(maxConsecutiveSafe, ++consecutiveSafe);
                consecutiveDangerous = 0;
                continue;
            }
            consecutiveSafe = 0;
            maxConsecutiveDangerous = Math.max(maxConsecutiveDangerous, ++consecutiveDangerous);
        }
        if (totalChecked == 0) {
            return false;
        }
        int safetyPercentage = totalSafe * 100 / totalChecked;
        if (maxConsecutiveDangerous > (Integer)Config.MAX_CONSECUTIVE_DANGEROUS.get()) {
            return false;
        }
        if (totalChecked <= 3) {
            return safetyPercentage >= 90;
        }
        if (totalChecked <= 8) {
            return safetyPercentage >= 75;
        }
        boolean hasGoodSafeSegment = maxConsecutiveSafe >= Math.max(3, totalChecked / 5);
        return safetyPercentage >= (Integer)Config.PATH_SAFETY_PERCENTAGE.get() && hasGoodSafeSegment;
    }

    private record PathData(int dx, int dz, int distance) {
    }
}

