/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.touhou_little_maid_epistalove.util;

import com.flechazo.contact.common.component.ContactDataComponents;
import com.flechazo.contact.common.item.IPackageItem;
import com.flechazo.contact.data.PostcardDataManager;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.sighs.touhou_little_maid_epistalove.component.TLMContactDataComponents;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;

public final class PostcardPackageUtil {
    private PostcardPackageUtil() {
    }

    public static ItemStack buildPackageWithPostcard(ResourceLocation packageId, String postcardText, ResourceLocation postcardId, String senderName) {
        String withSignature = senderName != null && !senderName.isBlank() ? PostcardPackageUtil.appendSignatureDynamic(postcardText, senderName, postcardId) : postcardText;
        return PostcardPackageUtil.buildPackageWithPostcard(packageId, withSignature, postcardId);
    }

    private static String appendSignatureDynamic(String originalText, String senderName, ResourceLocation postcardId) {
        int lineWidth = PostcardPackageUtil.resolveTextBoxWidth(postcardId);
        int nameWidth = PostcardPackageUtil.estimateStringWidthPx(senderName);
        int spaceWidth = 4;
        int spaces = Math.max(0, (lineWidth - nameWidth) / spaceWidth);
        return originalText + "\n" + " ".repeat(spaces) + senderName;
    }

    private static int resolveTextBoxWidth(ResourceLocation postcardId) {
        return PostcardDataManager.getPostcard((ResourceLocation)postcardId).textWidth();
    }

    private static int estimateStringWidthPx(String s) {
        int cp;
        int w = 0;
        for (int i = 0; i < s.length(); i += Character.charCount(cp)) {
            cp = s.codePointAt(i);
            w += PostcardPackageUtil.estimateCharWidthPx(cp);
        }
        return w;
    }

    private static int estimateCharWidthPx(int cp) {
        if (cp == 167) {
            return 0;
        }
        if (cp == 32) {
            return 4;
        }
        Character.UnicodeBlock b = Character.UnicodeBlock.of(cp);
        if (b == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || b == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || b == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || b == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || b == Character.UnicodeBlock.HANGUL_SYLLABLES || b == Character.UnicodeBlock.KATAKANA || b == Character.UnicodeBlock.HIRAGANA) {
            return 10;
        }
        if (cp >= 48 && cp <= 57) {
            return 6;
        }
        if (cp >= 65 && cp <= 90) {
            return cp == 77 || cp == 87 ? 9 : 7;
        }
        if (cp >= 97 && cp <= 122) {
            if (cp == 105 || cp == 108) {
                return 4;
            }
            if (cp == 109 || cp == 119) {
                return 8;
            }
            return 6;
        }
        if (".,;:!|/\\'\"`^~".indexOf(cp) >= 0) {
            return 4;
        }
        if (cp == 45 || cp == 95) {
            return 6;
        }
        return 6;
    }

    public static ItemStack buildPackageWithPostcard(ResourceLocation packageId, String postcardText, ResourceLocation postcardId) {
        ItemStack packageStack = ItemsUtil.getItemStack((String)packageId.toString()).copy();
        packageStack.set((DataComponentType)TLMContactDataComponents.MAID_MAIL.get(), (Object)true);
        ItemStack postcardStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"contact:postcard")));
        postcardStack.set((DataComponentType)ContactDataComponents.POSTCARD_TEXT.get(), (Object)postcardText);
        postcardStack.set((DataComponentType)ContactDataComponents.POSTCARD_STYLE_ID.get(), (Object)postcardId);
        ArrayList<ItemStack> containerItems = new ArrayList<ItemStack>();
        containerItems.add(postcardStack);
        ItemContainerContents containerContents = ItemContainerContents.fromItems(containerItems);
        packageStack.set(DataComponents.CONTAINER, (Object)containerContents);
        return packageStack;
    }

    public static ResourceLocation choosePackageId(String parcelIdStr) {
        List<ResourceLocation> packageIds;
        if (parcelIdStr != null && !parcelIdStr.isBlank()) {
            try {
                ResourceLocation candidate = ResourceLocation.parse((String)parcelIdStr);
                Item item = (Item)BuiltInRegistries.ITEM.get(candidate);
                if (item instanceof IPackageItem) {
                    return candidate;
                }
            }
            catch (Exception candidate) {
                // empty catch block
            }
        }
        return (packageIds = PostcardPackageUtil.getAllPackageItemIds()).isEmpty() ? ResourceLocation.fromNamespaceAndPath((String)"contact", (String)"letter") : packageIds.get(ThreadLocalRandom.current().nextInt(packageIds.size()));
    }

    public static ResourceLocation choosePostcardId(String postcardIdStr) {
        List<ResourceLocation> postcardIds;
        if (postcardIdStr != null && !postcardIdStr.isBlank()) {
            try {
                ResourceLocation candidate = ResourceLocation.parse((String)postcardIdStr);
                if (PostcardPackageUtil.getAllPostcardIds().contains(candidate)) {
                    return candidate;
                }
            }
            catch (Exception candidate) {
                // empty catch block
            }
        }
        return (postcardIds = PostcardPackageUtil.getAllPostcardIds()).isEmpty() ? ResourceLocation.fromNamespaceAndPath((String)"contact", (String)"default") : postcardIds.get(ThreadLocalRandom.current().nextInt(postcardIds.size()));
    }

    public static List<ResourceLocation> getAllPackageItemIds() {
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        for (Item item : BuiltInRegistries.ITEM) {
            if (!(item instanceof IPackageItem)) continue;
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            ids.add(id);
        }
        return ids;
    }

    public static List<ResourceLocation> getAllPostcardIds() {
        return new ArrayList<ResourceLocation>(PostcardDataManager.getPostcardIds());
    }
}

