/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="onekeyminer")
public class UpdateChecker {
    private static final String PROJECT_ID = "LZu4H9cp";
    private static final String API_URL = "https://api.modrinth.com/v2/project/LZu4H9cp/version";
    private static String latestVersion = null;
    private static boolean checked = false;
    private static final boolean ALLOW_MAJOR_MATCH = false;

    private static void fetchLatestVersion() {
        if (checked) {
            return;
        }
        checked = true;
        CompletableFuture.runAsync(() -> {
            try {
                String line;
                String mcVersion = "1.12.2";
                String loader = "forge";
                URL url = new URL(API_URL);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                JsonArray root = new JsonParser().parse(response.toString()).getAsJsonArray();
                String bestVersion = null;
                String publishedDate = null;
                for (JsonElement elem : root) {
                    Object v2;
                    JsonObject file = elem.getAsJsonObject();
                    JsonArray gameVersions = file.getAsJsonArray("game_versions");
                    JsonArray loaders = file.getAsJsonArray("loaders");
                    boolean supportsGame = false;
                    for (Object v2 : gameVersions) {
                        String supported = v2.getAsString();
                        if (!mcVersion.equals(supported)) continue;
                        supportsGame = true;
                        break;
                    }
                    boolean supportsLoader = false;
                    v2 = loaders.iterator();
                    while (v2.hasNext()) {
                        JsonElement l = (JsonElement)v2.next();
                        if (!loader.equalsIgnoreCase(l.getAsString())) continue;
                        supportsLoader = true;
                        break;
                    }
                    if (!supportsGame || !supportsLoader) continue;
                    String versionNumber = file.get("version_number").getAsString();
                    String date = file.get("date_published").getAsString();
                    if (publishedDate != null && date.compareTo(publishedDate) <= 0) continue;
                    bestVersion = versionNumber;
                    publishedDate = date;
                }
                latestVersion = bestVersion;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            String current;
            EntityPlayerMP sp = (EntityPlayerMP)event.player;
            UpdateChecker.fetchLatestVersion();
            if (latestVersion != null && !(current = "1.5.8").equals(latestVersion)) {
                sp.func_145747_a((ITextComponent)new TextComponentTranslation("message.onekeyminer.update_available", new Object[]{current, latestVersion}));
            }
        }
    }
}

