/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.api;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.chain.ChainHandler;
import org.xiyu.yee.onekeyminer.chain.InteractionHandler;
import org.xiyu.yee.onekeyminer.chain.PlantingHandler;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.config.ServerConfig;

public class ChainAPI {
    public static List<BlockPos> computeMiningPositions(EntityPlayerMP player, WorldServer level, BlockPos startPos, IBlockState startState, ItemStack tool) {
        List<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || startState == null || tool == null) {
            return result;
        }
        if (!ChainModeCapability.isChainModeActive(player)) {
            return result;
        }
        if (startState.func_177230_c() == Blocks.field_150350_a) {
            return result;
        }
        if (CommonConfig.INSTANCE.requireSneaking.get() && !player.func_70093_af()) {
            return result;
        }
        if (player.func_184812_l_() && !CommonConfig.INSTANCE.enableInCreative.get()) {
            return result;
        }
        if (!player.func_184812_l_() && (double)player.func_71024_bL().func_75116_a() < ServerConfig.INSTANCE.hungerThreshold.get()) {
            return result;
        }
        Block block = startState.func_177230_c();
        if (!CommonConfig.INSTANCE.isBlockMineable(block)) {
            return result;
        }
        if (!CommonConfig.INSTANCE.ignoreToolCompatibility.get() && !player.func_184823_b(startState)) {
            return result;
        }
        if (!player.func_184812_l_() && (tool.func_77984_f() || tool.func_77958_k() > 0)) {
            double durabilityProtection = ServerConfig.INSTANCE.toolDurabilityThreshold.get();
            if ((double)tool.func_77952_i() >= (double)tool.func_77958_k() - durabilityProtection) {
                return result;
            }
        }
        try {
            result = ChainHandler.computeMiningPositions(player, level, startPos, startState, tool);
        }
        catch (Throwable t) {
            BlockPos[] neighbors;
            if (level.func_180495_p(startPos).func_177230_c() == startState.func_177230_c()) {
                result.add(startPos);
            }
            for (BlockPos neighbor : neighbors = new BlockPos[]{startPos.func_177984_a(), startPos.func_177977_b(), startPos.func_177978_c(), startPos.func_177968_d(), startPos.func_177974_f(), startPos.func_177976_e()}) {
                if (result.size() >= 10) break;
                if (level.func_180495_p(neighbor).func_177230_c() != startState.func_177230_c()) continue;
                result.add(neighbor);
            }
        }
        return result;
    }

    public static List<BlockPos> computeInteractionPositions(EntityPlayerMP player, WorldServer level, BlockPos startPos, IBlockState targetState, EnumHand hand) {
        List<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || targetState == null) {
            return result;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            return result;
        }
        if ((heldItem.func_77984_f() || heldItem.func_77958_k() > 0) && heldItem.func_77952_i() >= heldItem.func_77958_k() - 1) {
            return result;
        }
        try {
            result = InteractionHandler.computeInteractionPositions(player, level, startPos, targetState, hand);
        }
        catch (Throwable t) {
            BlockPos[] neighbors;
            if (level.func_180495_p(startPos).func_177230_c() == targetState.func_177230_c()) {
                result.add(startPos);
            }
            for (BlockPos neighbor : neighbors = new BlockPos[]{startPos.func_177984_a(), startPos.func_177977_b(), startPos.func_177978_c(), startPos.func_177968_d(), startPos.func_177974_f(), startPos.func_177976_e()}) {
                if (result.size() >= 10) break;
                if (level.func_180495_p(neighbor).func_177230_c() != targetState.func_177230_c()) continue;
                result.add(neighbor);
            }
        }
        return result;
    }

    public static List<BlockPos> computePlantingPositions(EntityPlayerMP player, WorldServer level, BlockPos startPos, IBlockState targetState, ItemStack seedItem) {
        List<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || seedItem == null) {
            return result;
        }
        try {
            result = PlantingHandler.computePlantingPositions(player, level, startPos, targetState, seedItem);
        }
        catch (Throwable t) {
            BlockPos[] neighbors;
            if (!ChainAPI.isPlantableItem(seedItem)) {
                return result;
            }
            if (ChainAPI.canPlantAt((World)level, startPos, level.func_180495_p(startPos), seedItem)) {
                result.add(startPos);
            }
            for (BlockPos neighbor : neighbors = new BlockPos[]{startPos.func_177984_a(), startPos.func_177977_b(), startPos.func_177978_c(), startPos.func_177968_d(), startPos.func_177974_f(), startPos.func_177976_e()}) {
                if (result.size() >= 10) break;
                if (!ChainAPI.canPlantAt((World)level, neighbor, level.func_180495_p(neighbor), seedItem)) continue;
                result.add(neighbor);
            }
        }
        return result;
    }

    private static boolean canPlantAt(World level, BlockPos pos, IBlockState state, ItemStack seedItem) {
        if (!level.func_175623_d(pos)) {
            return false;
        }
        BlockPos below = pos.func_177977_b();
        IBlockState belowState = level.func_180495_p(below);
        return ChainAPI.canPlantOnSurface(seedItem.func_77973_b(), belowState);
    }

    private static boolean canPlantOnSurface(Item item, IBlockState surfaceState) {
        if (surfaceState == null) {
            return false;
        }
        Block surfaceBlock = surfaceState.func_177230_c();
        if (item instanceof ItemBlock) {
            ItemBlock blockItem = (ItemBlock)item;
            Block block = blockItem.func_179223_d();
            if (block instanceof BlockCrops) {
                return surfaceBlock == Blocks.field_150458_ak;
            }
            String bname = block.func_149739_a().toLowerCase();
            if (bname.contains("sapling") || bname.contains("flower") || bname.contains("mushroom")) {
                return surfaceBlock == Blocks.field_150346_d || surfaceBlock == Blocks.field_150349_c || surfaceBlock == Blocks.field_150391_bh;
            }
            if (bname.contains("potato") || bname.contains("carrot") || bname.contains("wheat") || bname.contains("beetroot")) {
                return surfaceBlock == Blocks.field_150458_ak;
            }
        }
        return surfaceBlock == Blocks.field_150346_d || surfaceBlock == Blocks.field_150349_c || surfaceBlock == Blocks.field_150354_m || surfaceBlock == Blocks.field_150425_aM || surfaceBlock == Blocks.field_150391_bh || surfaceBlock instanceof BlockFarmland;
    }

    private static boolean isPlantableItem(ItemStack stack) {
        ItemBlock blockItem;
        Block block;
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (CommonConfig.INSTANCE.isSeedBlacklisted(item)) {
            return false;
        }
        if (item instanceof ItemBlock && ((block = (blockItem = (ItemBlock)item).func_179223_d()) instanceof BlockCrops || block.func_149739_a().toLowerCase().contains("sapling") || block.func_149739_a().toLowerCase().contains("cocoa") || block.func_149739_a().toLowerCase().contains("sugar") || block.func_149739_a().toLowerCase().contains("wart"))) {
            return true;
        }
        String name = item.toString().toLowerCase();
        if (name.contains("seed") || name.contains("sapling") || name.contains("seedling") || name.contains("plant")) {
            return true;
        }
        return name.contains("pumpkin") || name.contains("melon") || name.contains("potato") || name.contains("carrot") || name.contains("cocoa") || name.contains("sugar") || name.contains("cactus");
    }
}

