/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.math.BlockPos;

public class ChainPositionStore {
    private static final Map<String, List<BlockPos>> miningPositions = new ConcurrentHashMap<String, List<BlockPos>>();
    private static final Map<String, List<BlockPos>> interactionPositions = new ConcurrentHashMap<String, List<BlockPos>>();
    private static final Map<String, List<BlockPos>> plantingPositions = new ConcurrentHashMap<String, List<BlockPos>>();
    private static final Map<String, List<UUID>> shearingEntityUuids = new ConcurrentHashMap<String, List<UUID>>();
    private static final Map<String, Boolean> chainModeState = new ConcurrentHashMap<String, Boolean>();

    public static void setMiningPositions(String playerUuid, List<BlockPos> positions) {
        if (positions == null) {
            miningPositions.remove(playerUuid);
        } else {
            miningPositions.put(playerUuid, Collections.unmodifiableList(new ArrayList<BlockPos>(positions)));
        }
    }

    public static List<BlockPos> getMiningPositions(String playerUuid) {
        return miningPositions.getOrDefault(playerUuid, Collections.emptyList());
    }

    public static void setInteractionPositions(String playerUuid, List<BlockPos> positions) {
        if (positions == null) {
            interactionPositions.remove(playerUuid);
        } else {
            interactionPositions.put(playerUuid, Collections.unmodifiableList(new ArrayList<BlockPos>(positions)));
        }
    }

    public static List<BlockPos> getInteractionPositions(String playerUuid) {
        return interactionPositions.getOrDefault(playerUuid, Collections.emptyList());
    }

    public static void setPlantingPositions(String playerUuid, List<BlockPos> positions) {
        if (positions == null) {
            plantingPositions.remove(playerUuid);
        } else {
            plantingPositions.put(playerUuid, Collections.unmodifiableList(new ArrayList<BlockPos>(positions)));
        }
    }

    public static List<BlockPos> getPlantingPositions(String playerUuid) {
        return plantingPositions.getOrDefault(playerUuid, Collections.emptyList());
    }

    public static void clearAll(String playerUuid) {
        miningPositions.remove(playerUuid);
        interactionPositions.remove(playerUuid);
        plantingPositions.remove(playerUuid);
        chainModeState.remove(playerUuid);
        shearingEntityUuids.remove(playerUuid);
    }

    public static void setShearingEntityUuids(String playerUuid, List<UUID> uuids) {
        if (uuids == null) {
            shearingEntityUuids.remove(playerUuid);
        } else {
            shearingEntityUuids.put(playerUuid, Collections.unmodifiableList(new ArrayList<UUID>(uuids)));
        }
    }

    public static List<UUID> getShearingEntityUuids(String playerUuid) {
        return shearingEntityUuids.getOrDefault(playerUuid, Collections.emptyList());
    }

    public static void setChainMode(String playerUuid, boolean active) {
        chainModeState.put(playerUuid, active);
    }

    public static boolean isChainModeActive(String playerUuid) {
        return chainModeState.getOrDefault(playerUuid, false);
    }
}

