/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.capability;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;

public class ChainModeCapability {
    private static final String CHAIN_MODE_TAG = "onekeyminer:chain_mode";

    public static boolean isChainModeActive(EntityPlayerMP player) {
        try {
            NBTTagCompound data = player.getEntityData();
            if (!data.func_74764_b("PlayerPersisted")) {
                data.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
            }
            NBTTagCompound persisted = data.func_74775_l("PlayerPersisted");
            return persisted.func_74767_n(CHAIN_MODE_TAG);
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.debug("\u68c0\u67e5\u8fde\u9501\u6a21\u5f0f\u65f6\u8bfb\u53d6\u6301\u4e45\u5316\u6570\u636e\u51fa\u9519: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static void setChainMode(EntityPlayerMP player, boolean active) {
        try {
            NBTTagCompound data = player.getEntityData();
            if (!data.func_74764_b("PlayerPersisted")) {
                data.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
            }
            NBTTagCompound persisted = data.func_74775_l("PlayerPersisted");
            persisted.func_74757_a(CHAIN_MODE_TAG, active);
            data.func_74782_a("PlayerPersisted", (NBTBase)persisted);
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8bbe\u7f6e\u8fde\u9501\u6a21\u5f0f\u6301\u4e45\u5316\u6570\u636e\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer originalPlayer = event.getOriginal();
        if (event.getEntityPlayer() instanceof EntityPlayer) {
            EntityPlayer newPlayer = event.getEntityPlayer();
            if (event.isWasDeath()) {
                boolean wasChainActive = false;
                try {
                    NBTTagCompound origData = originalPlayer.getEntityData();
                    if (origData.func_74764_b("PlayerPersisted")) {
                        NBTTagCompound origPersisted = origData.func_74775_l("PlayerPersisted");
                        wasChainActive = origPersisted.func_74767_n(CHAIN_MODE_TAG);
                    }
                }
                catch (Exception e) {
                    Onekeyminer.LOGGER.error("\u8bfb\u53d6\u539f\u59cb\u73a9\u5bb6\u8fde\u9501\u6a21\u5f0f\u6570\u636e\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
                }
                try {
                    NBTTagCompound data = newPlayer.getEntityData();
                    if (!data.func_74764_b("PlayerPersisted")) {
                        data.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
                    }
                    NBTTagCompound persisted = data.func_74775_l("PlayerPersisted");
                    persisted.func_74757_a(CHAIN_MODE_TAG, wasChainActive);
                    data.func_74782_a("PlayerPersisted", (NBTBase)persisted);
                }
                catch (Exception e) {
                    Onekeyminer.LOGGER.error("\u590d\u5236\u73a9\u5bb6\u8fde\u9501\u6a21\u5f0f\u6570\u636e\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
                }
            }
        }
    }
}

