/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.config.ServerConfig;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ChainHandler {
    private static final Set<BlockPos> CURRENTLY_MINING = new HashSet<BlockPos>();
    private static int XPS = 0;

    public static boolean tryChainMine(EntityPlayerMP player, BlockPos pos, IBlockState state, ItemStack tool) {
        CURRENTLY_MINING.clear();
        if (player == null || pos == null || state == null || tool == null) {
            Onekeyminer.LOGGER.debug("\u8fde\u9501\u6316\u6398\u53c2\u6570\u65e0\u6548");
            return false;
        }
        if (!ChainHandler.validateChainMiningConditions(player, pos, state, tool)) {
            return false;
        }
        String blockId = state.func_177230_c().func_149739_a();
        String blockName = state.func_177230_c().func_149739_a();
        int blocksMined = ChainHandler.performChainMining(player, pos, state, tool);
        if (blocksMined > 0) {
            ChainHandler.sendFeedback(player, blocksMined);
        }
        return blocksMined > 0;
    }

    public static List<BlockPos> computeMiningPositions(EntityPlayerMP player, WorldServer level, BlockPos startPos, IBlockState startState, ItemStack tool) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || startState == null || tool == null) {
            return result;
        }
        int maxBlocks = player.func_184812_l_() ? CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : CommonConfig.INSTANCE.maxBlocksInChain.get();
        int maxDepth = CommonConfig.INSTANCE.maxChainDepth.get();
        boolean diagonal = CommonConfig.INSTANCE.enableDiagonalChaining.get();
        boolean matchFullState = CommonConfig.INSTANCE.matchIBlockState.get();
        boolean matchseedState = CommonConfig.INSTANCE.matchseedIBlockState.get();
        LinkedList<BlockPos> toMine = new LinkedList<BlockPos>();
        LinkedHashSet<BlockPos> minedPositions = new LinkedHashSet<BlockPos>();
        toMine.add(startPos);
        long startTime = System.currentTimeMillis();
        long timeLimit = 300L;
        int maxIterations = Math.min(5000, maxBlocks * 8);
        int iterations = 0;
        try {
            while (!toMine.isEmpty() && result.size() < maxBlocks && iterations < maxIterations && System.currentTimeMillis() - startTime <= 300L) {
                IBlockState currentState;
                ++iterations;
                BlockPos currentPos = (BlockPos)toMine.poll();
                if (minedPositions.contains(currentPos) || Math.abs(currentPos.func_177956_o() - startPos.func_177956_o()) > maxDepth || !ChainHandler.isBlockMatching(startState, currentState = level.func_180495_p(currentPos), matchFullState, matchseedState)) continue;
                minedPositions.add(currentPos);
                result.add(currentPos);
                for (BlockPos neighbor : ChainHandler.getNeighborPositions(currentPos, diagonal)) {
                    if (minedPositions.contains(neighbor) || toMine.size() >= maxBlocks - result.size()) continue;
                    toMine.add(neighbor);
                }
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8ba1\u7b97\u8fde\u9501\u6316\u6398\u4f4d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    private static boolean validateChainMiningConditions(EntityPlayerMP player, BlockPos pos, IBlockState state, ItemStack tool) {
        if (!ChainModeCapability.isChainModeActive(player)) {
            if (CommonConfig.INSTANCE.enableDebugMode.get()) {
                Onekeyminer.LOGGER.debug("\u8fde\u9501\u6a21\u5f0f\u672a\u542f\u7528");
            }
            return false;
        }
        if (state.func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        if (CommonConfig.INSTANCE.requireSneaking.get() && !player.func_70093_af()) {
            if (CommonConfig.INSTANCE.enableDebugMode.get()) {
                Onekeyminer.LOGGER.debug("\u9700\u8981\u4e0b\u8e72\u4f46\u73a9\u5bb6\u672a\u4e0b\u8e72");
            }
            return false;
        }
        if (player.func_184812_l_() && !CommonConfig.INSTANCE.enableInCreative.get()) {
            if (CommonConfig.INSTANCE.enableDebugMode.get()) {
                Onekeyminer.LOGGER.debug("\u521b\u9020\u6a21\u5f0f\u4e0b\u8fde\u9501\u6316\u6398\u672a\u542f\u7528");
            }
            return false;
        }
        if (!player.func_184812_l_() && (double)player.func_71024_bL().func_75116_a() < ServerConfig.INSTANCE.hungerThreshold.get()) {
            if (CommonConfig.INSTANCE.enableDebugMode.get()) {
                Onekeyminer.LOGGER.debug("\u73a9\u5bb6\u9965\u997f\u5ea6\u4e0d\u8db3: {} < {}", (Object)player.func_71024_bL().func_75116_a(), (Object)ServerConfig.INSTANCE.hungerThreshold.get());
            }
            return false;
        }
        Block blockId = state.func_177230_c();
        String blockName = state.func_177230_c().func_149739_a();
        if (!CommonConfig.INSTANCE.isBlockMineable(blockId)) {
            if (CommonConfig.INSTANCE.enableDebugMode.get()) {
                Onekeyminer.LOGGER.debug("\u65b9\u5757\u5728\u4e0d\u53ef\u6316\u6398\u5217\u8868\u4e2d: {} (\u5185\u90e8ID: {})", (Object)blockName, (Object)blockId);
            }
            return false;
        }
        if (!CommonConfig.INSTANCE.ignoreToolCompatibility.get() && !player.func_184823_b(state)) {
            if (CommonConfig.INSTANCE.enableDebugMode.get()) {
                Onekeyminer.LOGGER.debug("\u5de5\u5177\u4e0d\u517c\u5bb9: {}", (Object)tool.func_77973_b().func_77658_a());
            }
            return false;
        }
        if (!player.func_184812_l_() && (tool.func_77984_f() || tool.func_77958_k() > 0)) {
            Double durabilityProtection = ServerConfig.INSTANCE.toolDurabilityThreshold.get();
            if ((double)tool.func_77952_i() >= (double)tool.func_77958_k() - durabilityProtection) {
                if (CommonConfig.INSTANCE.enableDebugMode.get()) {
                    Onekeyminer.LOGGER.debug("\u5de5\u5177\u8010\u4e45\u5ea6\u4e0d\u8db3\u8fdb\u884c\u8fde\u9501\u6316\u6398");
                }
                return false;
            }
        }
        return true;
    }

    private static int performChainMining(EntityPlayerMP player, BlockPos startPos, IBlockState startState, ItemStack tool) {
        World level = player.field_70170_p;
        WorldServer serverLevel = (WorldServer)level;
        int maxBlocks = player.func_184812_l_() ? CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : CommonConfig.INSTANCE.maxBlocksInChain.get();
        int maxDepth = CommonConfig.INSTANCE.maxChainDepth.get();
        boolean diagonal = CommonConfig.INSTANCE.enableDiagonalChaining.get();
        boolean matchFullState = CommonConfig.INSTANCE.matchIBlockState.get();
        boolean matchseedState = CommonConfig.INSTANCE.matchseedIBlockState.get();
        boolean teleportDrops = CommonConfig.INSTANCE.teleportDropsToPlayer.get();
        LinkedList<BlockPos> toMine = new LinkedList<BlockPos>();
        LinkedHashSet<BlockPos> minedPositions = new LinkedHashSet<BlockPos>();
        toMine.add(startPos);
        int blocksMined = 0;
        XPS = 0;
        while (!toMine.isEmpty() && blocksMined < maxBlocks) {
            boolean blockDestroyed;
            IBlockState currentState;
            BlockPos currentPos = (BlockPos)toMine.poll();
            if (minedPositions.contains(currentPos) || Math.abs(currentPos.func_177956_o() - startPos.func_177956_o()) > maxDepth || !ChainHandler.isBlockMatching(startState, currentState = level.func_180495_p(currentPos), matchFullState, matchseedState)) continue;
            minedPositions.add(currentPos);
            if (teleportDrops) {
                blockDestroyed = ChainHandler.breakBlockWithTeleport(serverLevel, currentPos, currentState, player, tool);
            } else {
                blockDestroyed = level.func_175655_b(currentPos, true);
                if (!blockDestroyed) continue;
                try {
                    level.func_184133_a(null, currentPos, currentState.func_177230_c().getSoundType(currentState, level, currentPos, (Entity)player).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!blockDestroyed) continue;
            ++blocksMined;
            for (BlockPos neighbor : ChainHandler.getNeighborPositions(currentPos, diagonal)) {
                if (minedPositions.contains(neighbor) || toMine.size() >= maxBlocks - blocksMined) continue;
                toMine.add(neighbor);
            }
        }
        if (teleportDrops && XPS > 0) {
            BlockPos dropPos = player.func_180425_c();
            EntityXPOrb orb = new EntityXPOrb(level, (double)dropPos.func_177958_n() + 0.5, (double)dropPos.func_177956_o() + 0.5, (double)dropPos.func_177952_p() + 0.5, XPS);
            try {
                level.func_72838_d((Entity)orb);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            XPS = 0;
        }
        return blocksMined;
    }

    private static boolean isBlockMatching(IBlockState reference, IBlockState target, boolean matchFullState, boolean matchSeedState) {
        if (target.func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        if (matchFullState && !(target.func_177230_c() instanceof BlockCrops) || matchSeedState && target.func_177230_c() instanceof BlockCrops) {
            return reference.equals(target);
        }
        if (reference.func_177230_c() == target.func_177230_c()) {
            if (ChainHandler.hasSpecialMatchingRules(reference.func_177230_c())) {
                return ChainHandler.matchSpecialBlockProperties(reference, target);
            }
            return true;
        }
        return false;
    }

    private static boolean hasSpecialMatchingRules(Block block) {
        String blockId = block.func_149739_a();
        return blockId.contains("ore") || blockId.contains("log") || blockId.contains("wood") || blockId.contains("leaves");
    }

    private static boolean matchSpecialBlockProperties(IBlockState reference, IBlockState target) {
        if (reference.func_177230_c().func_149739_a().contains("ore")) {
            return true;
        }
        if (reference.func_177230_c().func_149739_a().contains("log") || reference.func_177230_c().func_149739_a().contains("wood")) {
            String refType = ChainHandler.extractWoodType(reference.func_177230_c().func_149739_a());
            String targetType = ChainHandler.extractWoodType(target.func_177230_c().func_149739_a());
            return refType.equals(targetType);
        }
        if (reference.func_177230_c().func_149739_a().contains("leaves")) {
            String refType = ChainHandler.extractWoodType(reference.func_177230_c().func_149739_a());
            String targetType = ChainHandler.extractWoodType(target.func_177230_c().func_149739_a());
            return refType.equals(targetType);
        }
        return true;
    }

    private static String extractWoodType(String blockId) {
        for (String woodType : new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "crimson", "warped", "mangrove", "cherry"}) {
            if (!blockId.contains(woodType)) continue;
            return woodType;
        }
        return blockId;
    }

    private static boolean breakBlockWithTeleport(WorldServer level, BlockPos pos, IBlockState state, EntityPlayerMP player, ItemStack tool) {
        if (level == null || player == null) {
            return false;
        }
        BlockPos dropPos = player.func_180425_c();
        try {
            TileEntity blockEntity = level.func_175625_s(pos);
            boolean broken = level.func_175655_b(pos, true);
            if (!broken) {
                return false;
            }
            try {
                AxisAlignedBB box = new AxisAlignedBB(pos);
                List items = level.func_72872_a(EntityItem.class, box);
                for (EntityItem ei : items) {
                    ei.func_70107_b((double)dropPos.func_177958_n() + 0.5, (double)dropPos.func_177956_o() + 0.5, (double)dropPos.func_177952_p() + 0.5);
                    ei.field_70159_w = 0.0;
                    ei.field_70181_x = 0.0;
                    ei.field_70179_y = 0.0;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u4f20\u9001\u6389\u843d\u7269\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static List<BlockPos> getNeighborPositions(BlockPos pos, boolean includeDiagonal) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>(14);
        neighbors.add(pos.func_177984_a());
        neighbors.add(pos.func_177977_b());
        neighbors.add(pos.func_177978_c());
        neighbors.add(pos.func_177968_d());
        neighbors.add(pos.func_177974_f());
        neighbors.add(pos.func_177976_e());
        if (includeDiagonal) {
            neighbors.add(pos.func_177978_c().func_177974_f());
            neighbors.add(pos.func_177978_c().func_177976_e());
            neighbors.add(pos.func_177968_d().func_177974_f());
            neighbors.add(pos.func_177968_d().func_177976_e());
            neighbors.add(pos.func_177984_a().func_177978_c());
            neighbors.add(pos.func_177984_a().func_177968_d());
            neighbors.add(pos.func_177984_a().func_177974_f());
            neighbors.add(pos.func_177984_a().func_177976_e());
            neighbors.add(pos.func_177977_b().func_177978_c());
            neighbors.add(pos.func_177977_b().func_177968_d());
            neighbors.add(pos.func_177977_b().func_177974_f());
            neighbors.add(pos.func_177977_b().func_177976_e());
            neighbors.add(pos.func_177984_a().func_177978_c().func_177974_f());
            neighbors.add(pos.func_177984_a().func_177978_c().func_177976_e());
            neighbors.add(pos.func_177984_a().func_177968_d().func_177974_f());
            neighbors.add(pos.func_177984_a().func_177968_d().func_177976_e());
            neighbors.add(pos.func_177977_b().func_177978_c().func_177974_f());
            neighbors.add(pos.func_177977_b().func_177978_c().func_177976_e());
            neighbors.add(pos.func_177977_b().func_177968_d().func_177974_f());
            neighbors.add(pos.func_177977_b().func_177968_d().func_177976_e());
        }
        return neighbors;
    }

    private static void sendFeedback(EntityPlayerMP player, int blocksMined) {
        NetworkHandler.sendToPlayer(new ChainActionPacket("mining", blocksMined), player);
    }
}

