/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.api.ChainPositionStore;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class InteractionHandler {
    private static final Set<BlockPos> PROCESSED_POSITIONS = new HashSet<BlockPos>();
    private static final Set<Integer> PROCESSED_ENTITY_IDS = new HashSet<Integer>();

    public static boolean isValidInteractionTool(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item instanceof ItemHoe || item instanceof ItemAxe || item instanceof ItemSpade || item instanceof ItemShears;
    }

    public static List<BlockPos> computeInteractionPositions(EntityPlayerMP player, WorldServer level, BlockPos startPos, IBlockState targetState, EnumHand hand) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || targetState == null) {
            return result;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b() || !InteractionHandler.isValidInteractionTool(heldItem)) {
            return result;
        }
        if (level.func_175623_d(startPos)) {
            return result;
        }
        int maxBlocks = player.func_184812_l_() ? CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : CommonConfig.INSTANCE.maxBlocksInChain.get();
        int maxDepth = CommonConfig.INSTANCE.maxChainDepth.get();
        boolean includeDiagonal = CommonConfig.INSTANCE.enableDiagonalChaining.get();
        LinkedList<BlockSearchNode> queue = new LinkedList<BlockSearchNode>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(new BlockSearchNode(startPos, 0));
        long startTime = System.currentTimeMillis();
        long timeLimit = 300L;
        int maxIterations = Math.min(5000, maxBlocks * 8);
        int iterations = 0;
        try {
            while (!queue.isEmpty() && result.size() < maxBlocks && iterations < maxIterations && System.currentTimeMillis() - startTime <= 300L) {
                ++iterations;
                BlockSearchNode node = (BlockSearchNode)queue.poll();
                BlockPos pos = node.pos;
                if (node.depth > maxDepth || visited.contains(pos)) continue;
                visited.add(pos);
                IBlockState state = level.func_180495_p(pos);
                if (!InteractionHandler.isMatchingBlock(state, targetState)) continue;
                result.add(pos);
                for (BlockPos neighbor : InteractionHandler.getNeighborPositions(pos, includeDiagonal)) {
                    if (visited.contains(neighbor)) continue;
                    queue.offer(new BlockSearchNode(neighbor, node.depth + 1));
                }
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8ba1\u7b97\u8fde\u9501\u4ea4\u4e92\u4f4d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    @Deprecated
    public static void handleChainInteraction(EntityPlayerMP player, PlayerInteractEvent.RightClickBlock event) {
        InteractionHandler.tryChainInteraction(player, (WorldServer)event.getWorld(), event.getPos(), event.getFace(), event.getHitVec(), event.getHand());
    }

    public static boolean tryChainInteraction(EntityPlayerMP player, WorldServer level, BlockPos pos, EnumFacing side, Vec3d hitVec, EnumHand hand) {
        PROCESSED_POSITIONS.clear();
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b() || !InteractionHandler.isValidInteractionTool(heldItem)) {
            return false;
        }
        IBlockState initialState = level.func_180495_p(pos);
        if (level.func_175623_d(pos)) {
            return false;
        }
        if (ClientConfig.INSTANCE.Debug.get()) {
            Onekeyminer.LOGGER.debug("\u5c1d\u8bd5\u8fde\u9501\u4ea4\u4e92: {}", (Object)initialState.func_177230_c().func_149739_a());
        }
        RayTraceResult initialHit = new RayTraceResult(hitVec, side, pos);
        int maxBlocks = player.func_184812_l_() ? CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : CommonConfig.INSTANCE.maxBlocksInChain.get();
        boolean includeDiagonal = CommonConfig.INSTANCE.enableDiagonalChaining.get();
        int processedCount = InteractionHandler.floodFillInteraction(player, level, initialState, initialHit, hand, maxBlocks, CommonConfig.INSTANCE.maxChainDepth.get(), includeDiagonal);
        if (processedCount > 0) {
            NetworkHandler.sendToPlayer(new ChainActionPacket("interaction", processedCount), player);
            return true;
        }
        return false;
    }

    private static int floodFillInteraction(EntityPlayerMP player, WorldServer level, IBlockState targetState, RayTraceResult initialHit, EnumHand hand, int maxBlocks, int maxDepth, boolean includeDiagonal) {
        LinkedList<BlockSearchNode> queue = new LinkedList<BlockSearchNode>();
        queue.add(new BlockSearchNode(initialHit.func_178782_a(), 0));
        int processedCount = 0;
        ItemStack heldItem = player.func_184586_b(hand);
        while (!queue.isEmpty() && processedCount < maxBlocks) {
            IBlockState state;
            BlockSearchNode node = (BlockSearchNode)queue.poll();
            BlockPos pos = node.pos;
            if (node.depth > maxDepth || PROCESSED_POSITIONS.contains(pos) || !InteractionHandler.isMatchingBlock(state = level.func_180495_p(pos), targetState)) continue;
            if (heldItem.func_190926_b() || heldItem.func_77952_i() >= heldItem.func_77958_k() - 1) break;
            PROCESSED_POSITIONS.add(pos);
            EnumActionResult result = heldItem.func_179546_a((EntityPlayer)player, (World)level, pos, hand, initialHit.field_178784_b, (float)initialHit.field_72307_f.field_72450_a, (float)initialHit.field_72307_f.field_72448_b, (float)initialHit.field_72307_f.field_72449_c);
            if (result == EnumActionResult.SUCCESS) {
                ++processedCount;
                if (ClientConfig.INSTANCE.Debug.get()) {
                    Onekeyminer.LOGGER.debug("\u8fde\u9501\u4ea4\u4e92\u6210\u529f: {}", (Object)pos);
                }
            }
            for (BlockPos neighbor : InteractionHandler.getNeighborPositions(pos, includeDiagonal)) {
                queue.offer(new BlockSearchNode(neighbor, node.depth + 1));
            }
        }
        Onekeyminer.LOGGER.debug("\u8fde\u9501\u4ea4\u4e92\u5b8c\u6210\uff0c\u5171\u5904\u7406 {} \u4e2a\u65b9\u5757", (Object)processedCount);
        return processedCount;
    }

    private static boolean isMatchingBlock(IBlockState state, IBlockState target) {
        if (state.func_177230_c() == Blocks.field_150350_a || target.func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        if (CommonConfig.INSTANCE.matchIBlockState.get() && !(target.func_177230_c() instanceof BlockCrops) || CommonConfig.INSTANCE.matchseedIBlockState.get() && target.func_177230_c() instanceof BlockCrops) {
            return state.equals(target);
        }
        return state.func_177230_c() == target.func_177230_c();
    }

    private static List<BlockPos> getNeighborPositions(BlockPos pos, boolean includeDiagonal) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        neighbors.add(pos.func_177984_a());
        neighbors.add(pos.func_177977_b());
        neighbors.add(pos.func_177978_c());
        neighbors.add(pos.func_177968_d());
        neighbors.add(pos.func_177974_f());
        neighbors.add(pos.func_177976_e());
        if (includeDiagonal) {
            neighbors.add(pos.func_177978_c().func_177974_f());
            neighbors.add(pos.func_177978_c().func_177976_e());
            neighbors.add(pos.func_177968_d().func_177974_f());
            neighbors.add(pos.func_177968_d().func_177976_e());
            neighbors.add(pos.func_177984_a().func_177978_c());
            neighbors.add(pos.func_177984_a().func_177968_d());
            neighbors.add(pos.func_177984_a().func_177974_f());
            neighbors.add(pos.func_177984_a().func_177976_e());
            neighbors.add(pos.func_177977_b().func_177978_c());
            neighbors.add(pos.func_177977_b().func_177968_d());
            neighbors.add(pos.func_177977_b().func_177974_f());
            neighbors.add(pos.func_177977_b().func_177976_e());
            neighbors.add(pos.func_177984_a().func_177978_c().func_177974_f());
            neighbors.add(pos.func_177984_a().func_177978_c().func_177976_e());
            neighbors.add(pos.func_177984_a().func_177968_d().func_177974_f());
            neighbors.add(pos.func_177984_a().func_177968_d().func_177976_e());
            neighbors.add(pos.func_177977_b().func_177978_c().func_177974_f());
            neighbors.add(pos.func_177977_b().func_177978_c().func_177976_e());
            neighbors.add(pos.func_177977_b().func_177968_d().func_177974_f());
            neighbors.add(pos.func_177977_b().func_177968_d().func_177976_e());
        }
        return neighbors;
    }

    public static boolean tryChainShearing(EntityPlayerMP player, EntitySheep targetSheep, EnumHand hand) {
        PROCESSED_ENTITY_IDS.clear();
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b() || !(heldItem.func_77973_b() instanceof ItemShears)) {
            return false;
        }
        if (ClientConfig.INSTANCE.Debug.get()) {
            Onekeyminer.LOGGER.debug("\u5c1d\u8bd5\u8fde\u9501\u526a\u7f8a\u6bdb: {}", (Object)targetSheep.func_145782_y());
        }
        int maxEntities = player.func_184812_l_() ? CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : CommonConfig.INSTANCE.maxBlocksInChain.get();
        double searchRadius = (double)CommonConfig.INSTANCE.maxChainDepth.get() * 0.5;
        if (CommonConfig.INSTANCE.enableDiagonalChaining.get()) {
            searchRadius *= 1.5;
        }
        PROCESSED_ENTITY_IDS.add(targetSheep.func_145782_y());
        boolean teleportDrops = CommonConfig.INSTANCE.teleportDropsToPlayer.get();
        BlockPos playerPos = player.func_180425_c();
        WorldServer level = (WorldServer)player.field_70170_p;
        AxisAlignedBB searchBox = new AxisAlignedBB(targetSheep.field_70165_t - searchRadius, targetSheep.field_70163_u - searchRadius, targetSheep.field_70161_v - searchRadius, targetSheep.field_70165_t + searchRadius, targetSheep.field_70163_u + searchRadius, targetSheep.field_70161_v + searchRadius);
        List allSheepInArea = level.func_72872_a(EntitySheep.class, searchBox);
        if (ClientConfig.INSTANCE.Debug.get()) {
            Onekeyminer.LOGGER.debug("\u627e\u5230 {} \u53ea\u53ef\u526a\u7f8a", (Object)(allSheepInArea.size() + 1));
        }
        int shearedCount = 1;
        ArrayList<UUID> shearingUuids = new ArrayList<UUID>();
        shearingUuids.add(targetSheep.func_110124_au());
        for (EntitySheep s : allSheepInArea) {
            shearingUuids.add(s.func_110124_au());
        }
        try {
            String key = player.func_110124_au().toString();
            ChainPositionStore.setShearingEntityUuids(key, shearingUuids);
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.debug("\u5199\u5165\u526a\u7f8a UUID \u5217\u8868\u5230 ChainPositionStore \u65f6\u51fa\u9519: {}", (Object)e.getMessage());
        }
        for (EntitySheep sheep : allSheepInArea) {
            if (shearedCount >= maxEntities) break;
            try {
                if (!sheep.func_70089_S() || PROCESSED_ENTITY_IDS.contains(sheep.func_145782_y())) continue;
                boolean wasShearable = true;
                boolean woolColorBefore = false;
                boolean shearingSuccessful = false;
                if (teleportDrops) {
                    double originalX = sheep.field_70165_t;
                    double originalY = sheep.field_70163_u;
                    double originalZ = sheep.field_70161_v;
                    try {
                        sheep.func_70107_b((double)playerPos.func_177958_n(), (double)playerPos.func_177956_o(), (double)playerPos.func_177952_p());
                        List items = new ArrayList();
                        try {
                            if (sheep instanceof IShearable) {
                                items = sheep.onSheared(heldItem, (IBlockAccess)level, sheep.func_180425_c(), 1);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        boolean bl = shearingSuccessful = !items.isEmpty();
                        if (shearingSuccessful && !player.field_71075_bZ.field_75098_d) {
                            try {
                                heldItem.func_77972_a(1, (EntityLivingBase)player);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        for (ItemStack itemStack : items) {
                            EntityItem itemEntity = new EntityItem((World)level, sheep.field_70165_t, sheep.field_70163_u + 1.0, sheep.field_70161_v, itemStack);
                            try {
                                level.func_72838_d((Entity)itemEntity);
                            }
                            catch (Exception exception) {}
                        }
                        if (ClientConfig.INSTANCE.Debug.get()) {
                            Onekeyminer.LOGGER.debug("\u526a\u7f8a\u72b6\u6001: \u4f7f\u7528IShearable.onSheared, \u6389\u843d\u7269\u6570\u91cf={}", (Object)items.size());
                        }
                        sheep.func_70107_b(originalX, originalY, originalZ);
                    }
                    catch (Exception e) {
                        Onekeyminer.LOGGER.error("\u4f20\u9001\u7f8a\u6bdb\u6389\u843d\u7269\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
                        sheep.func_70107_b(originalX, originalY, originalZ);
                    }
                } else {
                    List items = new ArrayList();
                    try {
                        if (sheep instanceof IShearable) {
                            items = sheep.onSheared(heldItem, (IBlockAccess)level, sheep.func_180425_c(), 1);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    boolean bl = shearingSuccessful = !items.isEmpty();
                    if (shearingSuccessful && !player.field_71075_bZ.field_75098_d) {
                        try {
                            heldItem.func_77972_a(1, (EntityLivingBase)player);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    for (ItemStack itemStack : items) {
                        EntityItem itemEntity = new EntityItem((World)level, sheep.field_70165_t, sheep.field_70163_u + 1.0, sheep.field_70161_v, itemStack);
                        try {
                            level.func_72838_d((Entity)itemEntity);
                        }
                        catch (Exception exception) {}
                    }
                    if (ClientConfig.INSTANCE.Debug.get()) {
                        Onekeyminer.LOGGER.debug("\u526a\u7f8a\u72b6\u6001: \u4f7f\u7528IShearable.onSheared, \u6389\u843d\u7269\u6570\u91cf={}", (Object)items.size());
                    }
                }
                if (shearingSuccessful) {
                    PROCESSED_ENTITY_IDS.add(sheep.func_145782_y());
                    ++shearedCount;
                    if (ClientConfig.INSTANCE.Debug.get()) {
                        Onekeyminer.LOGGER.debug("\u6210\u529f\u526a\u4e86\u7f8a {}", (Object)sheep.func_145782_y());
                    }
                    if (!heldItem.func_190926_b()) continue;
                    break;
                }
                if (!ClientConfig.INSTANCE.Debug.get()) continue;
                Onekeyminer.LOGGER.debug("\u526a\u7f8a {} \u5931\u8d25\uff0c\u5c3d\u7ba1\u5b83\u5e94\u8be5\u662f\u53ef\u526a\u7684", (Object)sheep.func_145782_y());
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.error("\u5904\u7406\u7f8a {} \u65f6\u51fa\u9519: {}", (Object)sheep.func_145782_y(), (Object)e.getMessage());
            }
        }
        if (ClientConfig.INSTANCE.Debug.get()) {
            Onekeyminer.LOGGER.debug("\u6210\u529f\u526a\u4e86 {} \u53ea\u7f8a", (Object)shearedCount);
        }
        if (shearedCount > 1 && ClientConfig.INSTANCE.showBlockCount.get()) {
            String messageStyle = ClientConfig.INSTANCE.messageStyle.get();
            if (messageStyle.equals("chat") || messageStyle.equals("both")) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.onekeyminer.chain_shearing", new Object[]{shearedCount}));
            }
            if (messageStyle.equals("actionbar") || messageStyle.equals("both")) {
                NetworkHandler.sendToPlayer(new ChainActionPacket("shearing", shearedCount), player);
            }
            return true;
        }
        return shearedCount > 1;
    }

    private static class BlockSearchNode {
        final BlockPos pos;
        final int depth;

        BlockSearchNode(BlockPos pos, int depth) {
            this.pos = pos;
            this.depth = depth;
        }
    }
}

