/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class PlantingHandler {
    private static final Set<BlockPos> CURRENTLY_PLANTING = new HashSet<BlockPos>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP serverPlayer = (EntityPlayerMP)player;
        ItemStack heldItem = player.func_184586_b(event.getHand());
        if (!PlantingHandler.isPlantableItem(heldItem)) {
            return;
        }
        if (PlantingHandler.isInBlacklist(heldItem)) {
            return;
        }
        BlockPos pos = event.getPos();
        Set<BlockPos> set = CURRENTLY_PLANTING;
        synchronized (set) {
            if (CURRENTLY_PLANTING.contains(pos)) {
                return;
            }
            CURRENTLY_PLANTING.add(pos);
        }
        try {
            serverPlayer.func_184102_h().func_152344_a(() -> {
                try {
                    World level = serverPlayer.field_70170_p;
                    IBlockState targetState = level.func_180495_p(pos);
                    PlantingHandler.performChainPlanting(serverPlayer, event.getHand(), pos, targetState, heldItem);
                }
                finally {
                    Set<BlockPos> set = CURRENTLY_PLANTING;
                    synchronized (set) {
                        CURRENTLY_PLANTING.remove(pos);
                    }
                }
            });
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8c03\u5ea6\u8fde\u9501\u79cd\u690d\u4efb\u52a1\u5931\u8d25: {}", (Object)e.getMessage());
            Set<BlockPos> set2 = CURRENTLY_PLANTING;
            synchronized (set2) {
                CURRENTLY_PLANTING.remove(pos);
            }
        }
    }

    private static void performChainPlanting(EntityPlayerMP player, EnumHand hand, BlockPos startPos, IBlockState targetState, ItemStack seedItem) {
        World level = player.field_70170_p;
        if (!(level instanceof WorldServer)) {
            return;
        }
        int maxPlants = CommonConfig.INSTANCE.maxBlocksInChain.get();
        if (player.func_184812_l_()) {
            maxPlants = CommonConfig.INSTANCE.maxBlocksInChainCreative.get();
        }
        long startTime = System.currentTimeMillis();
        long timeLimit = 2000L;
        int maxIterations = Math.min(10000, maxPlants * 10);
        int iterations = 0;
        int availableSeeds = PlantingHandler.countAvailableItems((EntityPlayer)player, seedItem.func_77973_b());
        if (player.func_184812_l_()) {
            availableSeeds = Integer.MAX_VALUE;
        }
        BlockPos plantStartPos = startPos.func_177984_a();
        LinkedList<BlockPos> positionsToCheck = new LinkedList<BlockPos>();
        positionsToCheck.add(plantStartPos);
        HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
        checkedPositions.add(plantStartPos);
        HashSet<BlockPos> plantedPositions = new HashSet<BlockPos>();
        boolean allowDiagonal = CommonConfig.INSTANCE.enableDiagonalChaining.get();
        int plantsCount = 0;
        try {
            while (!positionsToCheck.isEmpty() && plantsCount < maxPlants && iterations < maxIterations && System.currentTimeMillis() - startTime <= 2000L) {
                ++iterations;
                BlockPos currentPos = (BlockPos)positionsToCheck.poll();
                if (plantedPositions.contains(currentPos)) continue;
                if (plantsCount >= availableSeeds && !player.func_184812_l_()) break;
                if (PlantingHandler.canPlantAt(level, currentPos, level.func_180495_p(currentPos), seedItem)) {
                    try {
                        if (PlantingHandler.tryPlant(player, hand, currentPos, seedItem)) {
                            plantedPositions.add(currentPos);
                            ++plantsCount;
                            if (!player.func_184812_l_()) {
                                --availableSeeds;
                            }
                        }
                    }
                    catch (Exception e) {
                        Onekeyminer.LOGGER.error("\u5728\u4f4d\u7f6e {} \u79cd\u690d\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)currentPos, (Object)e.getMessage());
                    }
                }
                for (EnumFacing direction : EnumFacing.values()) {
                    try {
                        BlockPos adjacentPos = currentPos.func_177972_a(direction);
                        if (checkedPositions.contains(adjacentPos) || !(adjacentPos.func_177951_i((Vec3i)plantStartPos) <= 100.0)) continue;
                        positionsToCheck.add(adjacentPos);
                        checkedPositions.add(adjacentPos);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (allowDiagonal && iterations % 2 == 0) {
                    for (int x = -1; x <= 1; x += 2) {
                        for (int y = -1; y <= 1; y += 2) {
                            for (int z = -1; z <= 1; z += 2) {
                                try {
                                    BlockPos diagonalPos = currentPos.func_177982_a(x, y, z);
                                    if (checkedPositions.contains(diagonalPos) || !(diagonalPos.func_177951_i((Vec3i)plantStartPos) <= 100.0)) continue;
                                    positionsToCheck.add(diagonalPos);
                                    checkedPositions.add(diagonalPos);
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                if (positionsToCheck.size() <= 1000) continue;
                LinkedList limitedQueue = new LinkedList();
                for (int i = 0; i < 500 && !positionsToCheck.isEmpty(); ++i) {
                    limitedQueue.add(positionsToCheck.poll());
                }
                positionsToCheck = limitedQueue;
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8fde\u9501\u79cd\u690d\u8fc7\u7a0b\u4e2d\u53d1\u751f\u672a\u9884\u671f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
        if (plantsCount > 0) {
            try {
                NetworkHandler.sendToPlayer(new ChainActionPacket("planting", plantsCount), player);
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.error("\u53d1\u9001\u8fde\u9501\u79cd\u690d\u6d88\u606f\u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static boolean tryPlant(EntityPlayerMP player, EnumHand hand, BlockPos pos, ItemStack seedItem) {
        IBlockState plantedAbove;
        EnumActionResult result;
        boolean success;
        World level = player.field_70170_p;
        if (seedItem.func_190926_b() || seedItem.func_190916_E() <= 0) {
            Onekeyminer.LOGGER.info("\u79cd\u690d\u5931\u8d25\uff1a\u79cd\u5b50\u6570\u91cf\u4e0d\u8db3\uff0c\u7269\u54c1={}", (Object)seedItem.func_77977_a());
            return false;
        }
        ItemStack handStack = player.func_184586_b(hand);
        if (handStack.func_77973_b() != seedItem.func_77973_b() && (handStack = player.func_184586_b(hand = EnumHand.MAIN_HAND)).func_77973_b() != seedItem.func_77973_b()) {
            return false;
        }
        BlockPos clickPos = pos;
        IBlockState stateAtPos = level.func_180495_p(pos);
        BlockPos belowPos = pos.func_177977_b();
        IBlockState belowState = level.func_180495_p(belowPos);
        if (level.func_175623_d(pos) && (belowState.func_177230_c() instanceof BlockFarmland || belowState.func_177230_c() == Blocks.field_150458_ak)) {
            clickPos = belowPos;
        }
        boolean bl = success = (result = handStack.func_179546_a((EntityPlayer)player, level, clickPos, hand, EnumFacing.UP, 0.5f, 0.5f, 0.5f)) == EnumActionResult.SUCCESS;
        if (!success || clickPos != belowPos || (plantedAbove = level.func_180495_p(belowPos.func_177984_a())).func_177230_c() instanceof BlockCrops || plantedAbove.func_177230_c() instanceof BlockBush) {
            // empty if block
        }
        Onekeyminer.LOGGER.info("\u79cd\u690d\u8c03\u8bd5\uff1a\u624b={}, \u76ee\u6807\u70b9\u51fb\u5757={}, \u539f\u59cb\u7a7a\u6c14\u4f4d\u7f6e={}, \u4e0b\u65b9\u8015\u5730={}, \u79cd\u5b50\u6570\u91cf={}, \u7ed3\u679c={}", (Object)hand, (Object)clickPos, (Object)pos, (Object)belowPos, (Object)handStack.func_190916_E(), (Object)result);
        return success;
    }

    private static boolean canPlantAt(World level, BlockPos pos, IBlockState state, ItemStack seedItem) {
        Item item = seedItem.func_77973_b();
        BlockPos belowPos = pos.func_177977_b();
        IBlockState belowState = level.func_180495_p(belowPos);
        Block belowBlock = belowState.func_177230_c();
        if (!level.func_175623_d(pos)) {
            return false;
        }
        if (item == Items.field_151014_N || item == Items.field_185163_cU || item == Items.field_151174_bG || item == Items.field_151172_bF || item == Items.field_151080_bb || item == Items.field_151081_bc) {
            return belowBlock instanceof BlockFarmland || belowBlock == Blocks.field_150458_ak;
        }
        if (item == Items.field_151120_aE) {
            if (belowBlock != Blocks.field_150346_d && belowBlock != Blocks.field_150354_m && belowBlock != Blocks.field_150349_c && belowBlock != Blocks.field_150391_bh) {
                return false;
            }
            boolean waterNearby = false;
            for (EnumFacing f : new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST}) {
                BlockPos adj = belowPos.func_177972_a(f);
                Block adjBlock = level.func_180495_p(adj).func_177230_c();
                if (adjBlock != Blocks.field_150355_j && adjBlock != Blocks.field_150358_i) continue;
                waterNearby = true;
                break;
            }
            return waterNearby;
        }
        if (item instanceof ItemBlock) {
            ItemBlock ib = (ItemBlock)item;
            Block block = ib.func_179223_d();
            if (block instanceof BlockSapling || block instanceof BlockFlower || block instanceof BlockBush || block instanceof BlockMushroom) {
                return belowBlock == Blocks.field_150346_d || belowBlock == Blocks.field_150349_c || belowBlock == Blocks.field_150391_bh;
            }
            if (block instanceof BlockCactus) {
                if (belowBlock != Blocks.field_150354_m) {
                    return false;
                }
                for (EnumFacing f : new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST}) {
                    if (level.func_175623_d(pos.func_177972_a(f))) continue;
                    return false;
                }
                return true;
            }
            if (block instanceof BlockNetherWart) {
                return belowBlock == Blocks.field_150425_aM;
            }
            if (block instanceof BlockReed) {
                boolean waterNearby = false;
                for (EnumFacing f : new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST}) {
                    BlockPos adj = belowPos.func_177972_a(f);
                    Block adjBlock = level.func_180495_p(adj).func_177230_c();
                    if (adjBlock != Blocks.field_150355_j && adjBlock != Blocks.field_150358_i) continue;
                    waterNearby = true;
                    break;
                }
                return waterNearby && (belowBlock == Blocks.field_150346_d || belowBlock == Blocks.field_150354_m || belowBlock == Blocks.field_150349_c || belowBlock == Blocks.field_150391_bh);
            }
        }
        return PlantingHandler.canPlantOnSurface(item, belowState);
    }

    private static int countAvailableItems(EntityPlayer player, Item item) {
        ItemStack off;
        int count = 0;
        ItemStack main = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!main.func_190926_b() && main.func_77973_b() == item) {
            count += main.func_190916_E();
        }
        if (!(off = player.func_184586_b(EnumHand.OFF_HAND)).func_190926_b() && off.func_77973_b() == item) {
            count += off.func_190916_E();
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_190926_b() || stack.func_77973_b() != item) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    private static boolean canPlantOnSurface(Item item, IBlockState surfaceState) {
        Block surfaceBlock = surfaceState.func_177230_c();
        if (item == Items.field_151014_N || item == Items.field_185163_cU || item == Items.field_151174_bG || item == Items.field_151172_bF) {
            return surfaceBlock instanceof BlockFarmland || surfaceBlock == Blocks.field_150458_ak;
        }
        if (item instanceof ItemBlock) {
            ItemBlock blockItem = (ItemBlock)item;
            Block block = blockItem.func_179223_d();
            if (block instanceof BlockCrops) {
                return surfaceBlock instanceof BlockFarmland || surfaceBlock == Blocks.field_150458_ak;
            }
            if (block instanceof BlockSapling || block instanceof BlockFlower) {
                return surfaceBlock == Blocks.field_150346_d || surfaceBlock == Blocks.field_150349_c || surfaceBlock == Blocks.field_150391_bh;
            }
            if (block instanceof BlockMushroom) {
                return surfaceBlock == Blocks.field_150391_bh;
            }
        }
        return surfaceBlock == Blocks.field_150346_d || surfaceBlock == Blocks.field_150349_c || surfaceBlock == Blocks.field_150354_m || surfaceBlock == Blocks.field_150425_aM || surfaceBlock == Blocks.field_150391_bh;
    }

    static boolean isPlantableItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (PlantingHandler.isInBlacklist(stack)) {
            return false;
        }
        if (item instanceof ItemBlock) {
            ItemBlock blockItem = (ItemBlock)item;
            Block block = blockItem.func_179223_d();
            return block instanceof BlockCrops || block instanceof BlockSapling || block instanceof BlockBush || block instanceof BlockFlower || block instanceof BlockMushroom || block instanceof BlockCactus || block instanceof BlockReed || block instanceof BlockNetherWart;
        }
        String itemName = item.toString().toLowerCase();
        if (itemName.contains("seed") || itemName.contains("sapling") || itemName.contains("seedling") || itemName.contains("plant")) {
            return true;
        }
        return item == Items.field_151014_N || item == Items.field_185163_cU || item == Items.field_151080_bb || item == Items.field_151081_bc || item == Items.field_151174_bG || item == Items.field_151172_bF || item == Items.field_151120_aE;
    }

    private static boolean isInBlacklist(ItemStack stack) {
        return CommonConfig.INSTANCE.isSeedBlacklisted(stack.func_77973_b());
    }

    public static List<BlockPos> computePlantingPositions(EntityPlayerMP player, WorldServer level, BlockPos startPos, IBlockState targetState, ItemStack seedItem) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (!PlantingHandler.isPlantableItem(seedItem)) {
            return result;
        }
        BlockPos plantStartPos = startPos.func_177984_a();
        int maxPlants = CommonConfig.INSTANCE.maxBlocksInChain.get();
        if (player.func_184812_l_()) {
            maxPlants = CommonConfig.INSTANCE.maxBlocksInChainCreative.get();
        }
        long startTime = System.currentTimeMillis();
        long timeLimit = 500L;
        int maxIterations = Math.min(5000, maxPlants * 8);
        int iterations = 0;
        int availableSeeds = PlantingHandler.countAvailableItems((EntityPlayer)player, seedItem.func_77973_b());
        if (player.func_184812_l_()) {
            availableSeeds = Integer.MAX_VALUE;
        }
        LinkedList<BlockPos> positionsToCheck = new LinkedList<BlockPos>();
        positionsToCheck.add(plantStartPos);
        HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
        checkedPositions.add(plantStartPos);
        boolean allowDiagonal = CommonConfig.INSTANCE.enableDiagonalChaining.get();
        int plantsCount = 0;
        try {
            while (!positionsToCheck.isEmpty() && plantsCount < maxPlants && iterations < maxIterations && plantsCount < availableSeeds && System.currentTimeMillis() - startTime <= 500L) {
                ++iterations;
                BlockPos currentPos = (BlockPos)positionsToCheck.poll();
                if (PlantingHandler.canPlantAt((World)level, currentPos, level.func_180495_p(currentPos), seedItem)) {
                    result.add(currentPos);
                    ++plantsCount;
                }
                for (EnumFacing direction : EnumFacing.values()) {
                    BlockPos adjacentPos = currentPos.func_177972_a(direction);
                    if (checkedPositions.contains(adjacentPos) || !(adjacentPos.func_177951_i((Vec3i)plantStartPos) <= 100.0)) continue;
                    positionsToCheck.add(adjacentPos);
                    checkedPositions.add(adjacentPos);
                }
                if (allowDiagonal && iterations % 2 == 0) {
                    for (int x = -1; x <= 1; x += 2) {
                        for (int y = -1; y <= 1; y += 2) {
                            for (int z = -1; z <= 1; z += 2) {
                                BlockPos diagonalPos = currentPos.func_177982_a(x, y, z);
                                if (checkedPositions.contains(diagonalPos) || !(diagonalPos.func_177951_i((Vec3i)plantStartPos) <= 100.0)) continue;
                                positionsToCheck.add(diagonalPos);
                                checkedPositions.add(diagonalPos);
                            }
                        }
                    }
                }
                if (positionsToCheck.size() <= 500) continue;
                LinkedList limitedQueue = new LinkedList();
                for (int i = 0; i < 250 && !positionsToCheck.isEmpty(); ++i) {
                    limitedQueue.add(positionsToCheck.poll());
                }
                positionsToCheck = limitedQueue;
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8ba1\u7b97\u8fde\u9501\u79cd\u690d\u4f4d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleChainPlanting(EntityPlayerMP player, PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        EnumHand hand = event.getHand();
        ItemStack heldItem = player.func_184586_b(hand);
        boolean canProcess = false;
        Set<BlockPos> set = CURRENTLY_PLANTING;
        synchronized (set) {
            if (!CURRENTLY_PLANTING.contains(pos)) {
                CURRENTLY_PLANTING.add(pos);
                canProcess = true;
            }
        }
        if (!canProcess) {
            return;
        }
        try {
            player.func_184102_h().func_152344_a(() -> {
                Object level;
                try {
                    level = player.field_70170_p;
                    IBlockState targetState = level.func_180495_p(pos);
                    PlantingHandler.performChainPlanting(player, hand, pos, targetState, heldItem);
                }
                catch (Throwable e) {
                    Onekeyminer.LOGGER.error("\u8fde\u9501\u79cd\u690d\u6267\u884c\u671f\u95f4\u53d1\u751f\u4e25\u91cd\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
                }
                finally {
                    level = CURRENTLY_PLANTING;
                    synchronized (level) {
                        CURRENTLY_PLANTING.remove(pos);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            Onekeyminer.LOGGER.error("\u65e0\u6cd5\u63d0\u4ea4\u4efb\u52a1: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

