/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.api.ChainPositionStore;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.chain.ChainHandler;
import org.xiyu.yee.onekeyminer.chain.InteractionHandler;
import org.xiyu.yee.onekeyminer.chain.PlantingHandler;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.config.CommonConfig;

@Mod.EventBusSubscriber(modid="onekeyminer")
public class UnifiedChainHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        try {
            if (!ChainModeCapability.isChainModeActive(player)) {
                return;
            }
            if (CommonConfig.INSTANCE.requireSneaking.get() && !player.func_70093_af()) {
                return;
            }
            if (player.func_184812_l_() && !CommonConfig.INSTANCE.enableInCreative.get()) {
                return;
            }
            if (!UnifiedChainHandler.isToolItem(player.func_184586_b(event.getHand()))) {
                return;
            }
            ItemStack heldItem = player.func_184586_b(event.getHand());
            IBlockState targetState = event.getWorld().func_180495_p(event.getPos());
            try {
                UUID uuid = player.func_110124_au();
                String key = uuid.toString();
                if (InteractionHandler.isValidInteractionTool(heldItem)) {
                    ChainPositionStore.setInteractionPositions(key, new ArrayList<BlockPos>());
                } else if (UnifiedChainHandler.isPlantableItem(heldItem)) {
                    ChainPositionStore.setPlantingPositions(key, new ArrayList<BlockPos>());
                } else {
                    ChainPositionStore.setMiningPositions(key, new ArrayList<BlockPos>());
                }
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.debug("\u6e05\u7406\u8fde\u9501\u4f4d\u7f6e\u5b58\u50a8\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
            }
            if (InteractionHandler.isValidInteractionTool(heldItem)) {
                if (ClientConfig.INSTANCE.Debug.get()) {
                    Onekeyminer.LOGGER.debug("\u89e6\u53d1\u5de5\u5177\u8fde\u9501\u4ea4\u4e92: {}", (Object)heldItem.func_77973_b().getClass().getSimpleName());
                }
                InteractionHandler.tryChainInteraction(player, (WorldServer)event.getWorld(), event.getPos(), event.getFace(), event.getHitVec(), event.getHand());
            } else if (UnifiedChainHandler.isPlantableItem(heldItem)) {
                PlantingHandler.handleChainPlanting(player, event);
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u5904\u7406\u73a9\u5bb6\u4ea4\u4e92\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            Onekeyminer.LOGGER.debug("\u8be6\u7ec6\u9519\u8bef\u6808", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        try {
            EntitySheep sheep;
            if (!ChainModeCapability.isChainModeActive(player)) {
                return;
            }
            if (CommonConfig.INSTANCE.requireSneaking.get() && !player.func_70093_af()) {
                return;
            }
            if (player.func_184812_l_() && !CommonConfig.INSTANCE.enableInCreative.get()) {
                return;
            }
            ItemStack heldItem = player.func_184586_b(event.getHand());
            Entity targetEntity = event.getTarget();
            if (heldItem.func_77973_b() instanceof ItemShears && targetEntity instanceof EntitySheep && !(sheep = (EntitySheep)targetEntity).func_70892_o()) {
                if (ClientConfig.INSTANCE.Debug.get()) {
                    Onekeyminer.LOGGER.debug("\u68c0\u6d4b\u5230\u526a\u7f8a\u6bdb\u64cd\u4f5c");
                }
                player.func_184102_h().func_152344_a(() -> InteractionHandler.tryChainShearing(player, sheep, event.getHand()));
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u5904\u7406\u5b9e\u4f53\u4ea4\u4e92\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            Onekeyminer.LOGGER.debug("\u8be6\u7ec6\u9519\u8bef\u6808", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!(event.getPlayer() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getPlayer();
        try {
            if (!ChainModeCapability.isChainModeActive(player)) {
                return;
            }
            ItemStack tool = player.func_184586_b(EnumHand.MAIN_HAND);
            IBlockState state = event.getState();
            World level = player.field_70170_p;
            WorldServer serverLevel = (WorldServer)level;
            TileEntity blockEntity = level.func_175625_s(event.getPos());
            ChainHandler.tryChainMine(player, event.getPos(), state, tool);
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u5904\u7406\u65b9\u5757\u7834\u574f\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            Onekeyminer.LOGGER.debug("\u8be6\u7ec6\u9519\u8bef\u6808", (Throwable)e);
        }
    }

    public static boolean isToolItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item instanceof ItemShears || item instanceof ItemHoe || item instanceof ItemAxe || item instanceof ItemSpade || UnifiedChainHandler.isPlantableItem(stack);
    }

    public static boolean isPlantableItem(ItemStack stack) {
        return PlantingHandler.isPlantableItem(stack);
    }
}

