/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.config.ServerConfig;

public class ModCommands
extends CommandBase {
    public String func_71517_b() {
        return "excavation";
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.onekeyminer.help.title";
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String subCommand;
        if (args.length == 0) {
            this.showHelp(sender);
            return;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "help": {
                this.showHelp(sender);
                break;
            }
            case "status": {
                this.showStatus(sender);
                break;
            }
            case "common": 
            case "general": {
                if (!sender.func_70003_b(2, this.func_71517_b())) {
                    throw new CommandException("commands.generic.permission", new Object[0]);
                }
                this.handleCommonConfig(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "client": {
                this.handleClientConfig(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "server": {
                if (!sender.func_70003_b(4, this.func_71517_b())) {
                    throw new CommandException("commands.generic.permission", new Object[0]);
                }
                this.handleServerConfig(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            default: {
                this.showHelp(sender);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return ModCommands.func_71530_a((String[])args, (String[])new String[]{"help", "status", "common", "client", "server"});
        }
        if (args.length >= 2) {
            String subCommand;
            switch (subCommand = args[0].toLowerCase()) {
                case "common": 
                case "general": {
                    return this.getCommonConfigTabCompletion(args);
                }
                case "client": {
                    return this.getClientConfigTabCompletion(args);
                }
                case "server": {
                    return this.getServerConfigTabCompletion(args);
                }
            }
        }
        return Collections.emptyList();
    }

    private void showHelp(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.help.title", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.help.status", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.help.config", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.help.server", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.help.client", new Object[0]));
    }

    private void showStatus(ICommandSender sender) throws CommandException {
        EntityPlayerMP player = ModCommands.func_71521_c((ICommandSender)sender);
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.status.maxblocks", new Object[]{CommonConfig.INSTANCE.maxBlocksInChain.get()}));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.status.maxdepth", new Object[]{CommonConfig.INSTANCE.maxChainDepth.get()}));
        boolean diagonal = CommonConfig.INSTANCE.enableDiagonalChaining.get();
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.status.diagonal", new Object[]{new TextComponentTranslation(diagonal ? "command.onekeyminer.enabled" : "command.onekeyminer.disabled", new Object[0])}));
        boolean requireSneaking = CommonConfig.INSTANCE.requireSneaking.get();
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.status.sneaking", new Object[]{new TextComponentTranslation(requireSneaking ? "command.onekeyminer.required" : "command.onekeyminer.not_required", new Object[0])}));
    }

    private void handleCommonConfig(ICommandSender sender, String[] args) throws CommandException {
        String option;
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7e\u53ef\u7528\u9009\u9879: maxChainBlocks, maxChainDepth, maxBlocksInChain, maxBlocksInChainCreative, enableDiagonalChaining, teleportDropsToPlayer, ignoreToolCompatibility, matchIBlockState, matchseedIBlockState, enableInCreative, requireSneaking, nonChainableBlocks, seedBlacklist"));
            return;
        }
        switch (option = args[0].toLowerCase()) {
            case "maxchainblocks": {
                if (args.length == 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.value", new Object[]{"maxChainBlocks", CommonConfig.INSTANCE.maxChainBlocks.get()}));
                    break;
                }
                int value = ModCommands.func_175764_a((String)args[1], (int)1, (int)4096);
                CommonConfig.INSTANCE.maxChainBlocks.set(value);
                CommonConfig.save();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.set.int", new Object[]{"maxChainBlocks", value}));
                break;
            }
            case "maxchaindepth": {
                if (args.length == 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.value", new Object[]{"maxChainDepth", CommonConfig.INSTANCE.maxChainDepth.get()}));
                    break;
                }
                int value = ModCommands.func_175764_a((String)args[1], (int)1, (int)64);
                CommonConfig.INSTANCE.maxChainDepth.set(value);
                CommonConfig.save();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.set.int", new Object[]{"maxChainDepth", value}));
                break;
            }
            case "maxblocksinchain": {
                if (args.length == 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.value", new Object[]{"maxBlocksInChain", CommonConfig.INSTANCE.maxBlocksInChain.get()}));
                    break;
                }
                int value = ModCommands.func_175764_a((String)args[1], (int)1, (int)4096);
                CommonConfig.INSTANCE.maxBlocksInChain.set(value);
                CommonConfig.save();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.set.int", new Object[]{"maxBlocksInChain", value}));
                break;
            }
            case "maxblocksinchaincreative": {
                if (args.length == 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.value", new Object[]{"maxBlocksInChainCreative", CommonConfig.INSTANCE.maxBlocksInChainCreative.get()}));
                    break;
                }
                int value = ModCommands.func_175764_a((String)args[1], (int)1, (int)16384);
                CommonConfig.INSTANCE.maxBlocksInChainCreative.set(value);
                CommonConfig.save();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.set.int", new Object[]{"maxBlocksInChainCreative", value}));
                break;
            }
            case "enablediagonalchaining": {
                this.handleBooleanConfig(sender, args, "enableDiagonalChaining", CommonConfig.INSTANCE.enableDiagonalChaining);
                break;
            }
            case "teleportdropstoplayer": {
                this.handleBooleanConfig(sender, args, "teleportDropsToPlayer", CommonConfig.INSTANCE.teleportDropsToPlayer);
                break;
            }
            case "ignoretoolcompatibility": {
                this.handleBooleanConfig(sender, args, "ignoreToolCompatibility", CommonConfig.INSTANCE.ignoreToolCompatibility);
                break;
            }
            case "matchiblockstate": 
            case "matchblockstate": {
                this.handleBooleanConfig(sender, args, "matchIBlockState", CommonConfig.INSTANCE.matchIBlockState);
                break;
            }
            case "matchseediblockstate": {
                this.handleBooleanConfig(sender, args, "matchseedIBlockState", CommonConfig.INSTANCE.matchseedIBlockState);
                break;
            }
            case "enableincreative": {
                this.handleBooleanConfig(sender, args, "enableInCreative", CommonConfig.INSTANCE.enableInCreative);
                break;
            }
            case "requiresneaking": {
                this.handleBooleanConfig(sender, args, "requireSneaking", CommonConfig.INSTANCE.requireSneaking);
                break;
            }
            case "nonchainableblocks": {
                this.handleBlockBlacklist(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "seedblacklist": {
                this.handleSeedBlacklist(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            default: {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.invalid_option", new Object[0]));
            }
        }
    }

    private void handleBooleanConfig(ICommandSender sender, String[] args, String name, CommonConfig.BooleanValue configValue) throws CommandException {
        if (args.length == 1) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.value", new Object[]{name, configValue.get()}));
        } else {
            boolean value = ModCommands.func_180527_d((String)args[1]);
            configValue.set(value);
            CommonConfig.save();
            String status = value ? new TextComponentTranslation("command.onekeyminer.enabled", new Object[0]).func_150260_c() : new TextComponentTranslation("command.onekeyminer.disabled", new Object[0]).func_150260_c();
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.set.bool", new Object[]{name, status}));
        }
    }

    private void handleBlockBlacklist(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0 || args[0].equalsIgnoreCase("list")) {
            List<String> blocks = CommonConfig.INSTANCE.nonChainableBlocks.get();
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.blacklist.blocks.title", new Object[0]));
            if (blocks.isEmpty()) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.list.empty", new Object[0]));
            } else {
                for (String block : blocks) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.list.item", new Object[]{block}));
                }
            }
        } else if (args[0].equalsIgnoreCase("add") && args.length > 1) {
            ArrayList<String> blocks;
            String blockId = args[1];
            if (!blockId.contains(":")) {
                blockId = "minecraft:" + blockId;
            }
            if ((blocks = new ArrayList<String>((Collection)CommonConfig.INSTANCE.nonChainableBlocks.get())).contains(blockId)) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.blacklist.block.exists", new Object[]{blockId}));
            } else {
                blocks.add(blockId);
                CommonConfig.INSTANCE.nonChainableBlocks.set(blocks);
                CommonConfig.save();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.blacklist.block.added", new Object[]{blockId}));
            }
        } else if (args[0].equalsIgnoreCase("remove") && args.length > 1) {
            ArrayList blocks;
            String blockId = args[1];
            if (!blockId.contains(":")) {
                blockId = "minecraft:" + blockId;
            }
            if (!(blocks = new ArrayList(CommonConfig.INSTANCE.nonChainableBlocks.get())).contains(blockId)) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.blacklist.block.not_exists", new Object[]{blockId}));
            } else {
                blocks.remove(blockId);
                CommonConfig.INSTANCE.nonChainableBlocks.set(blocks);
                CommonConfig.save();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.blacklist.block.removed", new Object[]{blockId}));
            }
        }
    }

    private void handleSeedBlacklist(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0 || args[0].equalsIgnoreCase("list")) {
            List<String> seeds = CommonConfig.INSTANCE.seedBlacklist.get();
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.blacklist.seeds.title", new Object[0]));
            if (seeds.isEmpty()) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.list.empty", new Object[0]));
            } else {
                for (String seed : seeds) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.list.item", new Object[]{seed}));
                }
            }
        } else if (args[0].equalsIgnoreCase("add") && args.length > 1) {
            ArrayList<String> seeds;
            String seedId = args[1];
            if (!seedId.contains(":")) {
                seedId = "minecraft:" + seedId;
            }
            if ((seeds = new ArrayList<String>((Collection)CommonConfig.INSTANCE.seedBlacklist.get())).contains(seedId)) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.blacklist.seed.exists", new Object[]{seedId}));
            } else {
                seeds.add(seedId);
                CommonConfig.INSTANCE.seedBlacklist.set(seeds);
                CommonConfig.save();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.blacklist.seed.added", new Object[]{seedId}));
            }
        } else if (args[0].equalsIgnoreCase("remove") && args.length > 1) {
            ArrayList seeds;
            String seedId = args[1];
            if (!seedId.contains(":")) {
                seedId = "minecraft:" + seedId;
            }
            if (!(seeds = new ArrayList(CommonConfig.INSTANCE.seedBlacklist.get())).contains(seedId)) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.blacklist.seed.not_exists", new Object[]{seedId}));
            } else {
                seeds.remove(seedId);
                CommonConfig.INSTANCE.seedBlacklist.set(seeds);
                CommonConfig.save();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.blacklist.seed.removed", new Object[]{seedId}));
            }
        }
    }

    private void handleClientConfig(ICommandSender sender, String[] args) throws CommandException {
        String option;
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7e\u53ef\u7528\u9009\u9879: showBlockCount, messageStyle, requireKeyHold, Debug, frozentimer"));
            return;
        }
        switch (option = args[0].toLowerCase()) {
            case "showblockcount": {
                if (args.length == 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.value", new Object[]{"showBlockCount", ClientConfig.INSTANCE.showBlockCount.get()}));
                    break;
                }
                boolean value = ModCommands.func_180527_d((String)args[1]);
                ClientConfig.INSTANCE.showBlockCount.set(value);
                ClientConfig.save();
                String status = value ? new TextComponentTranslation("command.onekeyminer.enabled", new Object[0]).func_150260_c() : new TextComponentTranslation("command.onekeyminer.disabled", new Object[0]).func_150260_c();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.set.bool", new Object[]{"showBlockCount", status}));
                break;
            }
            case "messagestyle": {
                if (args.length == 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.value", new Object[]{"messageStyle", ClientConfig.INSTANCE.messageStyle.get()}));
                    break;
                }
                String style = args[1].toLowerCase();
                if (Arrays.asList("chat", "actionbar", "both", "none").contains(style)) {
                    ClientConfig.INSTANCE.messageStyle.set(style);
                    ClientConfig.save();
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.messagestyle.set", new Object[]{style}));
                    break;
                }
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.invalid_option", new Object[0]));
                break;
            }
            case "requirekeyhold": {
                if (args.length == 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.value", new Object[]{"requireKeyHold", ClientConfig.INSTANCE.requireKeyHold.get()}));
                    break;
                }
                boolean value = ModCommands.func_180527_d((String)args[1]);
                ClientConfig.INSTANCE.requireKeyHold.set(value);
                ClientConfig.save();
                String status = value ? new TextComponentTranslation("command.onekeyminer.enabled", new Object[0]).func_150260_c() : new TextComponentTranslation("command.onekeyminer.disabled", new Object[0]).func_150260_c();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.set.bool", new Object[]{"requireKeyHold", status}));
                break;
            }
            case "debug": {
                if (args.length == 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.value", new Object[]{"Debug", ClientConfig.INSTANCE.Debug.get()}));
                    break;
                }
                boolean value = ModCommands.func_180527_d((String)args[1]);
                ClientConfig.INSTANCE.Debug.set(value);
                ClientConfig.save();
                String status = value ? new TextComponentTranslation("command.onekeyminer.enabled", new Object[0]).func_150260_c() : new TextComponentTranslation("command.onekeyminer.disabled", new Object[0]).func_150260_c();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.set.bool", new Object[]{"Debug", status}));
                break;
            }
            case "frozentimer": {
                if (args.length == 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.value", new Object[]{"frozentimer", ClientConfig.INSTANCE.frozentimer.get()}));
                    break;
                }
                int value = ModCommands.func_175764_a((String)args[1], (int)1, (int)Short.MAX_VALUE);
                ClientConfig.INSTANCE.frozentimer.set(value);
                ClientConfig.save();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.set.int", new Object[]{"frozentimer", value}));
                break;
            }
            default: {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.invalid_option", new Object[0]));
            }
        }
    }

    private void handleServerConfig(ICommandSender sender, String[] args) throws CommandException {
        String option;
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7e\u53ef\u7528\u9009\u9879: toolProtectionEnabled, toolDurabilityThreshold, hungerProtectionEnabled, hungerThreshold"));
            return;
        }
        switch (option = args[0].toLowerCase()) {
            case "toolprotectionenabled": {
                if (args.length == 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.value", new Object[]{"toolProtectionEnabled", ServerConfig.INSTANCE.toolProtectionEnabled.get()}));
                    break;
                }
                boolean value = ModCommands.func_180527_d((String)args[1]);
                ServerConfig.INSTANCE.toolProtectionEnabled.set(value);
                ServerConfig.save();
                String status = value ? new TextComponentTranslation("command.onekeyminer.enabled", new Object[0]).func_150260_c() : new TextComponentTranslation("command.onekeyminer.disabled", new Object[0]).func_150260_c();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.set.bool", new Object[]{"toolProtectionEnabled", status}));
                break;
            }
            case "tooldurability": 
            case "tooldur\u0430\u0431\u0438\u043b\u0438\u0442ythreshold": {
                if (args.length == 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.value", new Object[]{"toolDurabilityThreshold", ServerConfig.INSTANCE.toolDurabilityThreshold.get()}));
                    break;
                }
                double value = ModCommands.func_175756_a((String)args[1], (double)0.0, (double)1000.0);
                ServerConfig.INSTANCE.toolDurabilityThreshold.set(value);
                ServerConfig.save();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.tool_durability.set", new Object[]{value}));
                break;
            }
            case "hungerprotectionenabled": {
                if (args.length == 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.value", new Object[]{"hungerProtectionEnabled", ServerConfig.INSTANCE.hungerProtectionEnabled.get()}));
                    break;
                }
                boolean value = ModCommands.func_180527_d((String)args[1]);
                ServerConfig.INSTANCE.hungerProtectionEnabled.set(value);
                ServerConfig.save();
                String status = value ? new TextComponentTranslation("command.onekeyminer.enabled", new Object[0]).func_150260_c() : new TextComponentTranslation("command.onekeyminer.disabled", new Object[0]).func_150260_c();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.set.bool", new Object[]{"hungerProtectionEnabled", status}));
                break;
            }
            case "hunger": 
            case "hungerthreshold": {
                if (args.length == 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.value", new Object[]{"hungerThreshold", ServerConfig.INSTANCE.hungerThreshold.get()}));
                    break;
                }
                double value = ModCommands.func_175756_a((String)args[1], (double)0.0, (double)20.0);
                ServerConfig.INSTANCE.hungerThreshold.set(value);
                ServerConfig.save();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.config.hunger.set", new Object[]{value}));
                break;
            }
            default: {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.onekeyminer.invalid_option", new Object[0]));
            }
        }
    }

    private List<String> getCommonConfigTabCompletion(String[] args) {
        if (args.length == 2) {
            return ModCommands.func_71530_a((String[])args, (String[])new String[]{"maxChainBlocks", "maxChainDepth", "maxBlocksInChain", "maxBlocksInChainCreative", "enableDiagonalChaining", "teleportDropsToPlayer", "ignoreToolCompatibility", "matchIBlockState", "matchseedIBlockState", "enableInCreative", "requireSneaking", "nonChainableBlocks", "seedBlacklist"});
        }
        if (args.length == 3) {
            String option = args[1].toLowerCase();
            if (option.equals("nonchainableblocks") || option.equals("seedblacklist")) {
                return ModCommands.func_71530_a((String[])args, (String[])new String[]{"list", "add", "remove"});
            }
            if (option.startsWith("enable") || option.startsWith("ignore") || option.startsWith("match") || option.startsWith("require") || option.equals("teleportdropstoplayer")) {
                return ModCommands.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
            }
        }
        return Collections.emptyList();
    }

    private List<String> getClientConfigTabCompletion(String[] args) {
        if (args.length == 2) {
            return ModCommands.func_71530_a((String[])args, (String[])new String[]{"showBlockCount", "messageStyle", "requireKeyHold", "Debug", "frozentimer"});
        }
        if (args.length == 3) {
            String option = args[1].toLowerCase();
            if (option.equals("messagestyle")) {
                return ModCommands.func_71530_a((String[])args, (String[])new String[]{"chat", "actionbar", "both", "none"});
            }
            if (option.equals("showblockcount") || option.equals("requirekeyhold") || option.equals("debug")) {
                return ModCommands.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
            }
        }
        return Collections.emptyList();
    }

    private List<String> getServerConfigTabCompletion(String[] args) {
        String option;
        if (args.length == 2) {
            return ModCommands.func_71530_a((String[])args, (String[])new String[]{"toolProtectionEnabled", "toolDurabilityThreshold", "hungerProtectionEnabled", "hungerThreshold"});
        }
        if (args.length == 3 && ((option = args[1].toLowerCase()).equals("toolprotectionenabled") || option.equals("hungerprotectionenabled"))) {
            return ModCommands.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
        }
        return Collections.emptyList();
    }
}

