/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.config;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;

public class CommonConfig {
    public static final CommonConfig INSTANCE = new CommonConfig();
    public static final Object SPEC = null;
    private static Configuration config;
    public final ConfigValue<List<String>> chainPlantableFarmlands = new ConfigValue();
    public final IntValue maxChainBlocks = new IntValue();
    public final ConfigValue<List<String>> nonChainableBlocks = new ConfigValue();
    public final ConfigValue<List<String>> seedBlacklist = new ConfigValue();
    public final BooleanValue enableDiagonalChaining = new BooleanValue();
    public final IntValue maxMiningDepth = new IntValue();
    public final BooleanValue teleportDropsToPlayer = new BooleanValue();
    public final BooleanValue ignoreToolCompatibility = new BooleanValue();
    public final BooleanValue matchIBlockState = new BooleanValue();
    public final BooleanValue matchseedIBlockState = new BooleanValue();
    public final BooleanValue enableInCreative = new BooleanValue();
    public final BooleanValue requireSneaking = new BooleanValue();
    public final IntValue maxBlocksInChain = new IntValue();
    public final IntValue maxBlocksInChainCreative = new IntValue();
    public final IntValue maxChainDepth = new IntValue();
    public final BooleanValue enableDebugMode = new BooleanValue();

    public static void init(File configFile) {
        config = new Configuration(configFile);
        config.load();
        String category = "general";
        CommonConfig.INSTANCE.maxChainBlocks.value = CommonConfig.config.getInt("maxChainBlocks", category, 64, 1, 4096, "\u8fde\u9501\u64cd\u4f5c\u7684\u6700\u5927\u65b9\u5757\u6570||Maximum number of blocks for chain operations");
        String[] defaultBlacklist = new String[]{"minecraft:bedrock"};
        ((ConfigValue)CommonConfig.INSTANCE.nonChainableBlocks).value = Arrays.asList(CommonConfig.config.getStringList("nonChainableBlocks", category, defaultBlacklist, "\u4e0d\u5141\u8bb8\u8fde\u9501\u6316\u6398\u7684\u65b9\u5757\u9ed1\u540d\u5355||Blocks that should not be chain mined"));
        String[] defaultSeedBlacklist = new String[]{};
        ((ConfigValue)CommonConfig.INSTANCE.seedBlacklist).value = Arrays.asList(CommonConfig.config.getStringList("seedBlacklist", category, defaultSeedBlacklist, "\u4e0d\u5141\u8bb8\u8fde\u9501\u79cd\u690d\u7684\u79cd\u5b50\u9ed1\u540d\u5355||Seeds that should not be chain planted"));
        String[] defaultFarmlands = new String[]{"minecraft:farmland"};
        ((ConfigValue)CommonConfig.INSTANCE.chainPlantableFarmlands).value = Arrays.asList(CommonConfig.config.getStringList("chainPlantableFarmlands", category, defaultFarmlands, "\u5141\u8bb8\u8fde\u9501\u79cd\u690d\u7684\u8015\u5730\u767d\u540d\u5355"));
        CommonConfig.INSTANCE.enableDiagonalChaining.value = CommonConfig.config.getBoolean("enableDiagonalChaining", category, false, "\u662f\u5426\u5141\u8bb8\u5bf9\u89d2\u7ebf\u8fde\u9501");
        CommonConfig.INSTANCE.maxMiningDepth.value = CommonConfig.config.getInt("maxMiningDepth", category, 16, 1, 64, "\u6700\u5927\u6316\u6398\u6df1\u5ea6");
        CommonConfig.INSTANCE.teleportDropsToPlayer.value = CommonConfig.config.getBoolean("teleportDropsToPlayer", category, false, "\u662f\u5426\u5c06\u8fde\u9501\u6316\u6398\u7684\u6389\u843d\u7269\u4f20\u9001\u5230\u73a9\u5bb6\u8eab\u4e0b");
        CommonConfig.INSTANCE.ignoreToolCompatibility.value = CommonConfig.config.getBoolean("ignoreToolCompatibility", category, true, "\u662f\u5426\u5ffd\u7565\u5de5\u5177\u517c\u5bb9\u6027\u68c0\u67e5");
        CommonConfig.INSTANCE.matchIBlockState.value = CommonConfig.config.getBoolean("matchIBlockState", category, false, "\u662f\u5426\u5339\u914d\u5b8c\u6574\u7684\u65b9\u5757\u72b6\u6001");
        CommonConfig.INSTANCE.matchseedIBlockState.value = CommonConfig.config.getBoolean("matchseedIBlockState", category, false, "\u662f\u5426\u5339\u914d\u5b8c\u6574\u7684\u79cd\u5b50\u65b9\u5757\u72b6\u6001");
        CommonConfig.INSTANCE.enableInCreative.value = CommonConfig.config.getBoolean("enableInCreative", category, true, "\u521b\u9020\u6a21\u5f0f\u662f\u5426\u542f\u7528\u8fde\u9501\u6316\u6398");
        CommonConfig.INSTANCE.requireSneaking.value = CommonConfig.config.getBoolean("requireSneaking", category, false, "\u662f\u5426\u9700\u8981\u4e0b\u8e72\u624d\u80fd\u89e6\u53d1\u8fde\u9501\u6316\u6398");
        CommonConfig.INSTANCE.maxBlocksInChain.value = CommonConfig.config.getInt("maxBlocksInChain", category, 64, 1, 4096, "\u5b58\u6d3b\u6a21\u5f0f\u4e0b\u8fde\u9501\u6316\u6398\u7684\u6700\u5927\u65b9\u5757\u6570");
        CommonConfig.INSTANCE.maxBlocksInChainCreative.value = CommonConfig.config.getInt("maxBlocksInChainCreative", category, 256, 1, 16384, "\u521b\u9020\u6a21\u5f0f\u4e0b\u8fde\u9501\u6316\u6398\u7684\u6700\u5927\u65b9\u5757\u6570");
        CommonConfig.INSTANCE.maxChainDepth.value = CommonConfig.config.getInt("maxChainDepth", category, 16, 1, 64, "\u6700\u5927\u8fde\u9501\u641c\u7d22\u6df1\u5ea6");
        CommonConfig.INSTANCE.enableDebugMode.value = CommonConfig.config.getBoolean("enableDebugMode", category, false, "\u542f\u7528\u8c03\u8bd5\u6a21\u5f0f");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void save() {
        if (config != null && config.hasChanged()) {
            config.save();
        }
    }

    public boolean isBlockMineable(Block block) {
        ResourceLocation blockId = block.getRegistryName();
        for (String entry : this.nonChainableBlocks.get()) {
            ResourceLocation tagId;
            if (entry == null || !(entry.startsWith("#") ? (tagId = new ResourceLocation(entry.substring(1))) != null && blockId != null && blockId.toString().equals(tagId.toString()) : blockId != null && blockId.toString().equals(entry))) continue;
            return false;
        }
        return true;
    }

    public boolean isSeedBlacklisted(Item item) {
        ResourceLocation itemId = item.getRegistryName();
        for (String entry : this.seedBlacklist.get()) {
            ResourceLocation tagId;
            if (entry == null || !(entry.startsWith("#") ? (tagId = new ResourceLocation(entry.substring(1))) != null && itemId != null && itemId.toString().equals(tagId.toString()) : itemId != null && itemId.toString().equals(entry))) continue;
            return true;
        }
        return false;
    }

    public boolean isFarmlandAllowedForChainPlanting(IBlockState farmlandState) {
        if (farmlandState == null) {
            return false;
        }
        Block farmlandBlock = farmlandState.func_177230_c();
        ResourceLocation farmlandId = farmlandBlock.getRegistryName();
        for (String entry : this.chainPlantableFarmlands.get()) {
            ResourceLocation tagId;
            if (entry == null || entry.trim().isEmpty() || !(entry.startsWith("#") ? (tagId = new ResourceLocation(entry.substring(1))) != null && farmlandId != null && farmlandId.toString().equals(tagId.toString()) : farmlandId.toString().equals(entry.trim()))) continue;
            return true;
        }
        return false;
    }

    public static Configuration getConfig() {
        return config;
    }

    public static class ConfigValue<T> {
        private T value;

        public T get() {
            return this.value;
        }

        public void set(T value) {
            this.value = value;
        }
    }

    public static class IntValue {
        private int value;

        public int get() {
            return this.value;
        }

        public void set(int value) {
            this.value = value;
        }
    }

    public static class BooleanValue {
        private boolean value;

        public boolean get() {
            return this.value;
        }

        public void set(boolean value) {
            this.value = value;
        }
    }
}

