/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.xiyu.yee.onekeyminer.client.ClientUtils;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class BlocksMinedPacket
implements IOneKeyPacket,
IMessage {
    private int blockCount;

    public BlocksMinedPacket() {
    }

    public BlocksMinedPacket(int blockCount) {
        this.blockCount = blockCount;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public void fromBytes(ByteBuf buf) {
        this.blockCount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.blockCount);
    }

    @Override
    public void write(ByteBuf buf) {
        this.toBytes(buf);
    }

    @Override
    public ResourceLocation id() {
        return NetworkHandler.BLOCKS_MINED_ID;
    }

    @Override
    public Object type() {
        return NetworkHandler.BLOCKS_MINED_TYPE;
    }

    public static class Handler
    implements IMessageHandler<BlocksMinedPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(BlocksMinedPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                Minecraft minecraft = Minecraft.func_71410_x();
                if (minecraft.field_71439_g != null && ClientConfig.INSTANCE.showBlockCount.get()) {
                    ClientUtils.showBlockCountMessage(message.blockCount);
                }
            });
            return null;
        }
    }
}

