/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.client.ClientPacketHandler;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ChainActionPacket
implements IOneKeyPacket,
IMessage {
    private String actionType;
    private int count;

    public ChainActionPacket() {
    }

    public ChainActionPacket(String actionType, int count) {
        this.actionType = actionType;
        this.count = count;
    }

    public String getActionType() {
        return this.actionType;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public ResourceLocation id() {
        return NetworkHandler.CHAIN_ACTION_ID;
    }

    public void fromBytes(ByteBuf buf) {
        this.actionType = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.count = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.actionType);
        buf.writeInt(this.count);
    }

    @Override
    public void write(ByteBuf buffer) {
        this.toBytes(buffer);
    }

    public static class Handler
    implements IMessageHandler<ChainActionPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(ChainActionPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                try {
                    if (ClientConfig.INSTANCE.Debug.get()) {
                        Onekeyminer.LOGGER.debug("ChainActionPacket.handleOnClient \u88ab\u8c03\u7528");
                    }
                    ClientPacketHandler.handleChainActionPacket(message);
                }
                catch (Exception e) {
                    Onekeyminer.LOGGER.error("\u5904\u7406\u8fde\u9501\u6d88\u606f\u6570\u636e\u5305\u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
                }
            });
            return null;
        }
    }
}

