/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.api.ChainAPI;
import org.xiyu.yee.onekeyminer.api.ChainPositionStore;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.network.ChainPositionsPacket;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ChainModePacket
implements IOneKeyPacket,
IMessage {
    private boolean active;

    public ChainModePacket() {
    }

    public ChainModePacket(boolean active) {
        this.active = active;
    }

    public void fromBytes(ByteBuf buf) {
        this.active = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.active);
    }

    @Override
    public void write(ByteBuf buf) {
        this.toBytes(buf);
    }

    @Override
    public ResourceLocation id() {
        return NetworkHandler.CHAIN_MODE_ID;
    }

    @Override
    public Object type() {
        return NetworkHandler.CHAIN_MODE_TYPE;
    }

    public static class Handler
    implements IMessageHandler<ChainModePacket, IMessage> {
        public IMessage onMessage(ChainModePacket message, MessageContext ctx) {
            EntityPlayerMP serverPlayer = ctx.getServerHandler().field_147369_b;
            serverPlayer.func_71121_q().func_152344_a(() -> {
                ChainModeCapability.setChainMode(serverPlayer, message.active);
                try {
                    String key = serverPlayer.func_110124_au().toString();
                    if (message.active) {
                        RayTraceResult hr = serverPlayer.func_174822_a(6.0, 0.0f);
                        if (hr != null && hr.field_72313_a == RayTraceResult.Type.BLOCK) {
                            BlockPos pos = hr.func_178782_a();
                            IBlockState state = serverPlayer.field_70170_p.func_180495_p(pos);
                            ItemStack held = serverPlayer.func_184586_b(EnumHand.MAIN_HAND);
                            List<BlockPos> mining = ChainAPI.computeMiningPositions(serverPlayer, (WorldServer)serverPlayer.field_70170_p, pos, state, held);
                            ChainPositionStore.setMiningPositions(key, mining);
                            List<BlockPos> interaction = ChainAPI.computeInteractionPositions(serverPlayer, (WorldServer)serverPlayer.field_70170_p, pos, state, EnumHand.MAIN_HAND);
                            ChainPositionStore.setInteractionPositions(key, interaction);
                            List<BlockPos> planting = ChainAPI.computePlantingPositions(serverPlayer, (WorldServer)serverPlayer.field_70170_p, pos, state, held);
                            ChainPositionStore.setPlantingPositions(key, planting);
                            ChainPositionsPacket sync = new ChainPositionsPacket(key, true, mining, interaction, planting);
                            NetworkHandler.sendToPlayer(sync, serverPlayer);
                        }
                    } else {
                        ChainPositionStore.clearAll(key);
                        ChainPositionsPacket sync = new ChainPositionsPacket(key, false, null, null, null);
                        NetworkHandler.sendToPlayer(sync, serverPlayer);
                    }
                }
                catch (Exception e) {
                    Onekeyminer.LOGGER.error("\u5904\u7406 ChainModePacket \u65f6\u8ba1\u7b97 positions \u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
                }
            });
            return null;
        }
    }
}

