/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.api.ChainPositionStore;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ChainPositionsPacket
implements IOneKeyPacket,
IMessage {
    private String playerUuid;
    private boolean active;
    private List<BlockPos> mining;
    private List<BlockPos> interaction;
    private List<BlockPos> planting;

    public ChainPositionsPacket() {
    }

    public ChainPositionsPacket(String playerUuid, boolean active, List<BlockPos> mining, List<BlockPos> interaction, List<BlockPos> planting) {
        this.playerUuid = playerUuid;
        this.active = active;
        this.mining = mining == null ? new ArrayList() : mining;
        this.interaction = interaction == null ? new ArrayList() : interaction;
        this.planting = planting == null ? new ArrayList() : planting;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerUuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.active = buf.readBoolean();
        int m = buf.readInt();
        this.mining = new ArrayList<BlockPos>();
        for (int i = 0; i < m; ++i) {
            this.mining.add(new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
        }
        int it = buf.readInt();
        this.interaction = new ArrayList<BlockPos>();
        for (int i = 0; i < it; ++i) {
            this.interaction.add(new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
        }
        int p = buf.readInt();
        this.planting = new ArrayList<BlockPos>();
        for (int i = 0; i < p; ++i) {
            this.planting.add(new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUuid);
        buf.writeBoolean(this.active);
        buf.writeInt(this.mining.size());
        for (BlockPos b : this.mining) {
            buf.writeInt(b.func_177958_n());
            buf.writeInt(b.func_177956_o());
            buf.writeInt(b.func_177952_p());
        }
        buf.writeInt(this.interaction.size());
        for (BlockPos b : this.interaction) {
            buf.writeInt(b.func_177958_n());
            buf.writeInt(b.func_177956_o());
            buf.writeInt(b.func_177952_p());
        }
        buf.writeInt(this.planting.size());
        for (BlockPos b : this.planting) {
            buf.writeInt(b.func_177958_n());
            buf.writeInt(b.func_177956_o());
            buf.writeInt(b.func_177952_p());
        }
    }

    @Override
    public void write(ByteBuf buf) {
        this.toBytes(buf);
    }

    @Override
    public ResourceLocation id() {
        return NetworkHandler.CHAIN_POSITIONS_ID;
    }

    @Override
    public Object type() {
        return NetworkHandler.CHAIN_POSITIONS_TYPE;
    }

    public static class Handler
    implements IMessageHandler<ChainPositionsPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(ChainPositionsPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                try {
                    ChainPositionStore.setChainMode(message.playerUuid, message.active);
                    ChainPositionStore.setMiningPositions(message.playerUuid, message.mining);
                    ChainPositionStore.setInteractionPositions(message.playerUuid, message.interaction);
                    ChainPositionStore.setPlantingPositions(message.playerUuid, message.planting);
                }
                catch (Exception e) {
                    Onekeyminer.LOGGER.error("\u5904\u7406 ChainPositionsPacket \u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
                }
            });
            return null;
        }
    }
}

