/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ConfigSyncPacket
implements IOneKeyPacket,
IMessage {
    private String configKey;
    private String configValue;

    public ConfigSyncPacket() {
    }

    public ConfigSyncPacket(String configKey, String configValue) {
        this.configKey = configKey;
        this.configValue = configValue;
    }

    @Override
    public ResourceLocation id() {
        return NetworkHandler.CONFIG_SYNC_ID;
    }

    @Override
    public Object type() {
        return NetworkHandler.CONFIG_SYNC_TYPE;
    }

    public void fromBytes(ByteBuf buf) {
        this.configKey = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.configValue = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.configKey);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.configValue);
    }

    @Override
    public void write(ByteBuf buffer) {
        this.toBytes(buffer);
    }

    public static class Handler
    implements IMessageHandler<ConfigSyncPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(ConfigSyncPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                String key = message.configKey;
                String value = message.configValue;
                switch (key) {
                    case "keyhold": {
                        ClientConfig.INSTANCE.requireKeyHold.set(Boolean.parseBoolean(value));
                        break;
                    }
                    case "showcount": {
                        ClientConfig.INSTANCE.showBlockCount.set(Boolean.parseBoolean(value));
                        break;
                    }
                    case "messagestyle": {
                        ClientConfig.INSTANCE.messageStyle.set(value);
                        break;
                    }
                    default: {
                        Onekeyminer.LOGGER.warn("\u6536\u5230\u672a\u77e5\u914d\u7f6e\u952e: {}", (Object)key);
                    }
                }
                Onekeyminer.LOGGER.debug("\u5ba2\u6237\u7aef\u914d\u7f6e\u5df2\u66f4\u65b0: {} = {}", (Object)key, (Object)value);
            });
            return null;
        }
    }
}

