/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.network.BlocksMinedPacket;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.ChainModePacket;
import org.xiyu.yee.onekeyminer.network.ChainPositionsPacket;
import org.xiyu.yee.onekeyminer.network.ConfigSyncPacket;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;

public class NetworkHandler {
    public static final ResourceLocation CHAIN_MODE_ID = new ResourceLocation("onekeyminer", "chain_mode");
    public static final ResourceLocation BLOCKS_MINED_ID = new ResourceLocation("onekeyminer", "blocks_mined");
    public static final ResourceLocation CHAIN_ACTION_ID = new ResourceLocation("onekeyminer", "chain_action");
    public static final ResourceLocation CONFIG_SYNC_ID = new ResourceLocation("onekeyminer", "config_sync");
    public static final ResourceLocation CHAIN_POSITIONS_ID = new ResourceLocation("onekeyminer", "chain_positions");
    public static final Object CHAIN_MODE_TYPE = CHAIN_MODE_ID;
    public static final Object BLOCKS_MINED_TYPE = BLOCKS_MINED_ID;
    public static final Object CHAIN_ACTION_TYPE = CHAIN_ACTION_ID;
    public static final Object CONFIG_SYNC_TYPE = CONFIG_SYNC_ID;
    public static final Object CHAIN_POSITIONS_TYPE = CHAIN_POSITIONS_ID;
    private static final String PROTOCOL_VERSION = "1.0.0";
    public static SimpleNetworkWrapper CHANNEL = null;
    private static int packetIndex = 0;
    private static boolean registered = false;

    public static void registerPayloads(FMLPreInitializationEvent event) {
        if (registered) {
            return;
        }
        registered = true;
        if (CHANNEL == null) {
            try {
                if (NetworkRegistry.INSTANCE == null) {
                    Onekeyminer.LOGGER.error("NetworkRegistry.INSTANCE is null during registerPayloads - stack:\n", (Throwable)new RuntimeException("NetworkRegistry.INSTANCE is null"));
                }
                CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("onekeyminer");
            }
            catch (Throwable t) {
                Onekeyminer.LOGGER.error("Failed to create SimpleNetworkWrapper channel for {}: {}", (Object)"onekeyminer", (Object)t.getMessage(), (Object)t);
                throw t;
            }
        }
        CHANNEL.registerMessage(ChainModePacket.Handler.class, ChainModePacket.class, packetIndex++, Side.SERVER);
        CHANNEL.registerMessage(BlocksMinedPacket.Handler.class, BlocksMinedPacket.class, packetIndex++, Side.CLIENT);
        CHANNEL.registerMessage(ChainActionPacket.Handler.class, ChainActionPacket.class, packetIndex++, Side.CLIENT);
        CHANNEL.registerMessage(ConfigSyncPacket.Handler.class, ConfigSyncPacket.class, packetIndex++, Side.CLIENT);
        CHANNEL.registerMessage(ChainPositionsPacket.Handler.class, ChainPositionsPacket.class, packetIndex++, Side.CLIENT);
    }

    public static void sendToPlayer(IOneKeyPacket packet, EntityPlayerMP player) {
        try {
            if (player != null && packet instanceof IMessage) {
                CHANNEL.sendTo((IMessage)packet, player);
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u53d1\u9001\u6570\u636e\u5305\u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void sendToServer(IOneKeyPacket packet) {
        if (packet instanceof IMessage) {
            CHANNEL.sendToServer((IMessage)packet);
        }
    }
}

