/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer;

import cn.onekeyminer.OneKeyMiner;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ExcavatePacket {
    private final boolean pressed;
    private final boolean isPlanting;
    private final boolean ignoredIsEmptyHanded;

    public ExcavatePacket(boolean pressed, boolean isPlanting, boolean ignoredIsEmptyHanded) {
        this.pressed = pressed;
        this.isPlanting = isPlanting;
        this.ignoredIsEmptyHanded = ignoredIsEmptyHanded;
    }

    public static ExcavatePacket decode(FriendlyByteBuf buf) {
        boolean pressed = buf.readBoolean();
        boolean isPlanting = buf.readBoolean();
        boolean ignoredIsEmptyHanded = buf.readBoolean();
        return new ExcavatePacket(pressed, isPlanting, ignoredIsEmptyHanded);
    }

    public static void handle(ExcavatePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player;
            if (context.getDirection().getReceptionSide().isServer() && (player = context.getSender()) != null) {
                OneKeyMiner.keyPressed(player, packet.isPressed(), packet.isPlanting(), packet.ignoredIsEmptyHanded());
            }
            context.setPacketHandled(true);
        });
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.pressed);
        buf.writeBoolean(this.isPlanting);
        buf.writeBoolean(this.ignoredIsEmptyHanded);
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public boolean isPlanting() {
        return this.isPlanting;
    }

    public boolean ignoredIsEmptyHanded() {
        return this.ignoredIsEmptyHanded;
    }
}

