/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer;

import cn.onekeyminer.OKMConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;

public class DirectionalExcavationUtils {
    public static void excavateInDirection(Level world, ServerPlayer player, BlockState targetBlock) {
        boolean shouldDamage;
        ItemStack mainHandItem = player.getMainHandItem();
        if (!ForgeHooks.isCorrectToolForDrops((BlockState)targetBlock, (Player)player)) {
            return;
        }
        Vec3 lookVec = player.getLookAngle();
        int dirX = lookVec.x > 0.0 ? 1 : -1;
        int dirZ = lookVec.z > 0.0 ? 1 : -1;
        ArrayList lootDrops = new ArrayList();
        int totalExpDrop = 0;
        LegacyRandomSource random = (LegacyRandomSource)world.getRandom();
        int length = (Integer)OKMConfig.max_range.get();
        int height = 2;
        for (int i = 0; i < length; ++i) {
            BlockPos pos = player.blockPosition().offset(dirX, 0, dirZ).offset(0, height / 2, 0).offset(i * dirX, 0, i * dirZ);
            BlockState blockState = world.getBlockState(pos);
            if (!blockState.is(targetBlock.getBlock())) continue;
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            Block block = blockState.getBlock();
            BlockEntity blockEntity = world.getBlockEntity(pos);
            int silkTouchLevel = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.SILK_TOUCH, (ItemStack)player.getMainHandItem());
            int fortuneLevel = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.FORTUNE, (ItemStack)mainHandItem);
            List drops = Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)blockEntity);
            lootDrops.addAll(drops);
            int expToDrop = block.getExpDrop(blockState, (LevelReader)world, (RandomSource)random, pos, fortuneLevel, silkTouchLevel);
            totalExpDrop += expToDrop;
        }
        double dropX = player.getX();
        double dropY = player.getEyeY() - (double)player.getEyeHeight() - 0.5;
        double dropZ = player.getZ();
        for (ItemStack drop : lootDrops) {
            ItemEntity itemEntity = new ItemEntity(world, dropX, dropY, dropZ, drop);
            world.addFreshEntity((Entity)itemEntity);
        }
        if (totalExpDrop > 0) {
            world.addFreshEntity((Entity)new ExperienceOrb(world, dropX, dropY, dropZ, totalExpDrop));
        }
        mainHandItem = player.getMainHandItem();
        if (((Boolean)OKMConfig.toolProtectionMode.get()).booleanValue() && !player.isCreative() && mainHandItem.isDamageableItem()) {
            double threshold = (Double)OKMConfig.toolDurabilityThreshold.get();
            int maxDamage = mainHandItem.getMaxDamage();
            int damage = mainHandItem.getDamageValue();
            double d = maxDamage - damage;
            double d2 = threshold <= 1.0 ? (double)maxDamage * threshold : threshold;
            if (d < d2) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.onekeyminer.low_durability"));
                return;
            }
        }
        if (!player.isCreative() && mainHandItem.isDamageableItem() && (shouldDamage = true)) {
            mainHandItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
        }
    }
}

