/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer;

import cn.onekeyminer.BlockDetectionMode;
import cn.onekeyminer.Direction26;
import cn.onekeyminer.OKMConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Direction8;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;

public class OKMUtils {
    public static void chainMine(ServerLevel world, ServerPlayer player, BlockPos pos, BlockState state) {
        int count = OKMUtils.startChainMine(world, player, pos, state);
        int statValue = player.getStats().getValue(Stats.BLOCK_MINED.get((Object)state.getBlock()));
        player.getStats().setValue((Player)player, Stats.BLOCK_MINED.get((Object)state.getBlock()), statValue + count);
        player.sendSystemMessage((Component)Component.literal((String)("\u8fde\u9501\u6316\u6398\u4e86" + count + "\u4e2a\u65b9\u5757")));
    }

    public static int startChainMine(ServerLevel world, ServerPlayer player, BlockPos pos, BlockState state) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int expTotal = 0;
        ItemStack mainHandItem = player.getMainHandItem();
        int maxCount = Math.min(Math.max(mainHandItem.getMaxDamage() - mainHandItem.getDamageValue() - 5, 1), (Integer)OKMConfig.max_count.get());
        List blocks = OKMUtils.getConnectedBlocksByRadioLevelOrder((Level)world, pos, (Integer)OKMConfig.max_range.get(), blockState -> blockState.is(state.getBlock()) && ForgeHooks.isCorrectToolForDrops((BlockState)blockState, (Player)player)).stream().limit(maxCount).collect(Collectors.toList());
        int blocksMined = 0;
        for (BlockPos blockPos : blocks) {
            if (!player.isCreative() && mainHandItem.isDamageableItem()) {
                int maxDamage = mainHandItem.getMaxDamage();
                int damage = mainHandItem.getDamageValue();
                if (((Boolean)OKMConfig.toolProtectionMode.get()).booleanValue()) {
                    double d = maxDamage - damage;
                    double d2 = (Double)OKMConfig.toolDurabilityThreshold.get() <= 1.0 ? (double)maxDamage * (Double)OKMConfig.toolDurabilityThreshold.get() : (Double)OKMConfig.toolDurabilityThreshold.get();
                    if (d < d2) {
                        player.sendSystemMessage((Component)Component.translatable((String)"message.onekeyminer.low_durability"));
                        return blocksMined;
                    }
                }
                mainHandItem.setDamageValue(damage + 1);
                if (mainHandItem.getDamageValue() >= maxDamage) {
                    mainHandItem.setDamageValue(0);
                    player.broadcastToPlayer(player);
                    return blocksMined;
                }
            }
            BlockState blockState2 = world.getBlockState(blockPos);
            List singleBlockDrops = blockState2.getDrops(new LootParams.Builder(world).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)blockPos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)world.getBlockEntity(blockPos)));
            for (ItemStack singleBlockDrop : singleBlockDrops) {
                OKMUtils.addItemStack(drops, singleBlockDrop);
            }
            int silkTouchLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)Enchantments.SILK_TOUCH), (ItemStack)mainHandItem);
            int fortuneLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)Enchantments.FORTUNE), (ItemStack)mainHandItem);
            expTotal += blockState2.getExpDrop((LevelReader)world, world.random, blockPos, silkTouchLevel, fortuneLevel);
            world.removeBlock(blockPos, false);
            ++blocksMined;
        }
        drops.forEach(stack -> world.addFreshEntity((Entity)new ItemEntity((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack)));
        if (expTotal > 0) {
            world.addFreshEntity((Entity)new ExperienceOrb((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), expTotal));
        }
        return blocksMined;
    }

    public static LinkedHashSet<BlockPos> getConnectedBlocksByRadioLevelOrder(Level level, BlockPos center, int radius, Predicate<BlockState> blockStatePredicate) {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayList<BlockPos> visitedPositions = new ArrayList<BlockPos>();
        queue.add(center);
        visited.add(center);
        visitedPositions.add(center);
        while (!queue.isEmpty()) {
            BlockPos current = (BlockPos)queue.poll();
            List<BlockPos> neighbors = OKMUtils.getBlockPoses(current, level, blockStatePredicate);
            for (BlockPos neighbor : neighbors) {
                if (visited.contains(neighbor) || !OKMUtils.isWithinRadius(neighbor, center, radius)) continue;
                queue.add(neighbor);
                visited.add(neighbor);
                visitedPositions.add(neighbor);
            }
        }
        return new LinkedHashSet<BlockPos>(visitedPositions);
    }

    private static List<BlockPos> getBlockPoses(BlockPos center, Level level, Predicate<BlockState> blockStatePredicate) {
        return switch ((BlockDetectionMode)((Object)OKMConfig.block_detection_mode.get())) {
            case BlockDetectionMode.DIRECTIONS_8 -> OKMUtils.get2DAroundBlockPoses(center, level, blockStatePredicate);
            case BlockDetectionMode.DIRECTIONS_26 -> OKMUtils.get3DAroundBlockPoses(center, level, blockStatePredicate);
            default -> OKMUtils.getNeighborBlockPoses(center, level, blockStatePredicate);
        };
    }

    static List<BlockPos> getNeighborBlockPoses(BlockPos pos, Level level, Predicate<BlockState> blockStatePredicate) {
        return Arrays.stream(Direction.values()).map(arg_0 -> ((BlockPos)pos).relative(arg_0)).filter(blockPos -> blockStatePredicate.test(level.getBlockState(blockPos))).toList();
    }

    private static List<BlockPos> get2DAroundBlockPoses(BlockPos pos, Level level, Predicate<BlockState> blockStatePredicate) {
        return Arrays.stream(Direction8.values()).map(direction8 -> {
            direction8.getDirections().forEach(arg_0 -> ((BlockPos)pos).relative(arg_0));
            return pos;
        }).filter(blockPos -> blockStatePredicate.test(level.getBlockState(blockPos))).toList();
    }

    private static List<BlockPos> get3DAroundBlockPoses(BlockPos pos, Level level, Predicate<BlockState> blockStatePredicate) {
        return Arrays.stream(Direction26.values()).map(direction26 -> pos.offset(direction26.offset())).filter(blockPos -> blockStatePredicate.test(level.getBlockState(blockPos))).toList();
    }

    private static boolean isWithinRadius(BlockPos pos, BlockPos center, int radius) {
        return pos.distSqr((Vec3i)center) <= (double)(radius * radius);
    }

    private static void addItemStack(ArrayList<ItemStack> drops, ItemStack stack) {
        for (ItemStack itemStack : drops) {
            if (!ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)stack)) continue;
            itemStack.grow(stack.getCount());
            return;
        }
        drops.add(stack);
    }
}

