/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer;

import cn.onekeyminer.OKMConfig;
import cn.onekeyminer.OKMUtils;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class PlayerBreakEventUtils {
    private static boolean isProcessing = false;

    public static void excavateSphere(Level world, ServerPlayer player, BlockPos centerPos, BlockState targetBlock) {
        if (isProcessing) {
            return;
        }
        int exp = 0;
        ItemStack mainHandItem = player.getMainHandItem();
        isProcessing = true;
        int maxChainCount = (Integer)OKMConfig.max_count.get();
        boolean protectDurability = (Boolean)OKMConfig.toolProtectionMode.get();
        double hungerThreshold = (Double)OKMConfig.SaturationdeductionThreshold.get();
        FoodData foodData = player.getFoodData();
        if ((double)foodData.getFoodLevel() < hungerThreshold) {
            isProcessing = false;
            return;
        }
        ItemStack tool = player.getMainHandItem();
        double toolDurabilityThreshold = (Double)OKMConfig.toolDurabilityThreshold.get();
        if (protectDurability && tool.isDamageableItem()) {
            double durability;
            double d = durability = tool.getMaxDamage() > 1 ? (double)tool.getDamageValue() / (double)tool.getMaxDamage() : (double)tool.getDamageValue();
            if (durability >= toolDurabilityThreshold) {
                isProcessing = false;
                return;
            }
        }
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(centerPos);
        visited.add(centerPos);
        HashSet<BlockPos> toBreak = new HashSet<BlockPos>();
        int chainCount = 0;
        while (!queue.isEmpty() && chainCount < maxChainCount) {
            BlockPos pos = (BlockPos)queue.poll();
            BlockState state = world.getBlockState(pos);
            if (state.getBlock() != targetBlock.getBlock() || !ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player)) continue;
            toBreak.add(pos);
            ++chainCount;
            for (BlockPos neighbor : OKMUtils.getNeighborBlockPoses(pos, world, blockState -> blockState.getBlock() == targetBlock.getBlock())) {
                if (visited.contains(neighbor)) continue;
                queue.add(neighbor);
                visited.add(neighbor);
            }
        }
        for (BlockPos pos : toBreak) {
            BlockState state = world.getBlockState(pos);
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent((Level)((ServerLevel)world), pos, state, (Player)player);
            boolean eventPosted = MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) continue;
            List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos), (Entity)player, (ItemStack)tool);
            for (ItemStack drop : drops) {
                player.getInventory().add(drop);
            }
            world.destroyBlock(pos, false, (Entity)player);
            tool.hurtAndBreak(1, (LivingEntity)player, mainHandItem.getEquipmentSlot());
            if ((exp += event.getExpToDrop()) <= 0) continue;
            world.addFreshEntity((Entity)new ExperienceOrb(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), exp));
        }
        isProcessing = false;
    }
}

