/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.config.ServerConfig;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class PathChainHandler {
    private static final Set<BlockPos> CURRENTLY_MINING = new HashSet<BlockPos>();

    public static boolean tryPathChainMine(ServerPlayer player, BlockPos pos, BlockState state, ItemStack tool) {
        if (!ChainModeCapability.isChainModeActive((Player)player)) {
            return false;
        }
        if (((Boolean)CommonConfig.INSTANCE.requireSneaking.get()).booleanValue() && !player.isShiftKeyDown()) {
            return false;
        }
        if (player.isCreative() && !((Boolean)CommonConfig.INSTANCE.enableInCreative.get()).booleanValue()) {
            return false;
        }
        if (PathChainHandler.isBlockBlacklisted(state)) {
            return false;
        }
        if (!PathChainHandler.isBlockInWhitelist(state)) {
            return false;
        }
        if (CURRENTLY_MINING.contains(pos)) {
            return false;
        }
        ServerLevel level = player.level();
        Set<BlockPos> allMatchingBlocks = PathChainHandler.findAllMatchingBlocks(level, pos, state);
        if (allMatchingBlocks.isEmpty() || allMatchingBlocks.size() <= 1) {
            return false;
        }
        BlockPos farthestPos = PathChainHandler.findFarthestBlock(pos, allMatchingBlocks);
        if (farthestPos == null || farthestPos.equals((Object)pos)) {
            return false;
        }
        PathChainHandler.executeSingleBlockMining(player, level, farthestPos, tool, pos);
        return true;
    }

    public static List<BlockPos> computePathMiningPositions(ServerPlayer player, ServerLevel level, BlockPos startPos, BlockState startState, ItemStack tool) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (!PathChainHandler.canUseTool(player, tool, 1)) {
            return result;
        }
        if (!PathChainHandler.hasEnoughHunger(player, 1)) {
            return result;
        }
        Set<BlockPos> allMatchingBlocks = PathChainHandler.findAllMatchingBlocks(level, startPos, startState);
        if (allMatchingBlocks.isEmpty() || allMatchingBlocks.size() <= 1) {
            result.add(startPos);
            return result;
        }
        BlockPos farthestPos = PathChainHandler.findFarthestBlock(startPos, allMatchingBlocks);
        if (farthestPos != null && !farthestPos.equals((Object)startPos)) {
            result.add(farthestPos);
        }
        return result;
    }

    private static Set<BlockPos> findAllMatchingBlocks(ServerLevel level, BlockPos start, BlockState targetState) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        int maxBlocks = (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        queue.add(start);
        result.add(start);
        while (!queue.isEmpty() && result.size() < maxBlocks) {
            BlockPos current = (BlockPos)queue.poll();
            for (BlockPos neighbor : PathChainHandler.getNeighbors(current)) {
                BlockState neighborState;
                if (result.contains(neighbor) || !PathChainHandler.isBlockMatching(targetState, neighborState = level.getBlockState(neighbor)) || !PathChainHandler.isBlockInWhitelist(neighborState) || PathChainHandler.isBlockBlacklisted(neighborState)) continue;
                result.add(neighbor);
                queue.add(neighbor);
            }
        }
        return result;
    }

    private static BlockPos findFarthestBlock(BlockPos origin, Set<BlockPos> blocks) {
        if (blocks.isEmpty()) {
            return null;
        }
        int[] posYs = blocks.stream().mapToInt(Vec3i::getY).distinct().filter(y -> y != origin.getY()).toArray();
        if (posYs.length == 0) {
            return PathChainHandler.findFarthestInSameY(origin, blocks, origin.getY());
        }
        int max = Arrays.stream(posYs).max().orElse(origin.getY());
        int min = Arrays.stream(posYs).min().orElse(origin.getY());
        int targetY = max < origin.getY() ? Math.min(min, origin.getY()) : max;
        return PathChainHandler.findFarthestInSameY(origin, blocks, targetY);
    }

    private static BlockPos findFarthestInSameY(BlockPos origin, Set<BlockPos> blocks, int targetY) {
        HashMap distanceMap = new HashMap();
        blocks.stream().filter(pos -> pos.getY() == targetY && !pos.equals((Object)origin)).forEach(pos -> {
            int distance = Math.abs(pos.getX() - origin.getX()) + Math.abs(pos.getZ() - origin.getZ());
            distanceMap.put(distance, pos);
        });
        if (distanceMap.isEmpty()) {
            return origin;
        }
        int maxDistance = distanceMap.keySet().stream().max(Comparator.naturalOrder()).orElse(0);
        return (BlockPos)distanceMap.get(maxDistance);
    }

    private static List<BlockPos> getNeighbors(BlockPos pos) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        boolean diagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        neighbors.add(pos.above());
        neighbors.add(pos.below());
        neighbors.add(pos.north());
        neighbors.add(pos.south());
        neighbors.add(pos.east());
        neighbors.add(pos.west());
        if (diagonal) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0 || Math.abs(dx) + Math.abs(dy) + Math.abs(dz) == 1) continue;
                        neighbors.add(pos.offset(dx, dy, dz));
                    }
                }
            }
        }
        return neighbors;
    }

    private static boolean isBlockMatching(BlockState target, BlockState candidate) {
        if (((Boolean)CommonConfig.INSTANCE.matchBlockState.get()).booleanValue()) {
            return target.equals((Object)candidate);
        }
        return target.getBlock() == candidate.getBlock();
    }

    private static boolean isBlockInWhitelist(BlockState state) {
        List whitelist = (List)CommonConfig.INSTANCE.pathMiningBlockTags.get();
        if (whitelist.isEmpty()) {
            return true;
        }
        Block block = state.getBlock();
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        for (String entry : whitelist) {
            String tagName;
            TagKey tag;
            if (!(entry.startsWith("#") ? state.is(tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)(tagName = entry.substring(1))))) : blockId.toString().equals(entry))) continue;
            return true;
        }
        return false;
    }

    private static boolean isBlockBlacklisted(BlockState state) {
        List blacklist = (List)CommonConfig.INSTANCE.nonChainableBlocks.get();
        Block block = state.getBlock();
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        for (String entry : blacklist) {
            if (!blockId.toString().equals(entry)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeSingleBlockMining(ServerPlayer player, ServerLevel level, BlockPos targetPos, ItemStack tool, BlockPos originPos) {
        CURRENTLY_MINING.add(targetPos);
        try {
            Vec3 dropPos;
            if (!PathChainHandler.canUseTool(player, tool, 1)) {
                return;
            }
            if (!PathChainHandler.hasEnoughHunger(player, 1)) {
                return;
            }
            BlockState state = level.getBlockState(targetPos);
            if (state.isAir()) {
                return;
            }
            boolean teleportDrops = (Boolean)CommonConfig.INSTANCE.teleportDropsToPlayer.get();
            Vec3 vec3 = dropPos = teleportDrops ? PathChainHandler.getDropPosition(player, originPos) : Vec3.atCenterOf((Vec3i)targetPos);
            if (PathChainHandler.destroyBlock(player, level, targetPos, state, tool, dropPos)) {
                if (!player.isCreative() && tool.isDamageableItem()) {
                    tool.hurtAndBreak(1, (LivingEntity)player, player.getMainHandItem().getEquipmentSlot());
                }
                if (!player.isCreative()) {
                    player.causeFoodExhaustion(0.005f);
                }
                NetworkHandler.sendToPlayer(new ChainActionPacket("mining", 1), player);
            }
        }
        finally {
            CURRENTLY_MINING.remove(targetPos);
        }
    }

    private static Vec3 getDropPosition(ServerPlayer player, BlockPos originPos) {
        double offsetX;
        double offsetY;
        Vec3 vec = Vec3.atCenterOf((Vec3i)originPos);
        BlockPos playerPos = player.getOnPos();
        double d = playerPos.getY() < originPos.getY() ? (originPos.getY() - playerPos.getY() >= 2 ? -0.7 : 0.0) : (offsetY = 0.7);
        double d2 = playerPos.getX() != originPos.getX() ? (playerPos.getX() > originPos.getX() ? 0.7 : -0.7) : (offsetX = 0.0);
        double offsetZ = playerPos.getZ() != originPos.getZ() ? (playerPos.getZ() > originPos.getZ() ? 0.7 : -0.7) : 0.0;
        return vec.add(offsetX, offsetY, offsetZ);
    }

    private static boolean destroyBlock(ServerPlayer player, ServerLevel level, BlockPos pos, BlockState state, ItemStack tool, Vec3 dropPos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        Block block = state.getBlock();
        if (!player.isCreative()) {
            DropExperienceBlock dropExpBlock;
            int exp;
            LootParams.Builder builder = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)tool).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)blockEntity);
            state.getDrops(builder).forEach(stack -> {
                if (!stack.isEmpty()) {
                    ItemEntity itemEntity = new ItemEntity((Level)level, dropPos.x(), dropPos.y(), dropPos.z(), stack);
                    itemEntity.setDefaultPickUpDelay();
                    level.addFreshEntity((Entity)itemEntity);
                    if (((Boolean)CommonConfig.INSTANCE.teleportDropsToPlayer.get()).booleanValue()) {
                        PathChainHandler.pushToPlayer(itemEntity, player);
                    }
                }
            });
            if (block instanceof DropExperienceBlock && (exp = (dropExpBlock = (DropExperienceBlock)block).getExpDrop(state, (LevelAccessor)level, pos, blockEntity, (Entity)player, tool)) > 0) {
                ExperienceOrb.award((ServerLevel)level, (Vec3)dropPos, (int)exp);
            }
        }
        return level.destroyBlock(pos, false, (Entity)player);
    }

    private static void pushToPlayer(ItemEntity itemEntity, ServerPlayer player) {
        Vec3 playerPos = player.position();
        Vec3 entityPos = itemEntity.position();
        itemEntity.push((playerPos.x - entityPos.x) * 0.1, (playerPos.y - entityPos.y) * 0.1, (playerPos.z - entityPos.z) * 0.1);
    }

    private static boolean canUseTool(ServerPlayer player, ItemStack tool, int durabilityNeeded) {
        if (player.isCreative()) {
            return true;
        }
        if (!((Boolean)ServerConfig.INSTANCE.toolProtectionEnabled.get()).booleanValue()) {
            return true;
        }
        if (!tool.isDamageableItem()) {
            return true;
        }
        int maxDamage = tool.getMaxDamage();
        int currentDamage = tool.getDamageValue();
        int remaining = maxDamage - currentDamage;
        double threshold = (Double)ServerConfig.INSTANCE.toolDurabilityThreshold.get();
        int requiredRemaining = threshold <= 1.0 ? (int)((double)maxDamage * threshold) : (int)threshold;
        return remaining > requiredRemaining + durabilityNeeded;
    }

    private static boolean hasEnoughHunger(ServerPlayer player, int blocksToMine) {
        if (player.isCreative()) {
            return true;
        }
        if (!((Boolean)ServerConfig.INSTANCE.hungerProtectionEnabled.get()).booleanValue()) {
            return true;
        }
        double threshold = (Double)ServerConfig.INSTANCE.hungerThreshold.get();
        return (double)player.getFoodData().getFoodLevel() > threshold;
    }
}

