/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AzaleaBlock;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.NetherSproutsBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.RootsBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class PlantingHandler {
    private static final Set<BlockPos> CURRENTLY_PLANTING = new HashSet<BlockPos>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ItemStack heldItem = player.getItemInHand(event.getHand());
        if (!PlantingHandler.isPlantableItem(heldItem)) {
            return;
        }
        if (PlantingHandler.isInBlacklist(heldItem)) {
            return;
        }
        BlockPos pos = event.getPos();
        if (CURRENTLY_PLANTING.contains(pos)) {
            return;
        }
        CURRENTLY_PLANTING.add(pos);
        try {
            serverPlayer.level().getServer().execute(() -> {
                ServerLevel level = serverPlayer.level();
                BlockState targetState = level.getBlockState(pos);
                PlantingHandler.performChainPlanting(serverPlayer, event.getHand(), pos, targetState, heldItem);
            });
        }
        finally {
            CURRENTLY_PLANTING.remove(pos);
        }
    }

    private static void performChainPlanting(ServerPlayer player, InteractionHand hand, BlockPos startPos, BlockState targetState, ItemStack seedItem) {
        ServerLevel level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        int maxPlants = (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        if (player.isCreative()) {
            maxPlants = (Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get();
        }
        long startTime = System.currentTimeMillis();
        long timeLimit = 2000L;
        int maxIterations = Math.min(10000, maxPlants * 10);
        int iterations = 0;
        int availableSeeds = PlantingHandler.countAvailableItems((Player)player, seedItem.getItem());
        if (player.isCreative()) {
            availableSeeds = Integer.MAX_VALUE;
        }
        LinkedList<BlockPos> positionsToCheck = new LinkedList<BlockPos>();
        positionsToCheck.add(startPos);
        HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
        checkedPositions.add(startPos);
        HashSet<BlockPos> plantedPositions = new HashSet<BlockPos>();
        boolean allowDiagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        int plantsCount = 0;
        try {
            while (!positionsToCheck.isEmpty() && plantsCount < maxPlants && iterations < maxIterations && System.currentTimeMillis() - startTime <= 2000L) {
                ++iterations;
                BlockPos currentPos = (BlockPos)positionsToCheck.poll();
                if (plantedPositions.contains(currentPos)) continue;
                if (plantsCount >= availableSeeds && !player.isCreative()) break;
                if (PlantingHandler.canPlantAt((Level)level, currentPos, level.getBlockState(currentPos), seedItem)) {
                    try {
                        if (PlantingHandler.tryPlant(player, hand, currentPos, seedItem)) {
                            plantedPositions.add(currentPos);
                            ++plantsCount;
                            if (!player.isCreative()) {
                                --availableSeeds;
                            }
                        }
                    }
                    catch (Exception e) {
                        Onekeyminer.LOGGER.error("\u5728\u4f4d\u7f6e {} \u79cd\u690d\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)currentPos, (Object)e.getMessage());
                    }
                }
                for (Direction direction : Direction.values()) {
                    try {
                        BlockPos adjacentPos = currentPos.relative(direction);
                        if (checkedPositions.contains(adjacentPos) || !(adjacentPos.distSqr((Vec3i)startPos) <= 100.0)) continue;
                        positionsToCheck.add(adjacentPos);
                        checkedPositions.add(adjacentPos);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (allowDiagonal && iterations % 2 == 0) {
                    for (int x = -1; x <= 1; x += 2) {
                        for (int y = -1; y <= 1; y += 2) {
                            for (int z = -1; z <= 1; z += 2) {
                                try {
                                    BlockPos diagonalPos = currentPos.offset(x, y, z);
                                    if (checkedPositions.contains(diagonalPos) || !(diagonalPos.distSqr((Vec3i)startPos) <= 100.0)) continue;
                                    positionsToCheck.add(diagonalPos);
                                    checkedPositions.add(diagonalPos);
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                if (positionsToCheck.size() <= 1000) continue;
                LinkedList<BlockPos> limitedQueue = new LinkedList<BlockPos>();
                for (int i = 0; i < 500 && !positionsToCheck.isEmpty(); ++i) {
                    limitedQueue.add((BlockPos)positionsToCheck.poll());
                }
                positionsToCheck = limitedQueue;
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8fde\u9501\u79cd\u690d\u8fc7\u7a0b\u4e2d\u53d1\u751f\u672a\u9884\u671f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
        if (plantsCount > 0) {
            try {
                NetworkHandler.sendToPlayer(new ChainActionPacket("planting", plantsCount), player);
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.error("\u53d1\u9001\u8fde\u9501\u79cd\u690d\u6d88\u606f\u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static boolean tryPlant(ServerPlayer player, InteractionHand hand, BlockPos pos, ItemStack seedItem) {
        ServerLevel level = player.level();
        BlockHitResult hitResult = new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.UP, pos, false);
        UseOnContext context = new UseOnContext((Player)player, hand, hitResult);
        InteractionResult result = seedItem.useOn(context);
        return result.consumesAction();
    }

    private static boolean canPlantAt(Level level, BlockPos pos, BlockState state, ItemStack seedItem) {
        if (!level.isEmptyBlock(pos)) {
            return false;
        }
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        return PlantingHandler.canPlantOnSurface(seedItem.getItem(), belowState);
    }

    private static int countAvailableItems(Player player, Item item) {
        int count = 0;
        if (player.getMainHandItem().getItem() == item) {
            count += player.getMainHandItem().getCount();
        }
        if (player.getOffhandItem().getItem() == item) {
            count += player.getOffhandItem().getCount();
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.getItem() != item) continue;
            count += stack.getCount();
        }
        return count;
    }

    private static boolean canPlantOnSurface(Item item, BlockState surfaceState) {
        Block surfaceBlock = surfaceState.getBlock();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            if (block instanceof CropBlock) {
                return surfaceBlock == Blocks.FARMLAND;
            }
            if (block instanceof SaplingBlock || block instanceof FlowerBlock) {
                return surfaceBlock == Blocks.DIRT || surfaceBlock == Blocks.GRASS_BLOCK || surfaceBlock == Blocks.PODZOL || surfaceBlock == Blocks.MYCELIUM;
            }
            if (block instanceof MushroomBlock) {
                return surfaceBlock == Blocks.MYCELIUM;
            }
            if (item == Items.POTATO || item == Items.CARROT || item == Items.WHEAT_SEEDS || item == Items.BEETROOT_SEEDS) {
                return surfaceBlock == Blocks.FARMLAND;
            }
        }
        return surfaceBlock == Blocks.DIRT || surfaceBlock == Blocks.GRASS_BLOCK || surfaceBlock == Blocks.PODZOL || surfaceBlock == Blocks.SAND || surfaceBlock == Blocks.SOUL_SAND || surfaceBlock == Blocks.MYCELIUM || surfaceBlock instanceof FarmBlock || surfaceBlock == Blocks.FARMLAND || CommonConfig.INSTANCE.isFarmlandAllowedForChainPlanting(surfaceBlock.defaultBlockState());
    }

    static boolean isPlantableItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (PlantingHandler.isInBlacklist(stack)) {
            return false;
        }
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
            return block instanceof CropBlock || block instanceof SaplingBlock || block instanceof BushBlock || block instanceof FlowerBlock || block instanceof TallFlowerBlock || block instanceof CactusBlock || block instanceof TallGrassBlock || block instanceof FungusBlock || block instanceof RootsBlock || block instanceof NetherSproutsBlock || block instanceof CocoaBlock || block instanceof MangroveRootsBlock || block instanceof SugarCaneBlock || block instanceof NetherWartBlock || block instanceof BambooStalkBlock || block instanceof BambooSaplingBlock || block instanceof AzaleaBlock;
        }
        String itemName = item.toString().toLowerCase();
        if (itemName.contains("seed") || itemName.contains("sapling") || itemName.contains("seedling") || itemName.contains("plant")) {
            return true;
        }
        return item == Items.WHEAT_SEEDS || item == Items.BEETROOT_SEEDS || item == Items.PUMPKIN_SEEDS || item == Items.MELON_SEEDS || item == Items.POTATO || item == Items.CARROT || item == Items.TORCHFLOWER_SEEDS || item == Items.PITCHER_POD || item == Items.SWEET_BERRIES || item == Items.GLOW_BERRIES || item == Items.CRIMSON_FUNGUS || item == Items.WARPED_FUNGUS || item == Items.COCOA_BEANS || item == Items.KELP || item == Items.BAMBOO || item == Items.SUGAR_CANE || item == Items.CACTUS || item == Items.SEA_PICKLE;
    }

    private static boolean isInBlacklist(ItemStack stack) {
        return CommonConfig.INSTANCE.isSeedBlacklisted(stack.getItem());
    }

    private static boolean isPlantableBlock(Block block) {
        return block == Blocks.OAK_SAPLING || block == Blocks.SPRUCE_SAPLING || block == Blocks.BIRCH_SAPLING || block == Blocks.JUNGLE_SAPLING || block == Blocks.ACACIA_SAPLING || block == Blocks.DARK_OAK_SAPLING || block == Blocks.BAMBOO_SAPLING || block == Blocks.MANGROVE_PROPAGULE || block == Blocks.CHERRY_SAPLING || block == Blocks.TORCHFLOWER || block == Blocks.PITCHER_PLANT || block == Blocks.PINK_PETALS || block == Blocks.AZALEA || block == Blocks.FLOWERING_AZALEA;
    }

    public static List<BlockPos> computePlantingPositions(ServerPlayer player, ServerLevel level, BlockPos startPos, BlockState targetState, ItemStack seedItem) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (!PlantingHandler.isPlantableItem(seedItem)) {
            return result;
        }
        int maxPlants = (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        if (player.isCreative()) {
            maxPlants = (Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get();
        }
        long startTime = System.currentTimeMillis();
        long timeLimit = 500L;
        int maxIterations = Math.min(5000, maxPlants * 8);
        int iterations = 0;
        int availableSeeds = PlantingHandler.countAvailableItems((Player)player, seedItem.getItem());
        if (player.isCreative()) {
            availableSeeds = Integer.MAX_VALUE;
        }
        LinkedList<BlockPos> positionsToCheck = new LinkedList<BlockPos>();
        positionsToCheck.add(startPos);
        HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
        checkedPositions.add(startPos);
        boolean allowDiagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        int plantsCount = 0;
        try {
            while (!positionsToCheck.isEmpty() && plantsCount < maxPlants && iterations < maxIterations && plantsCount < availableSeeds && System.currentTimeMillis() - startTime <= 500L) {
                ++iterations;
                BlockPos currentPos = (BlockPos)positionsToCheck.poll();
                if (PlantingHandler.canPlantAt((Level)level, currentPos, level.getBlockState(currentPos), seedItem)) {
                    result.add(currentPos);
                    ++plantsCount;
                }
                for (Direction direction : Direction.values()) {
                    BlockPos adjacentPos = currentPos.relative(direction);
                    if (checkedPositions.contains(adjacentPos) || !(adjacentPos.distSqr((Vec3i)startPos) <= 100.0)) continue;
                    positionsToCheck.add(adjacentPos);
                    checkedPositions.add(adjacentPos);
                }
                if (allowDiagonal && iterations % 2 == 0) {
                    for (int x = -1; x <= 1; x += 2) {
                        for (int y = -1; y <= 1; y += 2) {
                            for (int z = -1; z <= 1; z += 2) {
                                BlockPos diagonalPos = currentPos.offset(x, y, z);
                                if (checkedPositions.contains(diagonalPos) || !(diagonalPos.distSqr((Vec3i)startPos) <= 100.0)) continue;
                                positionsToCheck.add(diagonalPos);
                                checkedPositions.add(diagonalPos);
                            }
                        }
                    }
                }
                if (positionsToCheck.size() <= 500) continue;
                LinkedList<BlockPos> limitedQueue = new LinkedList<BlockPos>();
                for (int i = 0; i < 250 && !positionsToCheck.isEmpty(); ++i) {
                    limitedQueue.add((BlockPos)positionsToCheck.poll());
                }
                positionsToCheck = limitedQueue;
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8ba1\u7b97\u8fde\u9501\u79cd\u690d\u4f4d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleChainPlanting(ServerPlayer player, PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        InteractionHand hand = event.getHand();
        ItemStack heldItem = player.getItemInHand(hand);
        boolean canProcess = false;
        Set<BlockPos> set = CURRENTLY_PLANTING;
        synchronized (set) {
            if (!CURRENTLY_PLANTING.contains(pos)) {
                CURRENTLY_PLANTING.add(pos);
                canProcess = true;
            }
        }
        if (!canProcess) {
            return;
        }
        try {
            player.level().getServer().submit(() -> {
                Object level;
                try {
                    level = player.level();
                    BlockState targetState = level.getBlockState(pos);
                    PlantingHandler.performChainPlanting(player, hand, pos, targetState, heldItem);
                }
                catch (Throwable e) {
                    Onekeyminer.LOGGER.error("\u8fde\u9501\u79cd\u690d\u6267\u884c\u671f\u95f4\u53d1\u751f\u4e25\u91cd\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
                }
                finally {
                    level = CURRENTLY_PLANTING;
                    synchronized (level) {
                        CURRENTLY_PLANTING.remove(pos);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            Onekeyminer.LOGGER.error("\u65e0\u6cd5\u63d0\u4ea4\u4efb\u52a1: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

