/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.api.ChainPositionStore;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.chain.ChainHandler;
import org.xiyu.yee.onekeyminer.chain.InteractionHandler;
import org.xiyu.yee.onekeyminer.chain.PathChainHandler;
import org.xiyu.yee.onekeyminer.chain.PlantingHandler;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.config.ServerConfig;

@EventBusSubscriber(modid="onekeyminer")
public class UnifiedChainHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        try {
            if (!ChainModeCapability.isChainModeActive((Player)player)) {
                return;
            }
            if (((Boolean)CommonConfig.INSTANCE.requireSneaking.get()).booleanValue() && !player.isShiftKeyDown()) {
                return;
            }
            if (player.isCreative() && !((Boolean)CommonConfig.INSTANCE.enableInCreative.get()).booleanValue()) {
                return;
            }
            if (!UnifiedChainHandler.isToolItem(player.getItemInHand(event.getHand()))) {
                return;
            }
            ItemStack heldItem = player.getItemInHand(event.getHand());
            BlockState targetState = event.getLevel().getBlockState(event.getPos());
            try {
                UUID uuid = player.getUUID();
                String key = uuid.toString();
                if (InteractionHandler.isValidInteractionTool(heldItem)) {
                    ChainPositionStore.setInteractionPositions(key, new ArrayList<BlockPos>());
                } else if (UnifiedChainHandler.isPlantableItem(heldItem)) {
                    ChainPositionStore.setPlantingPositions(key, new ArrayList<BlockPos>());
                } else {
                    ChainPositionStore.setMiningPositions(key, new ArrayList<BlockPos>());
                }
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.debug("\u6e05\u7406\u8fde\u9501\u4f4d\u7f6e\u5b58\u50a8\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
            }
            if (InteractionHandler.isValidInteractionTool(heldItem)) {
                if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u89e6\u53d1\u5de5\u5177\u8fde\u9501\u4ea4\u4e92: {}", (Object)heldItem.getItem().getClass().getSimpleName());
                }
                InteractionHandler.tryChainInteraction(player, (ServerLevel)event.getLevel(), event.getPos(), event.getFace(), event.getHitVec().getLocation(), event.getHand());
            } else if (UnifiedChainHandler.isPlantableItem(heldItem)) {
                PlantingHandler.handleChainPlanting(player, event);
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u5904\u7406\u73a9\u5bb6\u4ea4\u4e92\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            Onekeyminer.LOGGER.debug("\u8be6\u7ec6\u9519\u8bef\u6808", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        try {
            Sheep sheep;
            if (!ChainModeCapability.isChainModeActive((Player)player)) {
                return;
            }
            if (((Boolean)CommonConfig.INSTANCE.requireSneaking.get()).booleanValue() && !player.isShiftKeyDown()) {
                return;
            }
            if (player.isCreative() && !((Boolean)CommonConfig.INSTANCE.enableInCreative.get()).booleanValue()) {
                return;
            }
            ItemStack heldItem = player.getItemInHand(event.getHand());
            Entity targetEntity = event.getTarget();
            if (heldItem.getItem() instanceof ShearsItem && targetEntity instanceof Sheep && (sheep = (Sheep)targetEntity).isShearable((Player)player, heldItem, (Level)player.level(), sheep.blockPosition())) {
                if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u68c0\u6d4b\u5230\u526a\u7f8a\u6bdb\u64cd\u4f5c");
                }
                MinecraftServer server = player.level().getServer();
                server.submit((Runnable)new TickTask(0, () -> InteractionHandler.tryChainShearing(player, sheep, event.getHand())));
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u5904\u7406\u5b9e\u4f53\u4ea4\u4e92\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            Onekeyminer.LOGGER.debug("\u8be6\u7ec6\u9519\u8bef\u6808", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        try {
            ServerLevel level;
            if (!ChainModeCapability.isChainModeActive((Player)player)) {
                return;
            }
            ItemStack tool = player.getMainHandItem();
            BlockState state = event.getState();
            ServerLevel serverLevel = level = player.level();
            BlockEntity blockEntity = level.getBlockEntity(event.getPos());
            boolean usePathMining = (Boolean)ServerConfig.INSTANCE.usePathMining.get();
            if (usePathMining) {
                boolean handled;
                if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u4f7f\u7528\u8def\u5f84\u5f0f\u8fde\u9501\u7834\u574f");
                }
                if (handled = PathChainHandler.tryPathChainMine(player, event.getPos(), state, tool)) {
                    event.setCanceled(true);
                }
            } else {
                if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u4f7f\u7528\u4f20\u7edf\u8fde\u9501\u7834\u574f");
                }
                ChainHandler.tryChainMine(player, event.getPos(), state, tool);
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u5904\u7406\u65b9\u5757\u7834\u574f\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
            Onekeyminer.LOGGER.debug("\u8be6\u7ec6\u9519\u8bef\u6808", (Throwable)e);
        }
    }

    public static boolean isToolItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        return item instanceof ShearsItem || item instanceof HoeItem || item instanceof AxeItem || item instanceof ShovelItem || UnifiedChainHandler.isPlantableItem(stack);
    }

    public static boolean isPlantableItem(ItemStack stack) {
        return PlantingHandler.isPlantableItem(stack);
    }
}

