/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CommonConfig {
    public static final ModConfigSpec SPEC;
    public static final CommonConfig INSTANCE;
    public final ModConfigSpec.ConfigValue<List<? extends String>> chainPlantableFarmlands;
    public final ModConfigSpec.ConfigValue<List<? extends String>> pathMiningBlockTags;
    public final ModConfigSpec.IntValue maxChainBlocks;
    public final ModConfigSpec.ConfigValue<List<? extends String>> nonChainableBlocks;
    public final ModConfigSpec.ConfigValue<List<? extends String>> seedBlacklist;
    public final ModConfigSpec.BooleanValue enableDiagonalChaining;
    public final ModConfigSpec.IntValue maxMiningDepth;
    public final ModConfigSpec.BooleanValue teleportDropsToPlayer;
    public final ModConfigSpec.BooleanValue ignoreToolCompatibility;
    public final ModConfigSpec.BooleanValue matchBlockState;
    public final ModConfigSpec.BooleanValue matchseedBlockState;
    public final ModConfigSpec.BooleanValue enableInCreative;
    public final ModConfigSpec.BooleanValue requireSneaking;
    public final ModConfigSpec.IntValue maxBlocksInChain;
    public final ModConfigSpec.IntValue maxBlocksInChainCreative;
    public final ModConfigSpec.IntValue maxChainDepth;
    public final ModConfigSpec.BooleanValue enableDebugMode;

    private CommonConfig(ModConfigSpec.Builder builder) {
        builder.comment("\u901a\u7528\u914d\u7f6e||Common Config").push("general");
        this.maxChainBlocks = builder.comment("\u8fde\u9501\u64cd\u4f5c\u7684\u6700\u5927\u65b9\u5757\u6570||Maximum number of blocks for chain operations").translation("config.onekeyminer.maxChainBlocks").defineInRange("maxChainBlocks", 64, 1, 4096);
        this.nonChainableBlocks = builder.comment("\u4e0d\u5141\u8bb8\u8fde\u9501\u6316\u6398\u7684\u65b9\u5757\u9ed1\u540d\u5355||Blocks that should not be chain mined").translation("config.onekeyminer.nonChainableBlocks").define("nonChainableBlocks", () -> {
            ArrayList<String> defaults = new ArrayList<String>();
            defaults.add("minecraft:bedrock");
            return defaults;
        }, obj -> {
            if (!(obj instanceof List)) return false;
            if (!((List)obj).stream().allMatch(String.class::isInstance)) return false;
            return true;
        });
        this.seedBlacklist = builder.comment("\u4e0d\u5141\u8bb8\u8fde\u9501\u79cd\u690d\u7684\u79cd\u5b50\u9ed1\u540d\u5355||Seeds that should not be chain planted").translation("config.onekeyminer.seedBlacklist").define("seedBlacklist", ArrayList::new, obj -> {
            if (!(obj instanceof List)) return false;
            if (!((List)obj).stream().allMatch(String.class::isInstance)) return false;
            return true;
        });
        this.chainPlantableFarmlands = builder.comment("\u5141\u8bb8\u8fde\u9501\u79cd\u690d\u7684\u8015\u5730\u767d\u540d\u5355\uff08\u652f\u6301\u5355\u4e2a\u65b9\u5757ID\u548c\u6807\u7b7e\uff0c\u6807\u7b7e\u9700\u4ee5#\u5f00\u5934\uff09||Whitelist of farmlands allowed for chain planting (supports single block IDs and tags, tags start with #)\n\u793a\u4f8b\uff1a[\"minecraft:farmland\", \"#yourmod:custom_farmlands\"]").translation("config.onekeyminer.chainPlantableFarmlands").define("chainPlantableFarmlands", () -> {
            ArrayList<String> defaultFarmlands = new ArrayList<String>();
            defaultFarmlands.add("minecraft:farmland");
            return defaultFarmlands;
        }, obj -> {
            if (!(obj instanceof List)) return false;
            if (!((List)obj).stream().allMatch(String.class::isInstance)) return false;
            return true;
        });
        this.pathMiningBlockTags = builder.comment("\u8def\u5f84\u8fde\u9501\u7834\u574f\u7684\u65b9\u5757\u6807\u7b7e\u767d\u540d\u5355\uff08\u652f\u6301\u5355\u4e2a\u65b9\u5757ID\u548c\u6807\u7b7e\uff0c\u6807\u7b7e\u9700\u4ee5#\u5f00\u5934\uff09||Whitelist of block tags for path-based chain mining (supports single block IDs and tags, tags start with #)\n\u793a\u4f8b\uff1a[\"#minecraft:logs\", \"#minecraft:ores\", \"minecraft:stone\"]").translation("config.onekeyminer.pathMiningBlockTags").define("pathMiningBlockTags", () -> {
            ArrayList<String> defaultTags = new ArrayList<String>();
            defaultTags.add("#minecraft:logs");
            defaultTags.add("#minecraft:leaves");
            return defaultTags;
        }, obj -> {
            if (!(obj instanceof List)) return false;
            if (!((List)obj).stream().allMatch(String.class::isInstance)) return false;
            return true;
        });
        this.enableDiagonalChaining = builder.comment("\u662f\u5426\u5141\u8bb8\u5bf9\u89d2\u7ebf\u8fde\u9501\uff08\u5141\u8bb8\u5bf9\u89d2\u8fde\u63a5\u7684\u65b9\u5757\u53c2\u4e0e\u8fde\u9501\uff09||Whether to allow diagonal chaining (allow blocks connected diagonally to participate in chain mining)").translation("config.onekeyminer.enableDiagonalChaining").define("enableDiagonalChaining", false);
        this.maxMiningDepth = builder.comment("\u6700\u5927\u6316\u6398\u6df1\u5ea6\uff08\u9632\u6b62\u8fde\u9501\u8fc7\u6df1\uff09||Maximum mining depth (prevent chain mining from being too deep)").translation("config.onekeyminer.maxMiningDepth").defineInRange("maxMiningDepth", 16, 1, 64);
        this.teleportDropsToPlayer = builder.comment("\u662f\u5426\u5c06\u8fde\u9501\u6316\u6398\u7684\u6389\u843d\u7269\u4f20\u9001\u5230\u73a9\u5bb6\u8eab\u4e0b||Whether to teleport the drops from chain mining to the player").translation("config.onekeyminer.teleportDropsToPlayer").define("teleportDropsToPlayer", false);
        this.ignoreToolCompatibility = builder.comment("\u662f\u5426\u5ffd\u7565\u5de5\u5177\u517c\u5bb9\u6027\u68c0\u67e5||Whether to ignore tool compatibility checks").translation("config.onekeyminer.ignoreToolCompatibility").define("ignoreToolCompatibility", true);
        this.matchBlockState = builder.comment("\u662f\u5426\u5339\u914d\u5b8c\u6574\u7684\u65b9\u5757\u72b6\u6001\u800c\u4e0d\u4ec5\u4ec5\u662f\u65b9\u5757\u7c7b\u578b||Whether to match the complete block state rather than just the block type").translation("config.onekeyminer.matchBlockState").define("matchBlockState", false);
        this.matchseedBlockState = builder.comment("\u662f\u5426\u5339\u914d\u5b8c\u6574\u7684\u79cd\u5b50\u65b9\u5757\u72b6\u6001\u800c\u4e0d\u4ec5\u4ec5\u662f\u79cd\u5b50\u65b9\u5757\u7c7b\u578b || Whether to match the complete state of the seed block rather than just the type of the seed block.").translation("config.onekeyminer.matchseedBlockState").define("matchseedBlockState", false);
        this.enableInCreative = builder.comment("\u521b\u9020\u6a21\u5f0f\u662f\u5426\u542f\u7528\u8fde\u9501\u6316\u6398||Whether to enable chain mining in creative mode").translation("config.onekeyminer.enableInCreative").define("enableInCreative", true);
        this.requireSneaking = builder.comment("\u662f\u5426\u9700\u8981\u4e0b\u8e72\u624d\u80fd\u89e6\u53d1\u8fde\u9501\u6316\u6398||Whether to require sneaking to trigger chain mining").translation("config.onekeyminer.requireSneaking").define("requireSneaking", false);
        this.maxBlocksInChain = builder.comment("\u5b58\u6d3b\u6a21\u5f0f\u4e0b\u8fde\u9501\u6316\u6398\u7684\u6700\u5927\u65b9\u5757\u6570||Maximum number of blocks for chain mining in survival mode").translation("config.onekeyminer.maxBlocksInChain").defineInRange("maxBlocksInChain", 64, 1, 4096);
        this.maxBlocksInChainCreative = builder.comment("\u521b\u9020\u6a21\u5f0f\u4e0b\u8fde\u9501\u6316\u6398\u7684\u6700\u5927\u65b9\u5757\u6570||Maximum number of blocks for chain mining in creative mode").translation("config.onekeyminer.maxBlocksInChainCreative").defineInRange("maxBlocksInChainCreative", 256, 1, 16384);
        this.maxChainDepth = builder.comment("\u6700\u5927\u8fde\u9501\u641c\u7d22\u6df1\u5ea6||Maximum chain search depth").translation("config.onekeyminer.maxChainDepth").defineInRange("maxChainDepth", 16, 1, 64);
        this.enableDebugMode = builder.comment("\u542f\u7528\u8c03\u8bd5\u6a21\u5f0f\uff08\u670d\u52a1\u5668\u7aef\u8c03\u8bd5\u65e5\u5fd7\uff09||Enable debug mode (server-side debug logging)").translation("config.onekeyminer.enableDebugMode").define("enableDebugMode", false);
        builder.pop();
    }

    public boolean isBlockMineable(Block block) {
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        for (String entry : (List)this.nonChainableBlocks.get()) {
            if (entry.startsWith("#")) {
                ResourceLocation tagId = ResourceLocation.tryParse((String)entry.substring(1));
                if (tagId == null) continue;
                TagKey blockTag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)tagId);
                if (!block.defaultBlockState().is(blockTag)) continue;
                return false;
            }
            if (!blockId.toString().equals(entry)) continue;
            return false;
        }
        return true;
    }

    public boolean isSeedBlacklisted(Item item) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        for (String entry : (List)this.seedBlacklist.get()) {
            if (entry.startsWith("#")) {
                ResourceLocation tagId = ResourceLocation.tryParse((String)entry.substring(1));
                if (tagId == null) continue;
                TagKey itemTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagId);
                if (!item.builtInRegistryHolder().is(itemTag)) continue;
                return true;
            }
            if (!itemId.toString().equals(entry)) continue;
            return true;
        }
        return false;
    }

    public boolean isFarmlandAllowedForChainPlanting(BlockState farmlandState) {
        if (farmlandState == null) {
            return false;
        }
        Block farmlandBlock = farmlandState.getBlock();
        ResourceLocation farmlandId = BuiltInRegistries.BLOCK.getKey((Object)farmlandBlock);
        for (String entry : (List)this.chainPlantableFarmlands.get()) {
            TagKey farmlandTag;
            ResourceLocation tagId;
            if (entry == null || entry.trim().isEmpty() || !(entry.startsWith("#") ? (tagId = ResourceLocation.tryParse((String)entry.substring(1))) != null && farmlandState.is(farmlandTag = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)tagId)) : farmlandId.toString().equals(entry.trim()))) continue;
            return true;
        }
        return false;
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        SPEC = (ModConfigSpec)specPair.getRight();
        INSTANCE = (CommonConfig)specPair.getLeft();
    }
}

