/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.api.ChainAPI;
import org.xiyu.yee.onekeyminer.api.ChainPositionStore;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.network.ChainPositionsPacket;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ChainModePacket
implements IOneKeyPacket {
    private final boolean active;

    public ChainModePacket(boolean active) {
        this.active = active;
    }

    public static ChainModePacket fromNetwork(FriendlyByteBuf buf) {
        return new ChainModePacket(buf.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.active);
    }

    @Override
    public ResourceLocation id() {
        return NetworkHandler.CHAIN_MODE_ID;
    }

    public CustomPacketPayload.Type<?> type() {
        return NetworkHandler.CHAIN_MODE_TYPE;
    }

    public static void handleOnServer(ChainModePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp;
            if (context.player() != null && (patt0$temp = context.player()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                ChainModeCapability.setChainMode(serverPlayer, packet.active);
                try {
                    String key = serverPlayer.getUUID().toString();
                    if (packet.active) {
                        HitResult hr = serverPlayer.pick(6.0, 0.0f, false);
                        if (hr != null && hr.getType() == HitResult.Type.BLOCK) {
                            BlockHitResult bhr = (BlockHitResult)hr;
                            BlockPos pos = bhr.getBlockPos();
                            BlockState state = serverPlayer.level().getBlockState(pos);
                            ItemStack held = serverPlayer.getItemInHand(InteractionHand.MAIN_HAND);
                            List<BlockPos> mining = ChainAPI.computeMiningPositions(serverPlayer, serverPlayer.level(), pos, state, held);
                            ChainPositionStore.setMiningPositions(key, mining);
                            List<BlockPos> interaction = ChainAPI.computeInteractionPositions(serverPlayer, serverPlayer.level(), pos, state, InteractionHand.MAIN_HAND);
                            ChainPositionStore.setInteractionPositions(key, interaction);
                            List<BlockPos> planting = ChainAPI.computePlantingPositions(serverPlayer, serverPlayer.level(), pos, state, held);
                            ChainPositionStore.setPlantingPositions(key, planting);
                            ChainPositionsPacket sync = new ChainPositionsPacket(key, true, mining, interaction, planting);
                            NetworkHandler.sendToPlayer(sync, serverPlayer);
                        }
                    } else {
                        ChainPositionStore.clearAll(key);
                        ChainPositionsPacket sync = new ChainPositionsPacket(key, false, null, null, null);
                        NetworkHandler.sendToPlayer(sync, serverPlayer);
                    }
                }
                catch (Exception e) {
                    Onekeyminer.LOGGER.error("\u5904\u7406 ChainModePacket \u65f6\u8ba1\u7b97 positions \u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        });
    }

    public static void handleOnClient(ChainModePacket packet, IPayloadContext context) {
        Minecraft minecraft = Minecraft.getInstance();
        context.enqueueWork(() -> {
            if (minecraft.player == null) {
                return;
            }
            MutableComponent message = Component.translatable((String)(packet.active ? "message.onekeyminer.chain_mode_on" : "message.onekeyminer.chain_mode_off"));
            minecraft.player.displayClientMessage((Component)message, true);
        });
    }
}

