/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.api.ChainPositionStore;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ChainPositionsPacket
implements IOneKeyPacket {
    private final String playerUuid;
    private final boolean active;
    private final List<BlockPos> mining;
    private final List<BlockPos> interaction;
    private final List<BlockPos> planting;

    public ChainPositionsPacket(String playerUuid, boolean active, List<BlockPos> mining, List<BlockPos> interaction, List<BlockPos> planting) {
        this.playerUuid = playerUuid;
        this.active = active;
        this.mining = mining == null ? new ArrayList() : mining;
        this.interaction = interaction == null ? new ArrayList() : interaction;
        this.planting = planting == null ? new ArrayList() : planting;
    }

    public static ChainPositionsPacket fromNetwork(RegistryFriendlyByteBuf buf) {
        String uuid = buf.readUtf();
        boolean active = buf.readBoolean();
        int m = buf.readInt();
        ArrayList<BlockPos> mining = new ArrayList<BlockPos>();
        for (int i = 0; i < m; ++i) {
            mining.add(buf.readBlockPos());
        }
        int it = buf.readInt();
        ArrayList<BlockPos> interaction = new ArrayList<BlockPos>();
        for (int i = 0; i < it; ++i) {
            interaction.add(buf.readBlockPos());
        }
        int p = buf.readInt();
        ArrayList<BlockPos> planting = new ArrayList<BlockPos>();
        for (int i = 0; i < p; ++i) {
            planting.add(buf.readBlockPos());
        }
        return new ChainPositionsPacket(uuid, active, mining, interaction, planting);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.playerUuid);
        buf.writeBoolean(this.active);
        buf.writeInt(this.mining.size());
        for (BlockPos b : this.mining) {
            buf.writeBlockPos(b);
        }
        buf.writeInt(this.interaction.size());
        for (BlockPos b : this.interaction) {
            buf.writeBlockPos(b);
        }
        buf.writeInt(this.planting.size());
        for (BlockPos b : this.planting) {
            buf.writeBlockPos(b);
        }
    }

    @Override
    public ResourceLocation id() {
        return NetworkHandler.CHAIN_POSITIONS_ID;
    }

    public CustomPacketPayload.Type<?> type() {
        return NetworkHandler.CHAIN_POSITIONS_TYPE;
    }

    public static void handleOnClient(ChainPositionsPacket packet, IPayloadContext context) {
        try {
            ChainPositionStore.setChainMode(packet.playerUuid, packet.active);
            ChainPositionStore.setMiningPositions(packet.playerUuid, packet.mining);
            ChainPositionStore.setInteractionPositions(packet.playerUuid, packet.interaction);
            ChainPositionStore.setPlantingPositions(packet.playerUuid, packet.planting);
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u5904\u7406 ChainPositionsPacket \u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

