/*
 * Decompiled with CFR 0.152.
 */
package cn.onekeyminer;

import cn.onekeyminer.OKMConfig;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraftforge.common.ForgeHooks;

public class PlayerBreakEventUtils {
    public static void excavateSphere(Level world, ServerPlayer player, BlockPos centerPos, BlockState targetBlock) {
        ArrayList lootDrops = new ArrayList();
        AtomicInteger totalExpDrop = new AtomicInteger();
        LegacyRandomSource random = (LegacyRandomSource)world.getRandom();
        ItemStack mainHandItem = player.getMainHandItem();
        int maxBlocks = (Integer)OKMConfig.max_count.get();
        double dropX = player.getX();
        double dropY = player.getEyeY() - (double)player.getEyeHeight() - 0.5;
        double dropZ = player.getZ();
        if (!ForgeHooks.isCorrectToolForDrops((BlockState)targetBlock, (Player)player)) {
            return;
        }
        HashSet<BlockPos> processed = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>(List.of(centerPos));
        int count = 0;
        while (!queue.isEmpty() && count < maxBlocks) {
            BlockPos pos = (BlockPos)queue.poll();
            if (processed.contains(pos)) continue;
            processed.add(pos);
            BlockState blockState = world.getBlockState(pos);
            if (!blockState.is(targetBlock.getBlock())) continue;
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            Block block = blockState.getBlock();
            BlockEntity blockEntity = world.getBlockEntity(pos);
            List drops = Block.getDrops((BlockState)blockState, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)mainHandItem);
            lootDrops.addAll(drops);
            int expToDrop = block.getExpDrop(blockState, (LevelReader)world, (RandomSource)random, pos, 0, 0);
            totalExpDrop.addAndGet(expToDrop);
            for (Direction direction : Direction.values()) {
                BlockPos neighbor = pos.relative(direction);
                if (processed.contains(neighbor) || !world.getBlockState(neighbor).is(targetBlock.getBlock())) continue;
                queue.add(neighbor);
            }
            PlayerBreakEventUtils.damageTool(player, mainHandItem);
            if (!player.gameMode.isCreative() && ((Boolean)OKMConfig.Saturationdeduction.get()).booleanValue()) {
                PlayerBreakEventUtils.decreaseHunger(player, 0.005);
            }
            ++count;
        }
        for (ItemStack drop : lootDrops) {
            world.addFreshEntity((Entity)new ItemEntity(world, dropX, dropY, dropZ, drop));
        }
        if (totalExpDrop.get() > 0) {
            world.addFreshEntity((Entity)new ExperienceOrb(world, dropX, dropY, dropZ, totalExpDrop.get()));
        }
        player.sendSystemMessage((Component)Component.translatable((String)"message.onekeyminer.Number_of_interlocking_blocks", (Object[])new Object[]{count}));
    }

    private static void damageTool(ServerPlayer player, ItemStack itemStack) {
        if (((Boolean)OKMConfig.toolProtectionMode.get()).booleanValue() && !player.isCreative() && itemStack.isDamageableItem()) {
            double threshold = (Double)OKMConfig.toolDurabilityThreshold.get();
            int maxDamage = itemStack.getMaxDamage();
            int damage = itemStack.getDamageValue();
            double d = maxDamage - damage;
            double d2 = threshold <= 1.0 ? (double)maxDamage * threshold : threshold;
            if (d < d2) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.onekeyminer.low_durability"));
                return;
            }
            if (!player.isCreative() && itemStack.isDamageableItem()) {
                itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            }
        }
    }

    private static void decreaseHunger(ServerPlayer player, double amount) {
        FoodData foodData = player.getFoodData();
        float foodSaturationLevel = foodData.getSaturationLevel();
        int foodLevel = foodData.getFoodLevel();
        if ((double)foodLevel > (Double)OKMConfig.SaturationdeductionThreshold.get()) {
            if ((double)foodSaturationLevel >= amount) {
                foodData.setSaturation((float)((double)foodSaturationLevel - amount));
            } else {
                foodData.setSaturation(0.0f);
                int newFoodLevel = (int)Math.max((double)foodLevel - (amount -= (double)foodSaturationLevel), 0.0);
                foodData.setFoodLevel(newFoodLevel);
            }
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"message.onekeyminer.low_foodlevel"));
            throw new RuntimeException("Hunger level too low to continue chain mining.");
        }
    }
}

