/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.api;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AzaleaBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.NetherSproutsBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.RootsBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.chain.ChainHandler;
import org.xiyu.yee.onekeyminer.chain.InteractionHandler;
import org.xiyu.yee.onekeyminer.chain.PlantingHandler;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.config.ServerConfig;

public class ChainAPI {
    public static List<BlockPos> computeMiningPositions(ServerPlayer player, ServerLevel level, BlockPos startPos, BlockState startState, ItemStack tool) {
        List<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || startState == null || tool == null) {
            return result;
        }
        if (!ChainModeCapability.isChainModeActive((Player)player)) {
            return result;
        }
        if (startState.m_60795_()) {
            return result;
        }
        if (((Boolean)CommonConfig.INSTANCE.requireSneaking.get()).booleanValue() && !player.m_6144_()) {
            return result;
        }
        if (player.m_7500_() && !((Boolean)CommonConfig.INSTANCE.enableInCreative.get()).booleanValue()) {
            return result;
        }
        if (!player.m_7500_() && (double)player.m_36324_().m_38702_() < (Double)ServerConfig.INSTANCE.hungerThreshold.get()) {
            return result;
        }
        Block block = startState.m_60734_();
        if (!CommonConfig.INSTANCE.isBlockMineable(block)) {
            return result;
        }
        if (!((Boolean)CommonConfig.INSTANCE.ignoreToolCompatibility.get()).booleanValue() && !player.m_36298_(startState)) {
            return result;
        }
        if (!player.m_7500_() && tool.m_41763_()) {
            double durabilityProtection = (Double)ServerConfig.INSTANCE.toolDurabilityThreshold.get();
            if ((double)tool.m_41773_() >= (double)tool.m_41776_() - durabilityProtection) {
                return result;
            }
        }
        try {
            result = ChainHandler.computeMiningPositions(player, level, startPos, startState, tool);
        }
        catch (Throwable t) {
            BlockPos[] neighbors;
            if (level.m_8055_(startPos).m_60734_() == startState.m_60734_()) {
                result.add(startPos);
            }
            for (BlockPos neighbor : neighbors = new BlockPos[]{startPos.m_7494_(), startPos.m_7495_(), startPos.m_142127_(), startPos.m_142128_(), startPos.m_142126_(), startPos.m_142125_()}) {
                if (result.size() >= 10) break;
                if (level.m_8055_(neighbor).m_60734_() != startState.m_60734_()) continue;
                result.add(neighbor);
            }
        }
        return result;
    }

    public static List<BlockPos> computeInteractionPositions(ServerPlayer player, ServerLevel level, BlockPos startPos, BlockState targetState, InteractionHand hand) {
        List<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || targetState == null) {
            return result;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41619_()) {
            return result;
        }
        if (heldItem.m_41763_() && heldItem.m_41773_() >= heldItem.m_41776_() - 1) {
            return result;
        }
        try {
            result = InteractionHandler.computeInteractionPositions(player, level, startPos, targetState, hand);
        }
        catch (Throwable t) {
            BlockPos[] neighbors;
            if (level.m_8055_(startPos).m_60734_() == targetState.m_60734_()) {
                result.add(startPos);
            }
            for (BlockPos neighbor : neighbors = new BlockPos[]{startPos.m_7494_(), startPos.m_7495_(), startPos.m_142127_(), startPos.m_142128_(), startPos.m_142126_(), startPos.m_142125_()}) {
                if (result.size() >= 10) break;
                if (level.m_8055_(neighbor).m_60734_() != targetState.m_60734_()) continue;
                result.add(neighbor);
            }
        }
        return result;
    }

    public static List<BlockPos> computePlantingPositions(ServerPlayer player, ServerLevel level, BlockPos startPos, BlockState targetState, ItemStack seedItem) {
        List<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || seedItem == null) {
            return result;
        }
        try {
            result = PlantingHandler.computePlantingPositions(player, level, startPos, targetState, seedItem);
        }
        catch (Throwable t) {
            BlockPos[] neighbors;
            if (!ChainAPI.isPlantableItem(seedItem)) {
                return result;
            }
            if (ChainAPI.canPlantAt((Level)level, startPos, level.m_8055_(startPos), seedItem)) {
                result.add(startPos);
            }
            for (BlockPos neighbor : neighbors = new BlockPos[]{startPos.m_7494_(), startPos.m_7495_(), startPos.m_142127_(), startPos.m_142128_(), startPos.m_142126_(), startPos.m_142125_()}) {
                if (result.size() >= 10) break;
                if (!ChainAPI.canPlantAt((Level)level, neighbor, level.m_8055_(neighbor), seedItem)) continue;
                result.add(neighbor);
            }
        }
        return result;
    }

    private static boolean canPlantAt(Level level, BlockPos pos, BlockState state, ItemStack seedItem) {
        if (!level.m_46859_(pos)) {
            return false;
        }
        BlockPos below = pos.m_7495_();
        BlockState belowState = level.m_8055_(below);
        return ChainAPI.canPlantOnSurface(seedItem.m_41720_(), belowState);
    }

    private static boolean canPlantOnSurface(Item item, BlockState surfaceState) {
        if (surfaceState == null) {
            return false;
        }
        Block surfaceBlock = surfaceState.m_60734_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            if (block instanceof CropBlock) {
                return surfaceBlock == Blocks.f_50093_;
            }
            if (block instanceof SaplingBlock || block instanceof FlowerBlock) {
                return surfaceBlock == Blocks.f_50493_ || surfaceBlock == Blocks.f_50440_ || surfaceBlock == Blocks.f_50599_ || surfaceBlock == Blocks.f_50195_;
            }
            if (block instanceof MushroomBlock) {
                return surfaceBlock == Blocks.f_50195_;
            }
            if (item == Items.f_42620_ || item == Items.f_42619_ || item == Items.f_42404_ || item == Items.f_42733_) {
                return surfaceBlock == Blocks.f_50093_;
            }
        }
        return surfaceBlock == Blocks.f_50493_ || surfaceBlock == Blocks.f_50440_ || surfaceBlock == Blocks.f_50599_ || surfaceBlock == Blocks.f_49992_ || surfaceBlock == Blocks.f_50135_ || surfaceBlock == Blocks.f_50195_ || surfaceBlock instanceof FarmBlock;
    }

    private static boolean isPlantableItem(ItemStack stack) {
        BlockItem blockItem;
        Block block;
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (CommonConfig.INSTANCE.isSeedBlacklisted(item)) {
            return false;
        }
        if (item instanceof BlockItem && ((block = (blockItem = (BlockItem)item).m_40614_()) instanceof CropBlock || block instanceof SaplingBlock || block instanceof BushBlock || block instanceof FlowerBlock || block instanceof TallFlowerBlock || block instanceof CactusBlock || block instanceof TallGrassBlock || block instanceof FungusBlock || block instanceof RootsBlock || block instanceof NetherSproutsBlock || block instanceof CocoaBlock || block instanceof SugarCaneBlock || block instanceof NetherWartBlock || block instanceof AzaleaBlock)) {
            return true;
        }
        String name = item.toString().toLowerCase();
        if (name.contains("seed") || name.contains("sapling") || name.contains("seedling") || name.contains("plant")) {
            return true;
        }
        return item == Items.f_42404_ || item == Items.f_42733_ || item == Items.f_42577_ || item == Items.f_42578_ || item == Items.f_42620_ || item == Items.f_42619_ || item == Items.f_42780_ || item == Items.f_151079_ || item == Items.f_41954_ || item == Items.f_41955_ || item == Items.f_42533_ || item == Items.f_41910_ || item == Items.f_41911_ || item == Items.f_41909_ || item == Items.f_41982_ || item == Items.f_41868_;
    }
}

