/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.config.ServerConfig;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ChainHandler {
    private static final Set<BlockPos> CURRENTLY_MINING = new HashSet<BlockPos>();
    private static int XPS = 0;

    public static boolean tryChainMine(ServerPlayer player, BlockPos pos, BlockState state, ItemStack tool) {
        CURRENTLY_MINING.clear();
        if (player == null || pos == null || state == null || tool == null) {
            Onekeyminer.LOGGER.debug("\u8fde\u9501\u6316\u6398\u53c2\u6570\u65e0\u6548");
            return false;
        }
        if (!ChainHandler.validateChainMiningConditions(player, pos, state, tool)) {
            return false;
        }
        String blockId = state.m_60734_().m_7705_();
        String blockName = state.m_60734_().m_49954_().getString();
        int blocksMined = ChainHandler.performChainMining(player, pos, state, tool);
        if (blocksMined > 0) {
            ChainHandler.sendFeedback(player, blocksMined);
        }
        return blocksMined > 0;
    }

    public static List<BlockPos> computeMiningPositions(ServerPlayer player, ServerLevel level, BlockPos startPos, BlockState startState, ItemStack tool) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || startState == null || tool == null) {
            return result;
        }
        int maxBlocks = player.m_7500_() ? (Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        int maxDepth = (Integer)CommonConfig.INSTANCE.maxChainDepth.get();
        boolean diagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        boolean matchFullState = (Boolean)CommonConfig.INSTANCE.matchBlockState.get();
        boolean matchseedState = (Boolean)CommonConfig.INSTANCE.matchseedBlockState.get();
        LinkedList<BlockPos> toMine = new LinkedList<BlockPos>();
        LinkedHashSet<BlockPos> minedPositions = new LinkedHashSet<BlockPos>();
        toMine.add(startPos);
        long startTime = System.currentTimeMillis();
        long timeLimit = 300L;
        int maxIterations = Math.min(5000, maxBlocks * 8);
        int iterations = 0;
        try {
            while (!toMine.isEmpty() && result.size() < maxBlocks && iterations < maxIterations && System.currentTimeMillis() - startTime <= 300L) {
                BlockState currentState;
                ++iterations;
                BlockPos currentPos = (BlockPos)toMine.poll();
                if (minedPositions.contains(currentPos) || Math.abs(currentPos.m_123342_() - startPos.m_123342_()) > maxDepth || !ChainHandler.isBlockMatching(startState, currentState = level.m_8055_(currentPos), matchFullState, matchseedState)) continue;
                minedPositions.add(currentPos);
                result.add(currentPos);
                for (BlockPos neighbor : ChainHandler.getNeighborPositions(currentPos, diagonal)) {
                    if (minedPositions.contains(neighbor) || toMine.size() >= maxBlocks - result.size()) continue;
                    toMine.add(neighbor);
                }
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8ba1\u7b97\u8fde\u9501\u6316\u6398\u4f4d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    private static boolean validateChainMiningConditions(ServerPlayer player, BlockPos pos, BlockState state, ItemStack tool) {
        if (!ChainModeCapability.isChainModeActive((Player)player)) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u8fde\u9501\u6a21\u5f0f\u672a\u542f\u7528");
            }
            return false;
        }
        if (state.m_60795_()) {
            return false;
        }
        if (((Boolean)CommonConfig.INSTANCE.requireSneaking.get()).booleanValue() && !player.m_6144_()) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u9700\u8981\u4e0b\u8e72\u4f46\u73a9\u5bb6\u672a\u4e0b\u8e72");
            }
            return false;
        }
        if (player.m_7500_() && !((Boolean)CommonConfig.INSTANCE.enableInCreative.get()).booleanValue()) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u521b\u9020\u6a21\u5f0f\u4e0b\u8fde\u9501\u6316\u6398\u672a\u542f\u7528");
            }
            return false;
        }
        if (!player.m_7500_() && (double)player.m_36324_().m_38702_() < (Double)ServerConfig.INSTANCE.hungerThreshold.get()) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u73a9\u5bb6\u9965\u997f\u5ea6\u4e0d\u8db3: {} < {}", (Object)player.m_36324_().m_38702_(), ServerConfig.INSTANCE.hungerThreshold.get());
            }
            return false;
        }
        Block blockId = state.m_60734_();
        String blockName = state.m_60734_().m_49954_().getString();
        if (!CommonConfig.INSTANCE.isBlockMineable(blockId)) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u65b9\u5757\u5728\u4e0d\u53ef\u6316\u6398\u5217\u8868\u4e2d: {} (\u5185\u90e8ID: {})", (Object)blockName, (Object)blockId);
            }
            return false;
        }
        if (!((Boolean)CommonConfig.INSTANCE.ignoreToolCompatibility.get()).booleanValue() && !player.m_36298_(state)) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u5de5\u5177\u4e0d\u517c\u5bb9: {}", (Object)tool.m_41720_().m_5524_());
            }
            return false;
        }
        if (!player.m_7500_() && tool.m_41763_()) {
            Double durabilityProtection = (Double)ServerConfig.INSTANCE.toolDurabilityThreshold.get();
            if ((double)tool.m_41773_() >= (double)tool.m_41776_() - durabilityProtection) {
                if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u5de5\u5177\u8010\u4e45\u5ea6\u4e0d\u8db3\u8fdb\u884c\u8fde\u9501\u6316\u6398");
                }
                return false;
            }
        }
        return true;
    }

    private static int performChainMining(ServerPlayer player, BlockPos startPos, BlockState startState, ItemStack tool) {
        Level level = player.f_19853_;
        ServerLevel serverLevel = (ServerLevel)level;
        int maxBlocks = player.m_7500_() ? (Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        int maxDepth = (Integer)CommonConfig.INSTANCE.maxChainDepth.get();
        boolean diagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        boolean matchFullState = (Boolean)CommonConfig.INSTANCE.matchBlockState.get();
        boolean matchseedState = (Boolean)CommonConfig.INSTANCE.matchseedBlockState.get();
        boolean teleportDrops = (Boolean)CommonConfig.INSTANCE.teleportDropsToPlayer.get();
        LinkedList<BlockPos> toMine = new LinkedList<BlockPos>();
        LinkedHashSet<BlockPos> minedPositions = new LinkedHashSet<BlockPos>();
        toMine.add(startPos);
        int blocksMined = 0;
        XPS = 0;
        while (!toMine.isEmpty() && blocksMined < maxBlocks) {
            boolean blockDestroyed;
            BlockState currentState;
            BlockPos currentPos = (BlockPos)toMine.poll();
            if (minedPositions.contains(currentPos) || Math.abs(currentPos.m_123342_() - startPos.m_123342_()) > maxDepth || !ChainHandler.isBlockMatching(startState, currentState = level.m_8055_(currentPos), matchFullState, matchseedState)) continue;
            minedPositions.add(currentPos);
            if (teleportDrops) {
                blockDestroyed = ChainHandler.breakBlockWithTeleport(serverLevel, currentPos, currentState, player, tool);
            } else {
                BlockEntity blockEntity = level.m_7702_(currentPos);
                LootContext.Builder builder = new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)currentPos)).m_78972_(LootContextParams.f_81463_, (Object)tool).m_78984_(LootContextParams.f_81455_, (Object)player).m_78984_(LootContextParams.f_81462_, (Object)blockEntity);
                List drops = currentState.m_60724_(builder);
                boolean hasSilkTouch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0;
                int xp = 0;
                int fortuneLevel = 0;
                xp = currentState.m_60734_().getExpDrop(currentState, (LevelReader)level, currentPos, fortuneLevel, hasSilkTouch ? 1 : 0);
                blockDestroyed = serverLevel.m_46953_(currentPos, false, (Entity)player);
                if (!blockDestroyed) continue;
                for (ItemStack itemStack : drops) {
                    if (itemStack.m_41619_()) continue;
                    Block.m_49840_((Level)level, (BlockPos)currentPos, (ItemStack)itemStack);
                }
                if (xp > 0) {
                    ExperienceOrb orb = new ExperienceOrb(level, (double)currentPos.m_123341_() + 0.5, (double)currentPos.m_123342_() + 0.5, (double)currentPos.m_123343_() + 0.5, xp);
                    level.m_7967_((Entity)orb);
                }
                level.m_5594_(null, currentPos, currentState.m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_() && tool.m_41763_()) {
                    tool.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
                    if (tool.m_41619_()) break;
                }
            }
            if (!blockDestroyed) continue;
            ++blocksMined;
            for (BlockPos neighbor : ChainHandler.getNeighborPositions(currentPos, diagonal)) {
                if (minedPositions.contains(neighbor) || toMine.size() >= maxBlocks - blocksMined) continue;
                toMine.add(neighbor);
            }
        }
        if (teleportDrops && XPS > 0) {
            BlockPos dropPos = player.m_142538_();
            ExperienceOrb orb = new ExperienceOrb(level, (double)dropPos.m_123341_() + 0.5, (double)dropPos.m_123342_() + 0.5, (double)dropPos.m_123343_() + 0.5, XPS);
            level.m_7967_((Entity)orb);
            XPS = 0;
        }
        return blocksMined;
    }

    private static boolean isBlockMatching(BlockState reference, BlockState target, boolean matchFullState, boolean matchSeedState) {
        if (target.m_60795_()) {
            return false;
        }
        if (matchFullState && !(target.m_60734_() instanceof CropBlock) || matchSeedState && target.m_60734_() instanceof CropBlock) {
            return reference.equals(target);
        }
        if (reference.m_60734_() == target.m_60734_()) {
            if (ChainHandler.hasSpecialMatchingRules(reference.m_60734_())) {
                return ChainHandler.matchSpecialBlockProperties(reference, target);
            }
            return true;
        }
        return false;
    }

    private static boolean hasSpecialMatchingRules(Block block) {
        String blockId = block.m_7705_();
        return blockId.contains("ore") || blockId.contains("log") || blockId.contains("wood") || blockId.contains("leaves");
    }

    private static boolean matchSpecialBlockProperties(BlockState reference, BlockState target) {
        if (reference.m_60734_().m_7705_().contains("ore")) {
            return true;
        }
        if (reference.m_60734_().m_7705_().contains("log") || reference.m_60734_().m_7705_().contains("wood")) {
            String refType = ChainHandler.extractWoodType(reference.m_60734_().m_7705_());
            String targetType = ChainHandler.extractWoodType(target.m_60734_().m_7705_());
            return refType.equals(targetType);
        }
        if (reference.m_60734_().m_7705_().contains("leaves")) {
            String refType = ChainHandler.extractWoodType(reference.m_60734_().m_7705_());
            String targetType = ChainHandler.extractWoodType(target.m_60734_().m_7705_());
            return refType.equals(targetType);
        }
        return true;
    }

    private static String extractWoodType(String blockId) {
        for (String woodType : new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "crimson", "warped", "mangrove", "cherry"}) {
            if (!blockId.contains(woodType)) continue;
            return woodType;
        }
        return blockId;
    }

    private static boolean breakBlockWithTeleport(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player, ItemStack tool) {
        if (level == null || player == null) {
            return false;
        }
        BlockPos dropPos = player.m_142538_();
        try {
            BlockEntity blockEntity = level.m_7702_(pos);
            LootContext.Builder builder = new LootContext.Builder(level).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)tool).m_78984_(LootContextParams.f_81455_, (Object)player).m_78984_(LootContextParams.f_81462_, (Object)blockEntity);
            List drops = state.m_60724_(builder);
            boolean hasSilkTouch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0;
            int xp = 0;
            int fortuneLevel = 0;
            xp = state.m_60734_().getExpDrop(state, (LevelReader)level, pos, fortuneLevel, hasSilkTouch ? 1 : 0);
            boolean broken = level.m_46953_(pos, false, (Entity)player);
            if (!broken) {
                return false;
            }
            for (ItemStack itemStack : drops) {
                if (itemStack.m_41619_()) continue;
                Block.m_49840_((Level)level, (BlockPos)dropPos, (ItemStack)itemStack);
            }
            if (xp > 0 && !hasSilkTouch) {
                XPS += xp;
            }
            level.m_5594_(null, pos, state.m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_7500_() && tool.m_41763_()) {
                tool.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
                if (tool.m_41619_()) {
                    return true;
                }
            }
            return true;
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u4f20\u9001\u6389\u843d\u7269\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static List<BlockPos> getNeighborPositions(BlockPos pos, boolean includeDiagonal) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>(14);
        neighbors.add(pos.m_7494_());
        neighbors.add(pos.m_7495_());
        neighbors.add(pos.m_142127_());
        neighbors.add(pos.m_142128_());
        neighbors.add(pos.m_142126_());
        neighbors.add(pos.m_142125_());
        if (includeDiagonal) {
            neighbors.add(pos.m_142127_().m_142126_());
            neighbors.add(pos.m_142127_().m_142125_());
            neighbors.add(pos.m_142128_().m_142126_());
            neighbors.add(pos.m_142128_().m_142125_());
            neighbors.add(pos.m_7494_().m_142127_());
            neighbors.add(pos.m_7494_().m_142128_());
            neighbors.add(pos.m_7494_().m_142126_());
            neighbors.add(pos.m_7494_().m_142125_());
            neighbors.add(pos.m_7495_().m_142127_());
            neighbors.add(pos.m_7495_().m_142128_());
            neighbors.add(pos.m_7495_().m_142126_());
            neighbors.add(pos.m_7495_().m_142125_());
            neighbors.add(pos.m_7494_().m_142127_().m_142126_());
            neighbors.add(pos.m_7494_().m_142127_().m_142125_());
            neighbors.add(pos.m_7494_().m_142128_().m_142126_());
            neighbors.add(pos.m_7494_().m_142128_().m_142125_());
            neighbors.add(pos.m_7495_().m_142127_().m_142126_());
            neighbors.add(pos.m_7495_().m_142127_().m_142125_());
            neighbors.add(pos.m_7495_().m_142128_().m_142126_());
            neighbors.add(pos.m_7495_().m_142128_().m_142125_());
        }
        return neighbors;
    }

    private static void sendFeedback(ServerPlayer player, int blocksMined) {
        NetworkHandler.sendToPlayer(new ChainActionPacket("mining", blocksMined), player);
    }
}

