/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.api.ChainPositionStore;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class InteractionHandler {
    private static final Set<BlockPos> PROCESSED_POSITIONS = new HashSet<BlockPos>();
    private static final Set<Integer> PROCESSED_ENTITY_IDS = new HashSet<Integer>();

    public static boolean isValidInteractionTool(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        return item instanceof HoeItem || item instanceof AxeItem || item instanceof ShovelItem || item instanceof ShearsItem;
    }

    public static List<BlockPos> computeInteractionPositions(ServerPlayer player, ServerLevel level, BlockPos startPos, BlockState targetState, InteractionHand hand) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || targetState == null) {
            return result;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41619_() || !InteractionHandler.isValidInteractionTool(heldItem)) {
            return result;
        }
        if (targetState.m_60795_()) {
            return result;
        }
        int maxBlocks = player.m_7500_() ? (Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        int maxDepth = (Integer)CommonConfig.INSTANCE.maxChainDepth.get();
        boolean includeDiagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        LinkedList<BlockSearchNode> queue = new LinkedList<BlockSearchNode>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(new BlockSearchNode(startPos, 0));
        long startTime = System.currentTimeMillis();
        long timeLimit = 300L;
        int maxIterations = Math.min(5000, maxBlocks * 8);
        int iterations = 0;
        try {
            while (!queue.isEmpty() && result.size() < maxBlocks && iterations < maxIterations && System.currentTimeMillis() - startTime <= 300L) {
                ++iterations;
                BlockSearchNode node = (BlockSearchNode)queue.poll();
                BlockPos pos = node.pos;
                if (node.depth > maxDepth || visited.contains(pos)) continue;
                visited.add(pos);
                BlockState state = level.m_8055_(pos);
                if (!InteractionHandler.isMatchingBlock(state, targetState)) continue;
                result.add(pos);
                for (BlockPos neighbor : InteractionHandler.getNeighborPositions(pos, includeDiagonal)) {
                    if (visited.contains(neighbor)) continue;
                    queue.offer(new BlockSearchNode(neighbor, node.depth + 1));
                }
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8ba1\u7b97\u8fde\u9501\u4ea4\u4e92\u4f4d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    @Deprecated
    public static void handleChainInteraction(ServerPlayer player, PlayerInteractEvent.RightClickBlock event) {
        InteractionHandler.tryChainInteraction(player, (ServerLevel)event.getWorld(), event.getPos(), event.getFace(), event.getHitVec().m_82450_(), event.getHand());
    }

    public static boolean tryChainInteraction(ServerPlayer player, ServerLevel level, BlockPos pos, Direction side, Vec3 hitVec, InteractionHand hand) {
        PROCESSED_POSITIONS.clear();
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41619_() || !InteractionHandler.isValidInteractionTool(heldItem)) {
            return false;
        }
        BlockState initialState = level.m_8055_(pos);
        if (initialState.m_60795_()) {
            return false;
        }
        if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u5c1d\u8bd5\u8fde\u9501\u4ea4\u4e92: {}", (Object)initialState.m_60734_().m_7705_());
        }
        BlockHitResult initialHit = new BlockHitResult(hitVec, side, pos, false);
        int maxBlocks = player.m_7500_() ? (Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        boolean includeDiagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        int processedCount = InteractionHandler.floodFillInteraction(player, level, initialState, initialHit, hand, maxBlocks, (Integer)CommonConfig.INSTANCE.maxChainDepth.get(), includeDiagonal);
        if (processedCount > 0) {
            NetworkHandler.sendToPlayer(new ChainActionPacket("interaction", processedCount), player);
            return true;
        }
        return false;
    }

    private static int floodFillInteraction(ServerPlayer player, ServerLevel level, BlockState targetState, BlockHitResult initialHit, InteractionHand hand, int maxBlocks, int maxDepth, boolean includeDiagonal) {
        LinkedList<BlockSearchNode> queue = new LinkedList<BlockSearchNode>();
        queue.add(new BlockSearchNode(initialHit.m_82425_(), 0));
        int processedCount = 0;
        ItemStack heldItem = player.m_21120_(hand);
        while (!queue.isEmpty() && processedCount < maxBlocks) {
            BlockState state;
            BlockSearchNode node = (BlockSearchNode)queue.poll();
            BlockPos pos = node.pos;
            if (node.depth > maxDepth || PROCESSED_POSITIONS.contains(pos) || !InteractionHandler.isMatchingBlock(state = level.m_8055_(pos), targetState)) continue;
            if (heldItem.m_41619_() || heldItem.m_41773_() >= heldItem.m_41776_() - 1) break;
            PROCESSED_POSITIONS.add(pos);
            BlockHitResult hit = new BlockHitResult(initialHit.m_82450_(), initialHit.m_82434_(), pos, false);
            UseOnContext context = new UseOnContext((Player)player, hand, hit);
            InteractionResult result = heldItem.m_41661_(context);
            if (result.m_19077_()) {
                ++processedCount;
                if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u8fde\u9501\u4ea4\u4e92\u6210\u529f: {}", (Object)pos);
                }
            }
            for (BlockPos neighbor : InteractionHandler.getNeighborPositions(pos, includeDiagonal)) {
                queue.offer(new BlockSearchNode(neighbor, node.depth + 1));
            }
        }
        Onekeyminer.LOGGER.debug("\u8fde\u9501\u4ea4\u4e92\u5b8c\u6210\uff0c\u5171\u5904\u7406 {} \u4e2a\u65b9\u5757", (Object)processedCount);
        return processedCount;
    }

    private static boolean isMatchingBlock(BlockState state, BlockState target) {
        if (state.m_60795_() || target.m_60795_()) {
            return false;
        }
        if (((Boolean)CommonConfig.INSTANCE.matchBlockState.get()).booleanValue() && !(target.m_60734_() instanceof CropBlock) || ((Boolean)CommonConfig.INSTANCE.matchseedBlockState.get()).booleanValue() && target.m_60734_() instanceof CropBlock) {
            return state.equals(target);
        }
        return state.m_60734_() == target.m_60734_();
    }

    private static List<BlockPos> getNeighborPositions(BlockPos pos, boolean includeDiagonal) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        neighbors.add(pos.m_7494_());
        neighbors.add(pos.m_7495_());
        neighbors.add(pos.m_142127_());
        neighbors.add(pos.m_142128_());
        neighbors.add(pos.m_142126_());
        neighbors.add(pos.m_142125_());
        if (includeDiagonal) {
            neighbors.add(pos.m_142127_().m_142126_());
            neighbors.add(pos.m_142127_().m_142125_());
            neighbors.add(pos.m_142128_().m_142126_());
            neighbors.add(pos.m_142128_().m_142125_());
            neighbors.add(pos.m_7494_().m_142127_());
            neighbors.add(pos.m_7494_().m_142128_());
            neighbors.add(pos.m_7494_().m_142126_());
            neighbors.add(pos.m_7494_().m_142125_());
            neighbors.add(pos.m_7495_().m_142127_());
            neighbors.add(pos.m_7495_().m_142128_());
            neighbors.add(pos.m_7495_().m_142126_());
            neighbors.add(pos.m_7495_().m_142125_());
            neighbors.add(pos.m_7494_().m_142127_().m_142126_());
            neighbors.add(pos.m_7494_().m_142127_().m_142125_());
            neighbors.add(pos.m_7494_().m_142128_().m_142126_());
            neighbors.add(pos.m_7494_().m_142128_().m_142125_());
            neighbors.add(pos.m_7495_().m_142127_().m_142126_());
            neighbors.add(pos.m_7495_().m_142127_().m_142125_());
            neighbors.add(pos.m_7495_().m_142128_().m_142126_());
            neighbors.add(pos.m_7495_().m_142128_().m_142125_());
        }
        return neighbors;
    }

    public static boolean tryChainShearing(ServerPlayer player, Sheep targetSheep, InteractionHand hand) {
        PROCESSED_ENTITY_IDS.clear();
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41619_() || !(heldItem.m_41720_() instanceof ShearsItem)) {
            return false;
        }
        if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u5c1d\u8bd5\u8fde\u9501\u526a\u7f8a\u6bdb: {}", (Object)targetSheep.m_142049_());
        }
        int maxEntities = player.m_7500_() ? (Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        double searchRadius = (double)((Integer)CommonConfig.INSTANCE.maxChainDepth.get()).intValue() * 0.5;
        if (((Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get()).booleanValue()) {
            searchRadius *= 1.5;
        }
        PROCESSED_ENTITY_IDS.add(targetSheep.m_142049_());
        boolean teleportDrops = (Boolean)CommonConfig.INSTANCE.teleportDropsToPlayer.get();
        BlockPos playerPos = player.m_142538_();
        ServerLevel level = (ServerLevel)player.f_19853_;
        AABB searchBox = new AABB(targetSheep.m_20185_() - searchRadius, targetSheep.m_20186_() - searchRadius, targetSheep.m_20189_() - searchRadius, targetSheep.m_20185_() + searchRadius, targetSheep.m_20186_() + searchRadius, targetSheep.m_20189_() + searchRadius);
        List allSheepInArea = level.m_6443_(Sheep.class, searchBox, sheep -> sheep.m_6084_() && sheep.m_6220_() && !PROCESSED_ENTITY_IDS.contains(sheep.m_142049_()));
        if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u627e\u5230 {} \u53ea\u53ef\u526a\u7f8a", (Object)(allSheepInArea.size() + 1));
        }
        int shearedCount = 1;
        ArrayList<UUID> shearingUuids = new ArrayList<UUID>();
        shearingUuids.add(targetSheep.m_142081_());
        for (Sheep s : allSheepInArea) {
            shearingUuids.add(s.m_142081_());
        }
        try {
            String key = player.m_142081_().toString();
            ChainPositionStore.setShearingEntityUuids(key, shearingUuids);
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.debug("\u5199\u5165\u526a\u7f8a UUID \u5217\u8868\u5230 ChainPositionStore \u65f6\u51fa\u9519: {}", (Object)e.getMessage());
        }
        for (Sheep sheep2 : allSheepInArea) {
            if (shearedCount >= maxEntities) break;
            try {
                if (!sheep2.isShearable(heldItem, player.f_19853_, sheep2.m_142538_()) || !sheep2.m_6220_()) continue;
                boolean wasShearable = sheep2.m_6220_();
                int woolColorBefore = sheep2.m_29874_().m_41060_();
                boolean shearingSuccessful = false;
                if (teleportDrops) {
                    double originalX = sheep2.m_20185_();
                    double originalY = sheep2.m_20186_();
                    double originalZ = sheep2.m_20189_();
                    try {
                        sheep2.m_6034_((double)playerPos.m_123341_(), (double)playerPos.m_123342_(), (double)playerPos.m_123343_());
                        if (sheep2.m_6220_()) {
                            List items = sheep2.onSheared((Player)player, heldItem, (Level)level, sheep2.m_142538_(), 1);
                            boolean bl = shearingSuccessful = !items.isEmpty();
                            if (shearingSuccessful && !player.m_150110_().f_35937_) {
                                heldItem.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(player.m_21205_().getEquipmentSlot()));
                            }
                            items.forEach(itemStack -> {
                                ItemEntity itemEntity = new ItemEntity((Level)level, sheep2.m_20185_(), sheep2.m_20227_(1.0), sheep2.m_20189_(), itemStack);
                                level.m_7967_((Entity)itemEntity);
                            });
                            if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                                Onekeyminer.LOGGER.debug("\u526a\u7f8a\u72b6\u6001: \u4f7f\u7528onSheared\u65b9\u6cd5={}, \u6389\u843d\u7269\u6570\u91cf={}", (Object)true, (Object)items.size());
                            }
                        }
                        sheep2.m_6034_(originalX, originalY, originalZ);
                    }
                    catch (Exception e) {
                        Onekeyminer.LOGGER.error("\u4f20\u9001\u7f8a\u6bdb\u6389\u843d\u7269\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
                        sheep2.m_6034_(originalX, originalY, originalZ);
                    }
                } else if (sheep2.m_6220_()) {
                    List items = sheep2.onSheared((Player)player, heldItem, (Level)level, sheep2.m_142538_(), 1);
                    boolean bl = shearingSuccessful = !items.isEmpty();
                    if (shearingSuccessful && !player.m_150110_().f_35937_) {
                        heldItem.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(player.m_21205_().getEquipmentSlot()));
                    }
                    items.forEach(itemStack -> {
                        ItemEntity itemEntity = new ItemEntity((Level)level, sheep2.m_20185_(), sheep2.m_20227_(1.0), sheep2.m_20189_(), itemStack);
                        level.m_7967_((Entity)itemEntity);
                    });
                    if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                        Onekeyminer.LOGGER.debug("\u526a\u7f8a\u72b6\u6001: \u4f7f\u7528onSheared\u65b9\u6cd5={}, \u6389\u843d\u7269\u6570\u91cf={}", (Object)true, (Object)items.size());
                    }
                }
                if (shearingSuccessful) {
                    PROCESSED_ENTITY_IDS.add(sheep2.m_142049_());
                    ++shearedCount;
                    if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                        Onekeyminer.LOGGER.debug("\u6210\u529f\u526a\u4e86\u7f8a {}", (Object)sheep2.m_142049_());
                    }
                    if (!heldItem.m_41619_()) continue;
                    break;
                }
                if (!((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) continue;
                Onekeyminer.LOGGER.debug("\u526a\u7f8a {} \u5931\u8d25\uff0c\u5c3d\u7ba1\u5b83\u5e94\u8be5\u662f\u53ef\u526a\u7684", (Object)sheep2.m_142049_());
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.error("\u5904\u7406\u7f8a {} \u65f6\u51fa\u9519: {}", (Object)sheep2.m_142049_(), (Object)e.getMessage());
            }
        }
        if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u6210\u529f\u526a\u4e86 {} \u53ea\u7f8a", (Object)shearedCount);
        }
        if (shearedCount > 1 && ((Boolean)ClientConfig.INSTANCE.showBlockCount.get()).booleanValue()) {
            String messageStyle = (String)ClientConfig.INSTANCE.messageStyle.get();
            if (messageStyle.equals("chat") || messageStyle.equals("both")) {
                player.m_6352_((Component)new TranslatableComponent("message.onekeyminer.chain_shearing", new Object[]{shearedCount}), player.m_142081_());
            }
            if (messageStyle.equals("actionbar") || messageStyle.equals("both")) {
                NetworkHandler.sendToPlayer(new ChainActionPacket("shearing", shearedCount), player);
            }
            return true;
        }
        return shearedCount > 1;
    }

    private static class BlockSearchNode {
        final BlockPos pos;
        final int depth;

        BlockSearchNode(BlockPos pos, int depth) {
            this.pos = pos;
            this.depth = depth;
        }
    }
}

