/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.client.ClientPacketHandler;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ChainActionPacket
implements IOneKeyPacket {
    private final String actionType;
    private final int count;

    public ChainActionPacket(String actionType, int count) {
        this.actionType = actionType;
        this.count = count;
    }

    public String getActionType() {
        return this.actionType;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public ResourceLocation id() {
        return NetworkHandler.CHAIN_ACTION_ID;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.actionType);
        buffer.writeInt(this.count);
    }

    public static ChainActionPacket fromNetwork(FriendlyByteBuf buffer) {
        String actionType = buffer.m_130277_();
        int count = buffer.readInt();
        return new ChainActionPacket(actionType, count);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleOnClient(ChainActionPacket packet, NetworkEvent.Context context) {
        if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("ChainActionPacket.handleOnClient \u88ab\u8c03\u7528");
        }
        context.enqueueWork(() -> {
            try {
                ClientPacketHandler.handleChainActionPacket(packet);
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.error("\u5904\u7406\u8fde\u9501\u6d88\u606f\u6570\u636e\u5305\u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
            }
        });
        context.setPacketHandled(true);
    }
}

