/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.api.ChainAPI;
import org.xiyu.yee.onekeyminer.api.ChainPositionStore;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.network.ChainPositionsPacket;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ChainModePacket
implements IOneKeyPacket {
    private final boolean active;

    public ChainModePacket(boolean active) {
        this.active = active;
    }

    public static ChainModePacket fromNetwork(FriendlyByteBuf buf) {
        return new ChainModePacket(buf.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.active);
    }

    @Override
    public ResourceLocation id() {
        return NetworkHandler.CHAIN_MODE_ID;
    }

    @Override
    public Object type() {
        return NetworkHandler.CHAIN_MODE_TYPE;
    }

    public static void handleOnServer(ChainModePacket packet, NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            ChainModeCapability.setChainMode(serverPlayer, packet.active);
            try {
                String key = serverPlayer.m_142081_().toString();
                if (packet.active) {
                    HitResult hr = serverPlayer.m_19907_(6.0, 0.0f, false);
                    if (hr != null && hr.m_6662_() == HitResult.Type.BLOCK) {
                        BlockHitResult bhr = (BlockHitResult)hr;
                        BlockPos pos = bhr.m_82425_();
                        BlockState state = serverPlayer.f_19853_.m_8055_(pos);
                        ItemStack held = serverPlayer.m_21120_(InteractionHand.MAIN_HAND);
                        List<BlockPos> mining = ChainAPI.computeMiningPositions(serverPlayer, (ServerLevel)serverPlayer.f_19853_, pos, state, held);
                        ChainPositionStore.setMiningPositions(key, mining);
                        List<BlockPos> interaction = ChainAPI.computeInteractionPositions(serverPlayer, (ServerLevel)serverPlayer.f_19853_, pos, state, InteractionHand.MAIN_HAND);
                        ChainPositionStore.setInteractionPositions(key, interaction);
                        List<BlockPos> planting = ChainAPI.computePlantingPositions(serverPlayer, (ServerLevel)serverPlayer.f_19853_, pos, state, held);
                        ChainPositionStore.setPlantingPositions(key, planting);
                        ChainPositionsPacket sync = new ChainPositionsPacket(key, true, mining, interaction, planting);
                        NetworkHandler.sendToPlayer(sync, serverPlayer);
                    }
                } else {
                    ChainPositionStore.clearAll(key);
                    ChainPositionsPacket sync = new ChainPositionsPacket(key, false, null, null, null);
                    NetworkHandler.sendToPlayer(sync, serverPlayer);
                }
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.error("\u5904\u7406 ChainModePacket \u65f6\u8ba1\u7b97 positions \u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleOnClient(ChainModePacket packet, NetworkEvent.Context context) {
        Minecraft minecraft = Minecraft.m_91087_();
        context.enqueueWork(() -> {
            if (minecraft.f_91074_ == null) {
                return;
            }
            minecraft.f_91074_.m_5661_((Component)new TranslatableComponent(packet.active ? "message.onekeyminer.chain_mode_on" : "message.onekeyminer.chain_mode_off"), true);
        });
        context.setPacketHandled(true);
    }
}

