/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.network;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.network.BlocksMinedPacket;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.ChainModePacket;
import org.xiyu.yee.onekeyminer.network.ChainPositionsPacket;
import org.xiyu.yee.onekeyminer.network.ConfigSyncPacket;
import org.xiyu.yee.onekeyminer.network.IOneKeyPacket;

@Mod.EventBusSubscriber(modid="onekeyminer", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NetworkHandler {
    public static final ResourceLocation CHAIN_MODE_ID = new ResourceLocation("onekeyminer", "chain_mode");
    public static final ResourceLocation BLOCKS_MINED_ID = new ResourceLocation("onekeyminer", "blocks_mined");
    public static final ResourceLocation CHAIN_ACTION_ID = new ResourceLocation("onekeyminer", "chain_action");
    public static final ResourceLocation CONFIG_SYNC_ID = new ResourceLocation("onekeyminer", "config_sync");
    public static final ResourceLocation CHAIN_POSITIONS_ID = new ResourceLocation("onekeyminer", "chain_positions");
    public static final Object CHAIN_MODE_TYPE = CHAIN_MODE_ID;
    public static final Object BLOCKS_MINED_TYPE = BLOCKS_MINED_ID;
    public static final Object CHAIN_ACTION_TYPE = CHAIN_ACTION_ID;
    public static final Object CONFIG_SYNC_TYPE = CONFIG_SYNC_ID;
    public static final Object CHAIN_POSITIONS_TYPE = CHAIN_POSITIONS_ID;
    private static final String PROTOCOL_VERSION = "1.0.0";
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("onekeyminer", "main"), () -> "1.0.0", "1.0.0"::equals, "1.0.0"::equals);
    private static int packetIndex = 0;
    private static boolean registered = false;

    @SubscribeEvent
    public static void registerPayloads(FMLCommonSetupEvent event) {
        if (registered) {
            return;
        }
        event.enqueueWork(() -> {
            if (registered) {
                return;
            }
            registered = true;
            CHANNEL.registerMessage(packetIndex++, ChainModePacket.class, (packet, buf) -> packet.write((FriendlyByteBuf)buf), ChainModePacket::fromNetwork, (packet, ctxSupplier) -> ChainModePacket.handleOnServer(packet, (NetworkEvent.Context)ctxSupplier.get()), Optional.of(NetworkDirection.PLAY_TO_SERVER));
            CHANNEL.registerMessage(packetIndex++, BlocksMinedPacket.class, (packet, buf) -> packet.write((FriendlyByteBuf)buf), BlocksMinedPacket::fromNetwork, (packet, ctxSupplier) -> BlocksMinedPacket.handleOnClient(packet, (NetworkEvent.Context)ctxSupplier.get()), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
            CHANNEL.registerMessage(packetIndex++, ChainActionPacket.class, (packet, buf) -> packet.write((FriendlyByteBuf)buf), ChainActionPacket::fromNetwork, (packet, ctxSupplier) -> ChainActionPacket.handleOnClient(packet, (NetworkEvent.Context)ctxSupplier.get()), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
            CHANNEL.registerMessage(packetIndex++, ConfigSyncPacket.class, (packet, buf) -> packet.write((FriendlyByteBuf)buf), ConfigSyncPacket::fromNetwork, (packet, ctxSupplier) -> ConfigSyncPacket.handleOnClient(packet, (NetworkEvent.Context)ctxSupplier.get()), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
            CHANNEL.registerMessage(packetIndex++, ChainPositionsPacket.class, (packet, buf) -> packet.write((FriendlyByteBuf)buf), ChainPositionsPacket::fromNetwork, (packet, ctxSupplier) -> ChainPositionsPacket.handleOnClient(packet, (NetworkEvent.Context)ctxSupplier.get()), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        });
    }

    public static void sendToPlayer(IOneKeyPacket packet, ServerPlayer player) {
        try {
            if (player != null) {
                if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u5411\u73a9\u5bb6 {} \u53d1\u9001\u6570\u636e\u5305: {}", (Object)player.m_6302_(), (Object)packet.getClass().getSimpleName());
                }
                CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
            } else if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.warn("\u65e0\u6cd5\u53d1\u9001\u6570\u636e\u5305: \u73a9\u5bb6\u6216\u8fde\u63a5\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u53d1\u9001\u6570\u636e\u5305\u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void sendToServer(IOneKeyPacket packet) {
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection != null) {
            CHANNEL.sendToServer((Object)packet);
        } else if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
            Onekeyminer.LOGGER.warn("\u65e0\u6cd5\u53d1\u9001\u5230\u670d\u52a1\u5668\uff1a\u5ba2\u6237\u7aef\u8fde\u63a5\u4e3a\u7a7a");
        }
    }
}

