/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="onekeyminer")
public class UpdateChecker {
    private static final String PROJECT_ID = "LZu4H9cp";
    private static final String API_URL = "https://api.modrinth.com/v2/project/LZu4H9cp/version";
    private static String latestVersion = null;
    private static boolean checked = false;
    private static final boolean ALLOW_MAJOR_MATCH = false;

    private static void fetchLatestVersion() {
        if (checked) {
            return;
        }
        checked = true;
        CompletableFuture.runAsync(() -> {
            try {
                String mcVersion = SharedConstants.getCurrentVersion().getName();
                String loader = UpdateChecker.detectLoader();
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest req = HttpRequest.newBuilder().uri(URI.create(API_URL)).build();
                HttpResponse<String> res = client.send(req, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
                JsonArray root = JsonParser.parseString((String)res.body()).getAsJsonArray();
                String bestVersion = null;
                String publishedDate = null;
                for (JsonElement elem : root) {
                    Object v2;
                    JsonObject file = elem.getAsJsonObject();
                    JsonArray gameVersions = file.getAsJsonArray("game_versions");
                    JsonArray loaders = file.getAsJsonArray("loaders");
                    boolean supportsGame = false;
                    for (Object v2 : gameVersions) {
                        String supported = v2.getAsString();
                        if (!mcVersion.equals(supported)) continue;
                        supportsGame = true;
                        break;
                    }
                    boolean supportsLoader = false;
                    v2 = loaders.iterator();
                    while (v2.hasNext()) {
                        JsonElement l = (JsonElement)v2.next();
                        if (!loader.equalsIgnoreCase(l.getAsString())) continue;
                        supportsLoader = true;
                        break;
                    }
                    if (!supportsGame || !supportsLoader) continue;
                    String versionNumber = file.get("version_number").getAsString();
                    String date = file.get("date_published").getAsString();
                    if (publishedDate != null && date.compareTo(publishedDate) <= 0) continue;
                    bestVersion = versionNumber;
                    publishedDate = date;
                }
                latestVersion = bestVersion;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static String detectLoader() {
        return "neoforge";
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            String current;
            ServerPlayer sp = (ServerPlayer)player;
            UpdateChecker.fetchLatestVersion();
            if (latestVersion != null && !(current = ModList.get().getModContainerById("onekeyminer").map(c -> c.getModInfo().getVersion().toString()).orElse("unknown")).equals(latestVersion)) {
                sp.sendSystemMessage((Component)Component.translatable((String)"message.onekeyminer.update_available", (Object[])new Object[]{current, latestVersion}));
            }
        }
    }
}

