/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.api;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AzaleaBlock;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.NetherSproutsBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.RootsBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.chain.ChainHandler;
import org.xiyu.yee.onekeyminer.chain.InteractionHandler;
import org.xiyu.yee.onekeyminer.chain.PlantingHandler;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.config.ServerConfig;

public class ChainAPI {
    public static List<BlockPos> computeMiningPositions(ServerPlayer player, ServerLevel level, BlockPos startPos, BlockState startState, ItemStack tool) {
        List<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || startState == null || tool == null) {
            return result;
        }
        if (!ChainModeCapability.isChainModeActive((Player)player)) {
            return result;
        }
        if (startState.isAir()) {
            return result;
        }
        if (((Boolean)CommonConfig.INSTANCE.requireSneaking.get()).booleanValue() && !player.isShiftKeyDown()) {
            return result;
        }
        if (player.isCreative() && !((Boolean)CommonConfig.INSTANCE.enableInCreative.get()).booleanValue()) {
            return result;
        }
        if (!player.isCreative() && (double)player.getFoodData().getFoodLevel() < (Double)ServerConfig.INSTANCE.hungerThreshold.get()) {
            return result;
        }
        Block block = startState.getBlock();
        if (!CommonConfig.INSTANCE.isBlockMineable(block)) {
            return result;
        }
        if (!((Boolean)CommonConfig.INSTANCE.ignoreToolCompatibility.get()).booleanValue() && !player.hasCorrectToolForDrops(startState)) {
            return result;
        }
        if (!player.isCreative() && tool.isDamageableItem()) {
            double durabilityProtection = (Double)ServerConfig.INSTANCE.toolDurabilityThreshold.get();
            if ((double)tool.getDamageValue() >= (double)tool.getMaxDamage() - durabilityProtection) {
                return result;
            }
        }
        try {
            result = ChainHandler.computeMiningPositions(player, level, startPos, startState, tool);
        }
        catch (Throwable t) {
            BlockPos[] neighbors;
            if (level.getBlockState(startPos).getBlock() == startState.getBlock()) {
                result.add(startPos);
            }
            for (BlockPos neighbor : neighbors = new BlockPos[]{startPos.above(), startPos.below(), startPos.north(), startPos.south(), startPos.east(), startPos.west()}) {
                if (result.size() >= 10) break;
                if (level.getBlockState(neighbor).getBlock() != startState.getBlock()) continue;
                result.add(neighbor);
            }
        }
        return result;
    }

    public static List<BlockPos> computeInteractionPositions(ServerPlayer player, ServerLevel level, BlockPos startPos, BlockState targetState, InteractionHand hand) {
        List<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || targetState == null) {
            return result;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.isEmpty()) {
            return result;
        }
        if (heldItem.isDamageableItem() && heldItem.getDamageValue() >= heldItem.getMaxDamage() - 1) {
            return result;
        }
        try {
            result = InteractionHandler.computeInteractionPositions(player, level, startPos, targetState, hand);
        }
        catch (Throwable t) {
            BlockPos[] neighbors;
            if (level.getBlockState(startPos).getBlock() == targetState.getBlock()) {
                result.add(startPos);
            }
            for (BlockPos neighbor : neighbors = new BlockPos[]{startPos.above(), startPos.below(), startPos.north(), startPos.south(), startPos.east(), startPos.west()}) {
                if (result.size() >= 10) break;
                if (level.getBlockState(neighbor).getBlock() != targetState.getBlock()) continue;
                result.add(neighbor);
            }
        }
        return result;
    }

    public static List<BlockPos> computePlantingPositions(ServerPlayer player, ServerLevel level, BlockPos startPos, BlockState targetState, ItemStack seedItem) {
        List<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || seedItem == null) {
            return result;
        }
        try {
            result = PlantingHandler.computePlantingPositions(player, level, startPos, targetState, seedItem);
        }
        catch (Throwable t) {
            BlockPos[] neighbors;
            if (!ChainAPI.isPlantableItem(seedItem)) {
                return result;
            }
            if (ChainAPI.canPlantAt((Level)level, startPos, level.getBlockState(startPos), seedItem)) {
                result.add(startPos);
            }
            for (BlockPos neighbor : neighbors = new BlockPos[]{startPos.above(), startPos.below(), startPos.north(), startPos.south(), startPos.east(), startPos.west()}) {
                if (result.size() >= 10) break;
                if (!ChainAPI.canPlantAt((Level)level, neighbor, level.getBlockState(neighbor), seedItem)) continue;
                result.add(neighbor);
            }
        }
        return result;
    }

    private static boolean canPlantAt(Level level, BlockPos pos, BlockState state, ItemStack seedItem) {
        if (!level.isEmptyBlock(pos)) {
            return false;
        }
        BlockPos below = pos.below();
        BlockState belowState = level.getBlockState(below);
        return ChainAPI.canPlantOnSurface(seedItem.getItem(), belowState);
    }

    private static boolean canPlantOnSurface(Item item, BlockState surfaceState) {
        if (surfaceState == null) {
            return false;
        }
        Block surfaceBlock = surfaceState.getBlock();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            if (block instanceof CropBlock) {
                return surfaceBlock == Blocks.FARMLAND;
            }
            if (block instanceof SaplingBlock || block instanceof FlowerBlock) {
                return surfaceBlock == Blocks.DIRT || surfaceBlock == Blocks.GRASS_BLOCK || surfaceBlock == Blocks.PODZOL || surfaceBlock == Blocks.MYCELIUM;
            }
            if (block instanceof MushroomBlock) {
                return surfaceBlock == Blocks.MYCELIUM;
            }
            if (item == Items.POTATO || item == Items.CARROT || item == Items.WHEAT_SEEDS || item == Items.BEETROOT_SEEDS) {
                return surfaceBlock == Blocks.FARMLAND;
            }
        }
        return surfaceBlock == Blocks.DIRT || surfaceBlock == Blocks.GRASS_BLOCK || surfaceBlock == Blocks.PODZOL || surfaceBlock == Blocks.SAND || surfaceBlock == Blocks.SOUL_SAND || surfaceBlock == Blocks.MYCELIUM || surfaceBlock instanceof FarmBlock;
    }

    private static boolean isPlantableItem(ItemStack stack) {
        BlockItem blockItem;
        Block block;
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (CommonConfig.INSTANCE.isSeedBlacklisted(item)) {
            return false;
        }
        if (item instanceof BlockItem && ((block = (blockItem = (BlockItem)item).getBlock()) instanceof CropBlock || block instanceof SaplingBlock || block instanceof BushBlock || block instanceof FlowerBlock || block instanceof TallFlowerBlock || block instanceof CactusBlock || block instanceof TallGrassBlock || block instanceof FungusBlock || block instanceof RootsBlock || block instanceof NetherSproutsBlock || block instanceof CocoaBlock || block instanceof MangroveRootsBlock || block instanceof SugarCaneBlock || block instanceof NetherWartBlock || block instanceof BambooStalkBlock || block instanceof BambooSaplingBlock || block instanceof AzaleaBlock)) {
            return true;
        }
        String name = item.toString().toLowerCase();
        if (name.contains("seed") || name.contains("sapling") || name.contains("seedling") || name.contains("plant")) {
            return true;
        }
        return item == Items.WHEAT_SEEDS || item == Items.BEETROOT_SEEDS || item == Items.PUMPKIN_SEEDS || item == Items.MELON_SEEDS || item == Items.POTATO || item == Items.CARROT || item == Items.TORCHFLOWER_SEEDS || item == Items.PITCHER_POD || item == Items.SWEET_BERRIES || item == Items.GLOW_BERRIES || item == Items.CRIMSON_FUNGUS || item == Items.WARPED_FUNGUS || item == Items.COCOA_BEANS || item == Items.KELP || item == Items.BAMBOO || item == Items.SUGAR_CANE || item == Items.CACTUS || item == Items.SEA_PICKLE;
    }
}

