/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.capability;

import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ChainModeCapability {
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"onekeyminer");
    public static final DeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> CHAIN_MODE = ATTACHMENT_TYPES.register("chain_mode", () -> AttachmentType.builder(() -> Boolean.FALSE).build());

    public static void init(IEventBus modEventBus) {
        ATTACHMENT_TYPES.register(modEventBus);
        NeoForge.EVENT_BUS.addListener(ChainModeCapability::onPlayerClone);
    }

    public static boolean isChainModeActive(Player player) {
        return (Boolean)player.getData(CHAIN_MODE);
    }

    public static void setChainMode(ServerPlayer player, boolean active) {
        player.setData(CHAIN_MODE, (Object)active);
    }

    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player originalPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        if (event.isWasDeath()) {
            boolean wasChainActive = ChainModeCapability.isChainModeActive(originalPlayer);
            if (newPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)newPlayer;
                ChainModeCapability.setChainMode(serverPlayer, wasChainActive);
            } else {
                newPlayer.setData(CHAIN_MODE, (Object)wasChainActive);
            }
        }
    }
}

