/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.capability.ChainModeCapability;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.config.ServerConfig;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class ChainHandler {
    private static final Set<BlockPos> CURRENTLY_MINING = new HashSet<BlockPos>();
    private static int XPS = 0;

    public static boolean tryChainMine(ServerPlayer player, BlockPos pos, BlockState state, ItemStack tool) {
        CURRENTLY_MINING.clear();
        if (player == null || pos == null || state == null || tool == null) {
            Onekeyminer.LOGGER.debug("\u8fde\u9501\u6316\u6398\u53c2\u6570\u65e0\u6548");
            return false;
        }
        if (!ChainHandler.validateChainMiningConditions(player, pos, state, tool)) {
            return false;
        }
        String blockId = state.getBlock().getDescriptionId();
        String blockName = state.getBlock().getName().getString();
        int blocksMined = ChainHandler.performChainMining(player, pos, state, tool);
        if (blocksMined > 0) {
            ChainHandler.sendFeedback(player, blocksMined);
        }
        return blocksMined > 0;
    }

    public static List<BlockPos> computeMiningPositions(ServerPlayer player, ServerLevel level, BlockPos startPos, BlockState startState, ItemStack tool) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || startState == null || tool == null) {
            return result;
        }
        int maxBlocks = player.isCreative() ? (Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        int maxDepth = (Integer)CommonConfig.INSTANCE.maxChainDepth.get();
        boolean diagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        boolean matchFullState = (Boolean)CommonConfig.INSTANCE.matchBlockState.get();
        boolean matchseedState = (Boolean)CommonConfig.INSTANCE.matchseedBlockState.get();
        LinkedList<BlockPos> toMine = new LinkedList<BlockPos>();
        LinkedHashSet<BlockPos> minedPositions = new LinkedHashSet<BlockPos>();
        toMine.add(startPos);
        long startTime = System.currentTimeMillis();
        long timeLimit = 300L;
        int maxIterations = Math.min(5000, maxBlocks * 8);
        int iterations = 0;
        try {
            while (!toMine.isEmpty() && result.size() < maxBlocks && iterations < maxIterations && System.currentTimeMillis() - startTime <= 300L) {
                BlockState currentState;
                ++iterations;
                BlockPos currentPos = (BlockPos)toMine.poll();
                if (minedPositions.contains(currentPos) || Math.abs(currentPos.getY() - startPos.getY()) > maxDepth || !ChainHandler.isBlockMatching(startState, currentState = level.getBlockState(currentPos), matchFullState, matchseedState)) continue;
                minedPositions.add(currentPos);
                result.add(currentPos);
                for (BlockPos neighbor : ChainHandler.getNeighborPositions(currentPos, diagonal)) {
                    if (minedPositions.contains(neighbor) || toMine.size() >= maxBlocks - result.size()) continue;
                    toMine.add(neighbor);
                }
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8ba1\u7b97\u8fde\u9501\u6316\u6398\u4f4d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    private static boolean validateChainMiningConditions(ServerPlayer player, BlockPos pos, BlockState state, ItemStack tool) {
        if (!ChainModeCapability.isChainModeActive((Player)player)) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u8fde\u9501\u6a21\u5f0f\u672a\u542f\u7528");
            }
            return false;
        }
        if (state.isAir()) {
            return false;
        }
        if (((Boolean)CommonConfig.INSTANCE.requireSneaking.get()).booleanValue() && !player.isShiftKeyDown()) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u9700\u8981\u4e0b\u8e72\u4f46\u73a9\u5bb6\u672a\u4e0b\u8e72");
            }
            return false;
        }
        if (player.isCreative() && !((Boolean)CommonConfig.INSTANCE.enableInCreative.get()).booleanValue()) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u521b\u9020\u6a21\u5f0f\u4e0b\u8fde\u9501\u6316\u6398\u672a\u542f\u7528");
            }
            return false;
        }
        if (!player.isCreative() && (double)player.getFoodData().getFoodLevel() < (Double)ServerConfig.INSTANCE.hungerThreshold.get()) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u73a9\u5bb6\u9965\u997f\u5ea6\u4e0d\u8db3: {} < {}", (Object)player.getFoodData().getFoodLevel(), ServerConfig.INSTANCE.hungerThreshold.get());
            }
            return false;
        }
        Block blockId = state.getBlock();
        String blockName = state.getBlock().getName().getString();
        if (!CommonConfig.INSTANCE.isBlockMineable(blockId)) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u65b9\u5757\u5728\u4e0d\u53ef\u6316\u6398\u5217\u8868\u4e2d: {} (\u5185\u90e8ID: {})", (Object)blockName, (Object)blockId);
            }
            return false;
        }
        if (!((Boolean)CommonConfig.INSTANCE.ignoreToolCompatibility.get()).booleanValue() && !player.hasCorrectToolForDrops(state)) {
            if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                Onekeyminer.LOGGER.debug("\u5de5\u5177\u4e0d\u517c\u5bb9: {}", (Object)tool.getItem().getDescriptionId());
            }
            return false;
        }
        if (!player.isCreative() && tool.isDamageableItem()) {
            Double durabilityProtection = (Double)ServerConfig.INSTANCE.toolDurabilityThreshold.get();
            if ((double)tool.getDamageValue() >= (double)tool.getMaxDamage() - durabilityProtection) {
                if (((Boolean)CommonConfig.INSTANCE.enableDebugMode.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u5de5\u5177\u8010\u4e45\u5ea6\u4e0d\u8db3\u8fdb\u884c\u8fde\u9501\u6316\u6398");
                }
                return false;
            }
        }
        return true;
    }

    private static int performChainMining(ServerPlayer player, BlockPos startPos, BlockState startState, ItemStack tool) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return 0;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int maxBlocks = player.isCreative() ? (Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        int maxDepth = (Integer)CommonConfig.INSTANCE.maxChainDepth.get();
        boolean diagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        boolean matchFullState = (Boolean)CommonConfig.INSTANCE.matchBlockState.get();
        boolean matchseedState = (Boolean)CommonConfig.INSTANCE.matchseedBlockState.get();
        boolean teleportDrops = (Boolean)CommonConfig.INSTANCE.teleportDropsToPlayer.get();
        LinkedList<BlockPos> toMine = new LinkedList<BlockPos>();
        LinkedHashSet<BlockPos> minedPositions = new LinkedHashSet<BlockPos>();
        toMine.add(startPos);
        int blocksMined = 0;
        XPS = 0;
        while (!toMine.isEmpty() && blocksMined < maxBlocks) {
            boolean blockDestroyed;
            BlockState currentState;
            BlockPos currentPos = (BlockPos)toMine.poll();
            if (minedPositions.contains(currentPos) || Math.abs(currentPos.getY() - startPos.getY()) > maxDepth || !ChainHandler.isBlockMatching(startState, currentState = level.getBlockState(currentPos), matchFullState, matchseedState)) continue;
            minedPositions.add(currentPos);
            if (teleportDrops) {
                blockDestroyed = ChainHandler.breakBlockWithTeleport(serverLevel, currentPos, currentState, player, tool);
            } else {
                BlockEntity blockEntity = level.getBlockEntity(currentPos);
                LootParams.Builder builder = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)currentPos)).withParameter(LootContextParams.TOOL, (Object)tool).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)blockEntity);
                List drops = currentState.getDrops(builder);
                boolean hasSilkTouch = tool.getEnchantments().keySet().stream().anyMatch(holder -> holder.is(Enchantments.SILK_TOUCH));
                int xp = 0;
                Block block = currentState.getBlock();
                if (block instanceof DropExperienceBlock) {
                    DropExperienceBlock expBlock = (DropExperienceBlock)block;
                    if (!hasSilkTouch) {
                        xp = expBlock.getExpDrop(currentState, (LevelAccessor)level, currentPos, blockEntity, (Entity)player, tool);
                    }
                }
                if (!(blockDestroyed = serverLevel.destroyBlock(currentPos, false, (Entity)player))) continue;
                for (ItemStack itemStack : drops) {
                    if (itemStack.isEmpty()) continue;
                    Block.popResource((Level)level, (BlockPos)currentPos, (ItemStack)itemStack);
                }
                if (xp > 0) {
                    ExperienceOrb orb = new ExperienceOrb(level, (double)currentPos.getX() + 0.5, (double)currentPos.getY() + 0.5, (double)currentPos.getZ() + 0.5, xp);
                    level.addFreshEntity((Entity)orb);
                }
                level.playSound(null, currentPos, currentState.getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.isCreative() && tool.isDamageableItem()) {
                    tool.hurtAndBreak(1, (LivingEntity)player, player.getMainHandItem().getEquipmentSlot());
                    if (tool.isEmpty()) break;
                }
            }
            if (!blockDestroyed) continue;
            ++blocksMined;
            for (BlockPos neighbor : ChainHandler.getNeighborPositions(currentPos, diagonal)) {
                if (minedPositions.contains(neighbor) || toMine.size() >= maxBlocks - blocksMined) continue;
                toMine.add(neighbor);
            }
        }
        if (teleportDrops && XPS > 0) {
            BlockPos dropPos = player.blockPosition();
            ExperienceOrb orb = new ExperienceOrb(level, (double)dropPos.getX() + 0.5, (double)dropPos.getY() + 0.5, (double)dropPos.getZ() + 0.5, XPS);
            level.addFreshEntity((Entity)orb);
            XPS = 0;
        }
        return blocksMined;
    }

    private static boolean isBlockMatching(BlockState reference, BlockState target, boolean matchFullState, boolean matchSeedState) {
        if (target.isAir()) {
            return false;
        }
        if (matchFullState && !(target.getBlock() instanceof CropBlock) || matchSeedState && target.getBlock() instanceof CropBlock) {
            return reference.equals(target);
        }
        if (reference.getBlock() == target.getBlock()) {
            if (ChainHandler.hasSpecialMatchingRules(reference.getBlock())) {
                return ChainHandler.matchSpecialBlockProperties(reference, target);
            }
            return true;
        }
        return false;
    }

    private static boolean hasSpecialMatchingRules(Block block) {
        String blockId = block.getDescriptionId();
        return blockId.contains("ore") || blockId.contains("log") || blockId.contains("wood") || blockId.contains("leaves");
    }

    private static boolean matchSpecialBlockProperties(BlockState reference, BlockState target) {
        if (reference.getBlock().getDescriptionId().contains("ore")) {
            return true;
        }
        if (reference.getBlock().getDescriptionId().contains("log") || reference.getBlock().getDescriptionId().contains("wood")) {
            String refType = ChainHandler.extractWoodType(reference.getBlock().getDescriptionId());
            String targetType = ChainHandler.extractWoodType(target.getBlock().getDescriptionId());
            return refType.equals(targetType);
        }
        if (reference.getBlock().getDescriptionId().contains("leaves")) {
            String refType = ChainHandler.extractWoodType(reference.getBlock().getDescriptionId());
            String targetType = ChainHandler.extractWoodType(target.getBlock().getDescriptionId());
            return refType.equals(targetType);
        }
        return true;
    }

    private static String extractWoodType(String blockId) {
        for (String woodType : new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "crimson", "warped", "mangrove", "cherry"}) {
            if (!blockId.contains(woodType)) continue;
            return woodType;
        }
        return blockId;
    }

    private static boolean breakBlockWithTeleport(ServerLevel level, BlockPos pos, BlockState state, ServerPlayer player, ItemStack tool) {
        if (level == null || player == null) {
            return false;
        }
        BlockPos dropPos = player.blockPosition();
        try {
            boolean broken;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            LootParams.Builder builder = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)tool).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)blockEntity);
            List drops = state.getDrops(builder);
            boolean hasSilkTouch = tool.getEnchantments().keySet().stream().anyMatch(holder -> holder.is(Enchantments.SILK_TOUCH));
            int xp = 0;
            Block block = state.getBlock();
            if (block instanceof DropExperienceBlock) {
                DropExperienceBlock expBlock = (DropExperienceBlock)block;
                xp = hasSilkTouch ? 0 : expBlock.getExpDrop(state, (LevelAccessor)level, pos, blockEntity, (Entity)player, tool);
            }
            if (!(broken = player.level().destroyBlock(pos, false, (Entity)player))) {
                return false;
            }
            for (ItemStack itemStack : drops) {
                if (itemStack.isEmpty()) continue;
                Block.popResource((Level)level, (BlockPos)dropPos, (ItemStack)itemStack);
            }
            if (xp > 0 && !hasSilkTouch) {
                XPS += xp;
            }
            level.playSound(null, pos, state.getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative() && tool.isDamageableItem()) {
                tool.hurtAndBreak(1, (LivingEntity)player, player.getMainHandItem().getEquipmentSlot());
                if (tool.isEmpty()) {
                    return true;
                }
            }
            return true;
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u4f20\u9001\u6389\u843d\u7269\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static List<BlockPos> getNeighborPositions(BlockPos pos, boolean includeDiagonal) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>(14);
        neighbors.add(pos.above());
        neighbors.add(pos.below());
        neighbors.add(pos.north());
        neighbors.add(pos.south());
        neighbors.add(pos.east());
        neighbors.add(pos.west());
        if (includeDiagonal) {
            neighbors.add(pos.north().east());
            neighbors.add(pos.north().west());
            neighbors.add(pos.south().east());
            neighbors.add(pos.south().west());
            neighbors.add(pos.above().north());
            neighbors.add(pos.above().south());
            neighbors.add(pos.above().east());
            neighbors.add(pos.above().west());
            neighbors.add(pos.below().north());
            neighbors.add(pos.below().south());
            neighbors.add(pos.below().east());
            neighbors.add(pos.below().west());
            neighbors.add(pos.above().north().east());
            neighbors.add(pos.above().north().west());
            neighbors.add(pos.above().south().east());
            neighbors.add(pos.above().south().west());
            neighbors.add(pos.below().north().east());
            neighbors.add(pos.below().north().west());
            neighbors.add(pos.below().south().east());
            neighbors.add(pos.below().south().west());
        }
        return neighbors;
    }

    private static void sendFeedback(ServerPlayer player, int blocksMined) {
        NetworkHandler.sendToPlayer(new ChainActionPacket("mining", blocksMined), player);
    }
}

