/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.yee.onekeyminer.chain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.xiyu.yee.onekeyminer.Onekeyminer;
import org.xiyu.yee.onekeyminer.api.ChainPositionStore;
import org.xiyu.yee.onekeyminer.config.ClientConfig;
import org.xiyu.yee.onekeyminer.config.CommonConfig;
import org.xiyu.yee.onekeyminer.network.ChainActionPacket;
import org.xiyu.yee.onekeyminer.network.NetworkHandler;

public class InteractionHandler {
    private static final Set<BlockPos> PROCESSED_POSITIONS = new HashSet<BlockPos>();
    private static final Set<Integer> PROCESSED_ENTITY_IDS = new HashSet<Integer>();

    public static boolean isValidInteractionTool(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        return item instanceof HoeItem || item instanceof AxeItem || item instanceof ShovelItem || item instanceof ShearsItem || item instanceof BrushItem;
    }

    public static List<BlockPos> computeInteractionPositions(ServerPlayer player, ServerLevel level, BlockPos startPos, BlockState targetState, InteractionHand hand) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        if (player == null || level == null || startPos == null || targetState == null) {
            return result;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.isEmpty() || !InteractionHandler.isValidInteractionTool(heldItem)) {
            return result;
        }
        if (targetState.isAir()) {
            return result;
        }
        int maxBlocks = player.isCreative() ? (Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        int maxDepth = (Integer)CommonConfig.INSTANCE.maxChainDepth.get();
        boolean includeDiagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        LinkedList<BlockSearchNode> queue = new LinkedList<BlockSearchNode>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(new BlockSearchNode(startPos, 0));
        long startTime = System.currentTimeMillis();
        long timeLimit = 300L;
        int maxIterations = Math.min(5000, maxBlocks * 8);
        int iterations = 0;
        try {
            while (!queue.isEmpty() && result.size() < maxBlocks && iterations < maxIterations && System.currentTimeMillis() - startTime <= 300L) {
                ++iterations;
                BlockSearchNode node = (BlockSearchNode)queue.poll();
                BlockPos pos = node.pos;
                if (node.depth > maxDepth || visited.contains(pos)) continue;
                visited.add(pos);
                BlockState state = level.getBlockState(pos);
                if (!InteractionHandler.isMatchingBlock(state, targetState)) continue;
                result.add(pos);
                for (BlockPos neighbor : InteractionHandler.getNeighborPositions(pos, includeDiagonal)) {
                    if (visited.contains(neighbor)) continue;
                    queue.offer(new BlockSearchNode(neighbor, node.depth + 1));
                }
            }
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.error("\u8ba1\u7b97\u8fde\u9501\u4ea4\u4e92\u4f4d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    @Deprecated
    public static void handleChainInteraction(ServerPlayer player, PlayerInteractEvent.RightClickBlock event) {
        InteractionHandler.tryChainInteraction(player, (ServerLevel)event.getLevel(), event.getPos(), event.getFace(), event.getHitVec().getLocation(), event.getHand());
    }

    public static boolean tryChainInteraction(ServerPlayer player, ServerLevel level, BlockPos pos, Direction side, Vec3 hitVec, InteractionHand hand) {
        PROCESSED_POSITIONS.clear();
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.isEmpty() || !InteractionHandler.isValidInteractionTool(heldItem)) {
            return false;
        }
        BlockState initialState = level.getBlockState(pos);
        if (initialState.isAir()) {
            return false;
        }
        if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u5c1d\u8bd5\u8fde\u9501\u4ea4\u4e92: {}", (Object)initialState.getBlock().getDescriptionId());
        }
        BlockHitResult initialHit = new BlockHitResult(hitVec, side, pos, false);
        int maxBlocks = player.isCreative() ? (Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        boolean includeDiagonal = (Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get();
        int processedCount = InteractionHandler.floodFillInteraction(player, level, initialState, initialHit, hand, maxBlocks, (Integer)CommonConfig.INSTANCE.maxChainDepth.get(), includeDiagonal);
        if (processedCount > 0) {
            NetworkHandler.sendToPlayer(new ChainActionPacket("interaction", processedCount), player);
            return true;
        }
        return false;
    }

    private static int floodFillInteraction(ServerPlayer player, ServerLevel level, BlockState targetState, BlockHitResult initialHit, InteractionHand hand, int maxBlocks, int maxDepth, boolean includeDiagonal) {
        LinkedList<BlockSearchNode> queue = new LinkedList<BlockSearchNode>();
        queue.add(new BlockSearchNode(initialHit.getBlockPos(), 0));
        int processedCount = 0;
        ItemStack heldItem = player.getItemInHand(hand);
        while (!queue.isEmpty() && processedCount < maxBlocks) {
            BlockState state;
            BlockSearchNode node = (BlockSearchNode)queue.poll();
            BlockPos pos = node.pos;
            if (node.depth > maxDepth || PROCESSED_POSITIONS.contains(pos) || !InteractionHandler.isMatchingBlock(state = level.getBlockState(pos), targetState)) continue;
            if (heldItem.isEmpty() || heldItem.getDamageValue() >= heldItem.getMaxDamage() - 1) break;
            PROCESSED_POSITIONS.add(pos);
            BlockHitResult hit = new BlockHitResult(initialHit.getLocation(), initialHit.getDirection(), pos, false);
            UseOnContext context = new UseOnContext((Player)player, hand, hit);
            InteractionResult result = heldItem.useOn(context);
            if (result.consumesAction()) {
                ++processedCount;
                if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                    Onekeyminer.LOGGER.debug("\u8fde\u9501\u4ea4\u4e92\u6210\u529f: {}", (Object)pos);
                }
            }
            for (BlockPos neighbor : InteractionHandler.getNeighborPositions(pos, includeDiagonal)) {
                queue.offer(new BlockSearchNode(neighbor, node.depth + 1));
            }
        }
        Onekeyminer.LOGGER.debug("\u8fde\u9501\u4ea4\u4e92\u5b8c\u6210\uff0c\u5171\u5904\u7406 {} \u4e2a\u65b9\u5757", (Object)processedCount);
        return processedCount;
    }

    private static boolean isMatchingBlock(BlockState state, BlockState target) {
        if (state.isAir() || target.isAir()) {
            return false;
        }
        if (((Boolean)CommonConfig.INSTANCE.matchBlockState.get()).booleanValue() && !(target.getBlock() instanceof CropBlock) || ((Boolean)CommonConfig.INSTANCE.matchseedBlockState.get()).booleanValue() && target.getBlock() instanceof CropBlock) {
            return state.equals(target);
        }
        return state.getBlock() == target.getBlock();
    }

    private static List<BlockPos> getNeighborPositions(BlockPos pos, boolean includeDiagonal) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        neighbors.add(pos.above());
        neighbors.add(pos.below());
        neighbors.add(pos.north());
        neighbors.add(pos.south());
        neighbors.add(pos.east());
        neighbors.add(pos.west());
        if (includeDiagonal) {
            neighbors.add(pos.north().east());
            neighbors.add(pos.north().west());
            neighbors.add(pos.south().east());
            neighbors.add(pos.south().west());
            neighbors.add(pos.above().north());
            neighbors.add(pos.above().south());
            neighbors.add(pos.above().east());
            neighbors.add(pos.above().west());
            neighbors.add(pos.below().north());
            neighbors.add(pos.below().south());
            neighbors.add(pos.below().east());
            neighbors.add(pos.below().west());
            neighbors.add(pos.above().north().east());
            neighbors.add(pos.above().north().west());
            neighbors.add(pos.above().south().east());
            neighbors.add(pos.above().south().west());
            neighbors.add(pos.below().north().east());
            neighbors.add(pos.below().north().west());
            neighbors.add(pos.below().south().east());
            neighbors.add(pos.below().south().west());
        }
        return neighbors;
    }

    public static boolean tryChainShearing(ServerPlayer player, Sheep targetSheep, InteractionHand hand) {
        PROCESSED_ENTITY_IDS.clear();
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.isEmpty() || !(heldItem.getItem() instanceof ShearsItem)) {
            return false;
        }
        if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u5c1d\u8bd5\u8fde\u9501\u526a\u7f8a\u6bdb: {}", (Object)targetSheep.getId());
        }
        int maxEntities = player.isCreative() ? (Integer)CommonConfig.INSTANCE.maxBlocksInChainCreative.get() : (Integer)CommonConfig.INSTANCE.maxBlocksInChain.get();
        double searchRadius = (double)((Integer)CommonConfig.INSTANCE.maxChainDepth.get()).intValue() * 0.5;
        if (((Boolean)CommonConfig.INSTANCE.enableDiagonalChaining.get()).booleanValue()) {
            searchRadius *= 1.5;
        }
        PROCESSED_ENTITY_IDS.add(targetSheep.getId());
        boolean teleportDrops = (Boolean)CommonConfig.INSTANCE.teleportDropsToPlayer.get();
        BlockPos playerPos = player.blockPosition();
        ServerLevel level = (ServerLevel)player.level();
        AABB searchBox = new AABB(targetSheep.getX() - searchRadius, targetSheep.getY() - searchRadius, targetSheep.getZ() - searchRadius, targetSheep.getX() + searchRadius, targetSheep.getY() + searchRadius, targetSheep.getZ() + searchRadius);
        List allSheepInArea = level.getEntitiesOfClass(Sheep.class, searchBox, sheep -> sheep.isAlive() && sheep.readyForShearing() && !PROCESSED_ENTITY_IDS.contains(sheep.getId()));
        if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u627e\u5230 {} \u53ea\u53ef\u526a\u7f8a", (Object)(allSheepInArea.size() + 1));
        }
        int shearedCount = 1;
        ArrayList<UUID> shearingUuids = new ArrayList<UUID>();
        shearingUuids.add(targetSheep.getUUID());
        for (Sheep s : allSheepInArea) {
            shearingUuids.add(s.getUUID());
        }
        try {
            String key = player.getUUID().toString();
            ChainPositionStore.setShearingEntityUuids(key, shearingUuids);
        }
        catch (Exception e) {
            Onekeyminer.LOGGER.debug("\u5199\u5165\u526a\u7f8a UUID \u5217\u8868\u5230 ChainPositionStore \u65f6\u51fa\u9519: {}", (Object)e.getMessage());
        }
        for (Sheep sheep2 : allSheepInArea) {
            if (shearedCount >= maxEntities) break;
            try {
                if (!sheep2.isShearable((Player)player, heldItem, player.level(), sheep2.blockPosition()) || !sheep2.readyForShearing()) continue;
                boolean wasShearable = sheep2.readyForShearing();
                int woolColorBefore = sheep2.getColor().getId();
                boolean shearingSuccessful = false;
                if (teleportDrops) {
                    double originalX = sheep2.getX();
                    double originalY = sheep2.getY();
                    double originalZ = sheep2.getZ();
                    try {
                        sheep2.setPos((double)playerPos.getX(), (double)playerPos.getY(), (double)playerPos.getZ());
                        if (sheep2.readyForShearing()) {
                            List items = sheep2.onSheared((Player)player, heldItem, (Level)level, sheep2.blockPosition());
                            boolean bl = shearingSuccessful = !items.isEmpty();
                            if (shearingSuccessful && !player.getAbilities().instabuild) {
                                heldItem.hurtAndBreak(1, (LivingEntity)player, player.getMainHandItem().getEquipmentSlot());
                            }
                            items.forEach(itemStack -> {
                                ItemEntity itemEntity = new ItemEntity((Level)level, sheep2.getX(), sheep2.getY(1.0), sheep2.getZ(), itemStack);
                                level.addFreshEntity((Entity)itemEntity);
                            });
                            if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                                Onekeyminer.LOGGER.debug("\u526a\u7f8a\u72b6\u6001: \u4f7f\u7528onSheared\u65b9\u6cd5={}, \u6389\u843d\u7269\u6570\u91cf={}", (Object)true, (Object)items.size());
                            }
                        }
                        sheep2.setPos(originalX, originalY, originalZ);
                    }
                    catch (Exception e) {
                        Onekeyminer.LOGGER.error("\u4f20\u9001\u7f8a\u6bdb\u6389\u843d\u7269\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
                        sheep2.setPos(originalX, originalY, originalZ);
                    }
                } else if (sheep2.readyForShearing()) {
                    List items = sheep2.onSheared((Player)player, heldItem, (Level)level, sheep2.blockPosition());
                    boolean bl = shearingSuccessful = !items.isEmpty();
                    if (shearingSuccessful && !player.getAbilities().instabuild) {
                        heldItem.hurtAndBreak(1, (LivingEntity)player, player.getMainHandItem().getEquipmentSlot());
                    }
                    items.forEach(itemStack -> {
                        ItemEntity itemEntity = new ItemEntity((Level)level, sheep2.getX(), sheep2.getY(1.0), sheep2.getZ(), itemStack);
                        level.addFreshEntity((Entity)itemEntity);
                    });
                    if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                        Onekeyminer.LOGGER.debug("\u526a\u7f8a\u72b6\u6001: \u4f7f\u7528onSheared\u65b9\u6cd5={}, \u6389\u843d\u7269\u6570\u91cf={}", (Object)true, (Object)items.size());
                    }
                }
                if (shearingSuccessful) {
                    PROCESSED_ENTITY_IDS.add(sheep2.getId());
                    ++shearedCount;
                    if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
                        Onekeyminer.LOGGER.debug("\u6210\u529f\u526a\u4e86\u7f8a {}", (Object)sheep2.getId());
                    }
                    if (!heldItem.isEmpty()) continue;
                    break;
                }
                if (!((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) continue;
                Onekeyminer.LOGGER.debug("\u526a\u7f8a {} \u5931\u8d25\uff0c\u5c3d\u7ba1\u5b83\u5e94\u8be5\u662f\u53ef\u526a\u7684", (Object)sheep2.getId());
            }
            catch (Exception e) {
                Onekeyminer.LOGGER.error("\u5904\u7406\u7f8a {} \u65f6\u51fa\u9519: {}", (Object)sheep2.getId(), (Object)e.getMessage());
            }
        }
        if (((Boolean)ClientConfig.INSTANCE.Debug.get()).booleanValue()) {
            Onekeyminer.LOGGER.debug("\u6210\u529f\u526a\u4e86 {} \u53ea\u7f8a", (Object)shearedCount);
        }
        if (shearedCount > 1 && ((Boolean)ClientConfig.INSTANCE.showBlockCount.get()).booleanValue()) {
            String messageStyle = (String)ClientConfig.INSTANCE.messageStyle.get();
            if (messageStyle.equals("chat") || messageStyle.equals("both")) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.onekeyminer.chain_shearing", (Object[])new Object[]{shearedCount}));
            }
            if (messageStyle.equals("actionbar") || messageStyle.equals("both")) {
                NetworkHandler.sendToPlayer(new ChainActionPacket("shearing", shearedCount), player);
            }
            return true;
        }
        return shearedCount > 1;
    }

    private static class BlockSearchNode {
        final BlockPos pos;
        final int depth;

        BlockSearchNode(BlockPos pos, int depth) {
            this.pos = pos;
            this.depth = depth;
        }
    }
}

